/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.session;

import java.net.URLEncoder;
import org.apache.catalina.Globals;


/**
 * Representation of the session cookie configuration element for a web 
 * application.
 *
 * This configuration is not specified as part of the standard deployment
 * descriptor but as part of the iAS 7.0's "extended" web application
 * deployment descriptor - ias-web.xml.
 *
 * NOTICE: THIS FILE HAS BEEN DEACTIVATED AND WILL BE REMOVED FROM CVS.
 *
 * IT HAS BEEN REPLACED BY THIS FILE:
 *
 * pwc-commons/src/java/com/sun/enterprise/web/session/SessionCookieConfig.java
 */

public final class SessionCookieConfig {

    // ----------------------------------------------------- Manifest Constants

    /**
     * The default value for the session tracking cookie's comment.
     */
    public static final String SESSION_COOKIE_DEFAULT_COMMENT =
        URLEncoder.encode("Sun ONE Application Server Session Tracking Cookie");

    // ----------------------------------------------------------- Constructors

    /**
     * Construct a new SessionCookieConfig with default properties.
     */
    public SessionCookieConfig() {
        super();
    }

    // ----------------------------------------------------- Instance Variables

    /**
     * The name of the cookie used for session tracking.
     *
     * Default value is JSESSIONID
     */
    private String _name = Globals.SESSION_COOKIE_NAME;

    /**
     * The pathname that is set when the cookie is created.
     *
     * The default value is the context path at which the web application
     * is installed.  The browser will send the cookie if the pathname for the
     * request contains this pathname. If set to / (slash), the browser will
     * send the cookie to all URLs.
     */
    private String _path = null;

    /**
     * The expiration time in seconds after which the browser expires
     * the cookie.
     *
     * The default value is -1 (never expire).
     */
    private int _maxAge = -1;

    /**
     * The domain for which the cookie is valid.
     */
    private String _domain = null;

    /**
     * The comment that identifies the session tracking cookie in the
     * browser's cookie file. Applications may choose to provide a more
     * specific name for this cookie.
     */
    private String _comment = SESSION_COOKIE_DEFAULT_COMMENT;

    /**
     * Construct a new SessionCookieConfig with the specified properties.
     *
     * @param name    The name of the cookie used for session tracking
     * @param path    The pathname that is set when the cookie is created
     * @param maxAge  The expiration time (in seconds) of the session cookie
     *                (-1 indicates 'never expire')
     * @param domain  The domain for which the cookie is valid
     * @param comment The comment that identifies the session tracking cookie
     *                in the cookie file.
     */
    public SessionCookieConfig(String name, String path, int maxAge,
                               String domain, String comment) {
        super();
        setName(name);
        setPath(path);
        setMaxAge(maxAge);
        setDomain(domain);
        setComment(comment);
    }

    // ------------------------------------------------------------- Properties

    /**
     * Set the name of the session tracking cookie (currently not supported).
     */
    public void setName(String name) {
        _name = name;
    }

    /**
     * Return the name of the session tracking cookie.
     */
    public String getName() {
        return _name;
    }

    /**
     * Set the path to use when creating the session tracking cookie.
     */
    public void setPath(String path) {
        _path = path;
    }

    /**
     * Return the path that is set when the session tracking cookie is
     * created.
     */
    public String getPath() {
        return _path;
    }

    /**
     * Set the expiration time for the session cookie.
     */
    public void setMaxAge(int maxAge) {
        _maxAge = maxAge;
    }

    /**
     * Return the expiration time for the session cookie.
     */
    public int getMaxAge() {
        return _maxAge;
    }

    /**
     * Set the domain for which the cookie is valid.
     */
    public void setDomain(String domain) {
        _domain = domain;
    }

    /**
     * Return the domain for which the cookie is valid.
     */
    public String getDomain() {
        return _domain;
    }

    /**
     * Set the comment that identifies the session cookie.
     */
    public void setComment(String comment) {
        _comment = URLEncoder.encode(comment);
    }

    /**
     * Return the URLEncoded form of the comment that identifies the session
     * cookie.
     */
    public String getComment() {
        return _comment;
    }

    // --------------------------------------------------------- Public Methods

    /**
     * Return a String representation of this object.
     */
    public String toString() {

        StringBuffer sb = new StringBuffer("SessionCookieConfig[");
        sb.append("name=");
        sb.append(_name);
        if (_path != null) {
            sb.append(", path=");
            sb.append(_path);
        }
        sb.append(", maxAge=");
        sb.append(_maxAge);
        if (_domain != null) {
            sb.append(", domain=");
            sb.append(_domain);
        }
        if (_comment != null) {
            sb.append(", comment=");
            sb.append(_comment);
        }
        sb.append("]");
        return (sb.toString());

    }
}
