/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice;

import java.util.Set;
import java.util.Iterator;

import java.util.logging.Level;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Binding;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.Dispatch;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.webservice.spi.InvInterfaceCreationListener;
import com.sun.enterprise.deployment.NameValuePairDescriptor;

/**
 * Listens to all port creation for a particular Service
 *
 * @author Jerome Dochez
 */
public class InvInterfaceCreationListenerImpl implements InvInterfaceCreationListener {
    
    ServiceReferenceDescriptor ref;
    
    /** Creates a new instance of PortCreationListenerImpl */
    public InvInterfaceCreationListenerImpl(ServiceReferenceDescriptor ref) {
        this.ref = ref;
    }
    
    /**
     * Notification of a new port created on the service instance.
     * @param port being created.
     * @param interface type
     */
    public <T> void portCreated(T port, Class<T> serviceEndpointInterface) {
        
        ServiceRefPortInfo portInfo = ref.getPortInfoBySEI(serviceEndpointInterface.getName());
        if (portInfo!=null) {          
            // Set MTOM for this port
            BindingProvider bProv = (BindingProvider) port;
            boolean mtomEnabled = false;
            if(portInfo.getMtomEnabled() != null &&
                (new Boolean(portInfo.getMtomEnabled())).booleanValue()) {
                mtomEnabled = true;
            }
            if (mtomEnabled) {
                Binding bType = bProv.getBinding();
                // enable mtom valid only for SOAPBindings
                if(SOAPBinding.class.isAssignableFrom(bType.getClass())) {
                    ((SOAPBinding)bType).setMTOMEnabled(true);
                } else {
                    WsUtil.getDefaultLogger().log(Level.SEVERE,
                            WsUtil.getDefaultStringManager().getLocalString("serviceref.invalidmtom",
                            "MTOM is valid only for SOAP Bindings; Ignoring Enable-MTOM for port {0}",
                            new Object[] {serviceEndpointInterface}));
                }
            }
            
            // Set stub properties
            Set properties = portInfo.getStubProperties();            
            for(Iterator iter = properties.iterator(); iter.hasNext();) {
                NameValuePairDescriptor next = (NameValuePairDescriptor) 
                    iter.next();
                bProv.getRequestContext().put(next.getName(), next.getValue());
            }
        }
    }
    
    /**
     * Notification of a dispatch instance creation. The dispatch creation is 
     * blocked until the method returns so lengthly process should be done
     * asynchronously
     * @param dispatch instance
     * @param service endpoint interface type
     */
    public <T> void dispatchCreated(Dispatch<T> dispatch, Class<T> serviceEndpointInterface) {
        
    }    
        
}
