/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.connector;

import java.io.File;
import java.io.IOException;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.verifier.BaseVerifier;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.SpecVersionMapper;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.ConnectorClosureCompiler;
import com.sun.enterprise.util.io.FileUtils;

/**
 * @author Vikas Awasthi
 */
public class ConnectorVerifier extends BaseVerifier {

    private ConnectorDescriptor cond = null;
    private String classPath;//this is lazily populated in getClassPath()
    private boolean isASMode = false;

    public ConnectorVerifier(FrameworkContext frameworkContext,
                             ConnectorDescriptor cond) {
        this.frameworkContext = frameworkContext;
        this.cond = cond;
        this.isASMode = !frameworkContext.isPortabilityMode();
    }

    public void verify() throws Exception {
        if (areTestsNotRequired(frameworkContext.isConnector()))
            return;

        preVerification();
        createClosureCompiler();//this can be moved up to base verifier in future.
        verify(cond, new ConnectorCheckMgrImpl(frameworkContext));
    }

    public Descriptor getDescriptor() {
        return cond;
    }

    protected ClassLoader createClassLoader()
            throws IOException {
        return cond.getClassLoader();
    }

    protected String getArchiveUri() {
        return FileUtils.makeFriendlyFileName(cond.getModuleDescriptor().getArchiveUri());
    }

    protected String[] getDDString() {
        String dd[] = {"META-INF/sun-ra.xml", "META-INF/ra.xml"}; // NOI18N
        return dd;
    }

    /**
     * Creates and returns the class path associated with the rar.
     * Uses the exploded location of the archive for generating the classpath.
     *
     * @return entire classpath string
     * @throws IOException
     */
    protected String getClassPath() throws IOException {
        if (classPath != null) return classPath;

        if(isASMode)
            return (classPath = getClassPath(frameworkContext.getClassPath()));

        String cp;
        if (!cond.getModuleDescriptor().isStandalone()) {
            //take the cp from the enclosing ear file
            String ear_uri = frameworkContext.getExplodedArchivePath();
            File ear = new File(ear_uri);
            assert(ear.isDirectory());
            cp = ClassPathBuilder.buildClassPathForEar(ear);
            String libdir = cond.getApplication().getLibraryDirectory();
            if (libdir!=null) {
                cp = getLibdirClasspath(ear_uri, libdir) + cp;
            }
            /** buildClasspathForEar takes care of embedded rars.*/
/*
            //this is a relative path
            String module_uri = cond.getModuleDescriptor().getArchiveUri();
            File module = new File(module_uri);
            assert(module.isFile() && !module.isAbsolute());
            // exploder creates the directory replacing all dots by '_'
            File explodedModuleDir = new File(ear_uri,
                    FileUtils.makeFriendlyFileName(module_uri));
            String moduleCP = ClassPathBuilder.buildClassPathForRar(
                    explodedModuleDir);
            cp = moduleCP + File.pathSeparator + earCP;
*/
        } else {
            //this is an absolute path
            String module_uri = frameworkContext.getExplodedArchivePath();
            File module = new File(module_uri);
            assert(module.isDirectory() && module.isAbsolute());
            cp = ClassPathBuilder.buildClassPathForRar(module);
        }
        return (classPath = cp);
    }

    /**
     * creates the ClosureCompiler for the rar module and sets it to the
     * verifier context. This is used to compute the closure on the classes used
     * in the rar.
     *
     * @throws IOException
     */
    protected void createClosureCompiler() throws IOException {
        String specVer = SpecVersionMapper.getJCAVersion(
                frameworkContext.getJavaEEVersion());
        Object arg = (isASMode)?cond.getClassLoader():(Object)getClassPath();
        ConnectorClosureCompiler cc = new ConnectorClosureCompiler(specVer,
                ClassFileLoaderFactory.newInstance(new Object[]{arg}));
        context.setClosureCompiler(cc);
    }
}
