/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests.appclient;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.Result;
import java.util.List;
import java.util.ArrayList;
import java.net.URI;
import java.net.URISyntaxException;

/**
 * Assertions :
 *
 *  1) A persistence unit with JTA transaction type is not supported in application client.
 *  2) Reference to a PU whose transaction type is JTA is not supported in application client.
 *
 * @author bshankar@sun.com
 */

public class PUTransactionType extends VerifierTest implements VerifierCheck {
    
    public Result check(Descriptor descriptor) {
        ApplicationClientDescriptor appClient = (ApplicationClientDescriptor) descriptor;
        Result result = getInitializedResult();
        addErrorDetails(result, getVerifierContext().getComponentNameConstructor());
        result.setStatus(Result.PASSED); // default status is PASSED
        
        for(PersistenceUnitsDescriptor pus : appClient.getPersistenceUnitsDescriptors()) {
            for(PersistenceUnitDescriptor nextPU : pus.getPersistenceUnitDescriptors()) {
                if("JTA".equals(nextPU.getTransactionType())) {
                    result.failed(smh.getLocalString(getClass().getName() + ".puName",
                            "Found a persistence unit by name [ {0} ] in persistence unit root [ {1} ] with JTA transaction type.",
                            new Object[]{nextPU.getName(), nextPU.getPuRoot()}));
                }
            }
        }
        
        for(EntityManagerFactoryReferenceDescriptor emfRef : appClient.getEntityManagerFactoryReferenceDescriptors()) {
            String unitName = emfRef.getUnitName();
            PersistenceUnitDescriptor nextPU = appClient.findReferencedPU(unitName);
            if(nextPU == null) continue;
            if("JTA".equals(nextPU.getTransactionType())) {
                result.failed(smh.getLocalString(getClass().getName() + ".puRefName",
                        "Found a reference to a persistence unit by name [ {0} ] in persistence unit root [ {1} ] with JTA transaction type.",
                        new Object[]{nextPU.getName(), nextPU.getPuRoot()}));
            }
        }
        
        return result;
    }
    
}
