/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import java.util.Iterator;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;

/**
 * The ejb-name must be unique amoung the names of the enterprise beans within
 * the same ejb-jar file.
 */
public class EjbNameUnique extends EjbTest implements EjbCheck {

    /**
     * The ejb-name must be unique amoung the names of the enterprise beans within
     * the same ejb-jar file.
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

        Result result = getInitializedResult();
        String ejbName = descriptor.getName();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        // initialize needed by ejb loop
        int found = 0;

        // The ejb-name must be unique amoung the names of the enterprise beans
        // within the same ejb-jar file.
        // i.e. need to loop through all ejb's within this jar and get their
        // respective ejbName's, then do a string compare and make sure their are
        // no duplicates.
        for (Iterator itr =descriptor.getEjbBundleDescriptor().getEjbs().iterator();
             itr.hasNext();) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor) itr.next();
            if (ejbDescriptor.getName().equals(ejbName)) {
                found++;
                if (found > 1) {
                    addErrorDetails(result, compName);
                    result.failed(smh.getLocalString
                            (getClass().getName() + ".failed",
                            "Error: [ {0} ] has found [ {1} ] duplicate ejb name(s) within the same jar.",
                            new Object[] {ejbName, new Integer((found - 1))}));
                }
            }
        }
        
        if (result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                    (getClass().getName() + ".passed",
                    "Valid: [ {0} ] was found once within jar, ejb-name is unique.",
                    new Object[] {ejbName}));
        }
        return result;
    }
}
