/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests.ejb.messagebean;

import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.jms.IASJmsUtil;
import com.sun.enterprise.tools.verifier.tests.*;


/**
 * Verify that message beans message-selector is valid
 *
 * @author  Jerome Dochez
 * @version 
 */
public class HasValidMessageSelector extends MessageBeanTest {

    /** 
     * Run a verifier test against an individual declared message
     * drive bean component
     * 
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbMessageBeanDescriptor descriptor) {
        
        Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        String messageSelector = descriptor.getJmsMessageSelector();
        if (messageSelector != null) {
            try {
                IASJmsUtil.validateJMSSelector(messageSelector);
        	result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));	
		result.passed(smh.getLocalString
	            ("com.sun.enterprise.tools.verifier.tests.ejb.messagebean.HasValidMessageSelector.failed",
                    "Message-driven bean [ {0} ] defines a valid message selector",
                    new Object[] {descriptor.getName()}));                                            
            } catch (Exception e) {
        	result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		result.failed(smh.getLocalString
	            ("com.sun.enterprise.tools.verifier.tests.ejb.messagebean.HasValidMessageSelector.failed",
                    "Error : Message-driven bean [ {0} ] defines an invalid message selector",
                    new Object[] {descriptor.getName()}));                            
            }           
        } else {
	    result.addNaDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
		("com.sun.enterprise.tools.verifier.tests.ejb.messagebean.HasValidMessageSelector.notApplicable",
                 "Message-driven bean [ {0} ] does not define a message selector",
                new Object[] {descriptor.getName()}));            
        }
        return result;
    }
}
