/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests.ejb.messagebean;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.SpecVersionMapper;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ContainerTransaction;

import java.util.Collection;
import java.util.Iterator;

/**
 * Message-driven beans with container-managed transaction demarcation must use
 * Required or NotSupported transaction attribute.
 *
 * @author  Jerome Dochez
 * @version 
 */
public class HasValidMethodDescriptor extends MessageBeanTest {

  /** 
   * Run a verifier test against an individual declared message
   * drive bean component
   * 
   * @param descriptor the Enterprise Java Bean deployment descriptor
   * @return <code>Result</code> the results for this assertion
   */
  public Result check(EjbMessageBeanDescriptor descriptor) {

    Result result = getInitializedResult();
    ComponentNameConstructor compName = 
      getVerifierContext().getComponentNameConstructor();

    if (descriptor.getTransactionType().equals
        (EjbDescriptor.CONTAINER_TRANSACTION_TYPE)) {

      // returns the Message Listener methods and "ejbTimeout" if the bean is a
      // TimedObject. 
      Collection methods = descriptor.getTransactionMethodDescriptors();

      if (methods.size()==0) {
        addNaDetails(result, compName);
        result.notApplicable(smh.getLocalString
            (getClass().getName()+".notApplicable1",
             "Message-driven bean [ {0} ] does not define any method",
             new Object[] {descriptor.getName()}));                            
        return result;
      }

      Iterator iterator = methods.iterator();
      while(iterator.hasNext())
      {
        MethodDescriptor method = (MethodDescriptor) iterator.next();
        // if the MDB is also a TimedObject then don't check the
        // transaction attribute of ejbTimeout. The
        // timer/HasValidEjbTimeout test will check the transaction
        // attribute for ejbTimeout

        if( descriptor.isTimedObject() &&
            (method.getName()).equals("ejbTimeout") )
          continue;
        ContainerTransaction txAttr = descriptor.
          getContainerTransactionFor(method);
        if(txAttr == null)
        {
            if(getVerifierContext().getJavaEEVersion().compareTo(SpecVersionMapper.JavaEEVersion_5)<0) {
          // transaction attribute is not specified for method.
          addErrorDetails(result, compName);
          result.failed(smh.getLocalString
              (getClass().getName()+".failed4",
               "Error : Message-driven bean [ {0} ] method definition [ {1} ] does not have a valid container transaction descriptor.",
               new Object[] {descriptor.getName(), method.getName()}));                                 
            } // default transaction attr in EJB 3.0 is REQUIRED
          continue;
        }
        String ta = txAttr.getTransactionAttribute();
        if (ContainerTransaction.REQUIRED.equals(ta) || 
            ContainerTransaction.NOT_SUPPORTED.equals(ta)) {
          addGoodDetails(result, compName);
          result.passed(smh.getLocalString
              (getClass().getName()+".passed",
               "Message-driven bean [ {0} ] method definition [ {1} ] in assembly-descriptor is correct",
               new Object[] {descriptor.getName(), method.getName()}));                                            
        } else {
          addErrorDetails(result, compName);
          result.failed(smh.getLocalString
              (getClass().getName()+".failed3",
               "Error : Message-driven bean [ {0} ] method definition [ {1} ] transaction attribute must be Required or NotSupported",
               new Object[] {descriptor.getName(), method.getName()}));                                 
        }
      }
      return result;                    
    } else {
      addNaDetails(result, compName);
      result.notApplicable(smh.getLocalString
          (getClass().getName()+".notApplicable2",
           "Message-driven bean [ {0} ] does not use container-managed transaction",
           new Object[] {descriptor.getName()})); 
    }
    return result;
  }
}
