/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import java.util.Enumeration;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;

/**
 * Optionally implemented SessionSynchronization interface transaction 
 * demarcation test.
 * If an enterprise bean implements the javax.ejb.SessionSynchronization
 * interface, the Application Assembler can specify only the following values
 * for the transaction attributes of the bean's methods:
 *   Required
 *   RequiresNew
 *   Mandatory
 */
public class TransactionDemarcationSessionSynchronizationInterface extends EjbTest implements EjbCheck {


    /**
     * Optionally implemented SessionSynchronization interface transaction 
     * demarcation test.
     * If an enterprise bean implements the javax.ejb.SessionSynchronization
     * interface, the Application Assembler can specify only the following values
     * for the transaction attributes of the bean's methods:
     *   Required
     *   RequiresNew
     *   Mandatory
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        boolean oneFound = false;

        if (descriptor instanceof EjbSessionDescriptor) {
            try {
                Context context = getVerifierContext();
                ClassLoader jcl = context.getClassLoader();
                Class c = Class.forName(descriptor.getEjbClassName(), false, getVerifierContext().getClassLoader());
                // walk up the class tree
                do {
                    Class[] interfaces = c.getInterfaces();

                    for (int i = 0; i < interfaces.length; i++) {
                        if (interfaces[i].getName().equals("javax.ejb.SessionSynchronization")) {
                            oneFound = true;
                            break;
                        }
                    }
                } while ((c=c.getSuperclass()) != null);

            } catch (ClassNotFoundException e) {
                Verifier.debug(e);
                addErrorDetails(result, compName);
                result.failed(smh.getLocalString
                        (getClass().getName() + ".failedException1",
                                "Error: [ {0} ] class not found.",
                                new Object[] {descriptor.getEjbClassName()}));
                return result;
            }

            // If an enterprise bean implements the javax.ejb.SessionSynchronization
            // interface, the Application Assembler can specify only the following
            // values for the transaction attributes of the bean's methods:
            //   Required, RequiresNew, Mandatory
            if (oneFound) {
                String transactionAttribute = "";
                ContainerTransaction containerTransaction = null;
                boolean oneFailed = false;
                if (!descriptor.getMethodContainerTransactions().isEmpty()) {
                    for (Enumeration ee = descriptor.getMethodContainerTransactions().keys(); ee.hasMoreElements();) {
                        MethodDescriptor methodDescriptor = (MethodDescriptor) ee.nextElement();
                        containerTransaction =
                                (ContainerTransaction) descriptor.getMethodContainerTransactions().get(methodDescriptor);

                        if (!(containerTransaction != null && properAttribDefined(containerTransaction))) {
                            transactionAttribute  =
                                    containerTransaction.getTransactionAttribute();
                            addErrorDetails(result, compName);
                            result.failed(smh.getLocalString
                                    (getClass().getName() + ".failed",
                                            "Error: TransactionAttribute [ {0} ] for method [ {1} ] is not valid.",
                                            new Object[] {transactionAttribute, methodDescriptor.getName()}));

                        }
                    }
                }
            }
        }

        if(result.getStatus()!=Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                    (getClass().getName() + ".passed",
                            "TransactionAttributes are defined properly for the bean"));
        }
        return result;
    }

    private boolean properAttribDefined(ContainerTransaction containerTransaction) {
        String transactionAttribute  = containerTransaction.getTransactionAttribute();
        return (ContainerTransaction.REQUIRED.equals(transactionAttribute)
                || ContainerTransaction.REQUIRES_NEW.equals(transactionAttribute)
                || ContainerTransaction.MANDATORY.equals(transactionAttribute));

    }
}
