/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests.persistence;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import java.util.ArrayList;
import java.util.List;

/**
 * Mapping files specified using <mapping-file> element in persistence.xml
 * should be resource-loadable from the application classpath.
 *
 * @author bshankar@sun.com
 */
public class MappingFileNotFound extends VerifierTest implements VerifierCheck {
    
    public Result check(Descriptor descriptor) {
        Result result = getInitializedResult();
        result.setStatus(Result.PASSED);
        addErrorDetails(result, getVerifierContext().getComponentNameConstructor());
        
        PersistenceUnitDescriptor pu = PersistenceUnitDescriptor.class.cast(descriptor);
        List<String> mappingFileNames = new ArrayList<String>(pu.getMappingFiles());
        for (String mappingFileName : mappingFileNames) {
            if(getVerifierContext().getClassLoader().getResource(mappingFileName) == null) {
                result.failed(smh.getLocalString(
                        getClass().getName() + "failed",
                        "Mapping file [ {0} ] specified in persistence.xml does not exist in the application.",
                        new Object[]{mappingFileName}));
            }
        }
        return result;
    }
    
}
