/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;


import java.util.*;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.tools.verifier.tests.*;

/**
 *  
 *  @author      Arun Jain
 */
public class FilterInitParamName extends WebTest implements WebCheck {
    
     /** 
     *  Filter Param Name exists test.
     * 
     * 
     * @param descriptor the Web deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(WebBundleDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;

        Enumeration filterEnum = descriptor.getServletFilterDescriptors().elements();
        
    	if (filterEnum.hasMoreElements()) {        
            
	    // get the filters in this .war
	    while (filterEnum.hasMoreElements()) {
		ServletFilterDescriptor filter = (ServletFilterDescriptor)filterEnum.nextElement();
                HashSet<String> envSet = new HashSet<String>(); 
                Vector epVector = filter.getInitializationParameters();              
                for ( int i = 0; i < epVector.size(); i++) {
                    
                    EnvironmentProperty ep = (EnvironmentProperty)epVector.elementAt(i);
                    String epName = ep.getName();
                    
                    if (epName.length() == 0) {
                        oneFailed = true;
			result.addErrorDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));

                        result.addErrorDetails(smh.getLocalString
                                               (getClass().getName() + ".failed1",
                                                "Error: Param name/value entry should of finite length."));
                    }
                    else {
                        // Do duplicate name test.
                        if (!envSet.contains(epName)) {                        
                            envSet.add(epName);
                        }  else {
                            oneFailed = true;
			    result.addErrorDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));

                            result.addErrorDetails(smh.getLocalString
                                               (getClass().getName() + ".failed2",
                                                "Error: Duplicate param names are not allowed."));
                        }
                    }
                }
            }
            if (oneFailed) {
                result.setStatus(Result.FAILED);
            } else {
		result.addGoodDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));
					
		result.passed(smh.getLocalString
                                 (getClass().getName() + ".passed",
                                  "All init parameter names are unique"));                
            }            
        } else {
	    result.addNaDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));
            result.notApplicable(smh.getLocalString
                                 (getClass().getName() + ".notApplicable",
                                  "There are no initialization parameters for the filter within the web archive [ {0} ]",
                                  new Object[] {descriptor.getName()}));
        }        
        return result;
    }
    
}

