/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.*;
import java.io.*;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.*;

/**
 *  @author Arun Jain
 *  
 */
public abstract class Taglib extends WebTest {
    
    
    /** 
     * @param descriptor the Web deployment descriptor
     * @return <code>Result</code> the results for this assertion
     */    
    public boolean check(WebBundleDescriptor descriptor, String taglibEntry, Result result) {
        
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        String uri = getAbstractArchiveUri(descriptor);
        
        if (taglibEntry.startsWith("/"))
            taglibEntry = taglibEntry.substring(1);
        else taglibEntry = "WEB-INF/" + taglibEntry;
        File tlf = new File(uri + File.separator + taglibEntry);
        if (tlf.exists()) {
            result.addGoodDetails(smh.getLocalString
                    ("tests.componentNameConstructor",
                            "For [ {0} ]",
                            new Object[] {compName.toString()}));
            result.addGoodDetails(smh.getLocalString
                    (getClass().getName() + ".passed",
                            "Tag library/.tld file exist in web application."));
            return true;
        }
        result.addErrorDetails(smh.getLocalString
                ("tests.componentNameConstructor",
                        "For [ {0} ]",
                        new Object[] {compName.toString()}));
        result.addErrorDetails(smh.getLocalString
                (getClass().getName() + ".failed",
                        "[ {0} ] is not a valid tld location.", new Object[] {taglibEntry}));
        return false;
    }    
}
