/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.WebBundleDescriptor;

/** message-destination
 *     message-destination-name
 *     jndi-name
 */

public class ASMessageDestination extends WebTest implements WebCheck {

    public Result check(WebBundleDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        
        String messageDestinationName=null;
        String jndiName=null;
	int count = 0;
        try{
            count = getCountNodeSet("sun-web-app/message-destination");
            if (count>0){
                for(int i=0;i<count;i++){
                    messageDestinationName = getXPathValue("sun-web-app/message-destination/message-destination-name");
                    jndiName = getXPathValue("sun-web-app/message-destination/jndi-name");
                    
                    if(messageDestinationName==null || messageDestinationName.length()==0){
                        result.addErrorDetails(smh.getLocalString
                            ("tests.componentNameConstructor",
                            "For [ {0} ]",
                            new Object[] {compName.toString()}));
                        result.failed(smh.getLocalString
                            (getClass().getName() + ".failed1",
                            "FAILED [AS-WEB message-destination] : message-destination-name cannot be an empty string",
                            new Object[] {descriptor.getName()}));
                    }else{
                        result.addGoodDetails(smh.getLocalString
                            ("tests.componentNameConstructor",
                            "For [ {0} ]",
                            new Object[] {compName.toString()}));
                        result.passed(smh.getLocalString(
                                            getClass().getName() + ".passed1",
                              "PASSED [AS-WEB message-destination] : message-destination-name is {1}",
                              new Object[] {descriptor.getName(),messageDestinationName}));
                    }
                    
                    if(jndiName==null || jndiName.length()==0){
                        result.addErrorDetails(smh.getLocalString
                            ("tests.componentNameConstructor",
                            "For [ {0} ]",
                            new Object[] {compName.toString()}));
                        result.failed(smh.getLocalString
                            (getClass().getName() + ".failed2",
                            "FAILED [AS-WEB message-destination] : jndi-name cannot be an empty string",
                            new Object[] {descriptor.getName()}));
                    }else{
                        result.addGoodDetails(smh.getLocalString
                            ("tests.componentNameConstructor",
                            "For [ {0} ]",
                            new Object[] {compName.toString()}));
                        result.passed(smh.getLocalString(
                                            getClass().getName() + ".passed2",
                              "PASSED [AS-WEB message-destination] : jndi-name is {1}",
                              new Object[] {descriptor.getName(),jndiName}));
                    }
                }
            }else{
                result.addNaDetails(smh.getLocalString
		    ("tests.componentNameConstructor",
		    "For [ {0} ]",
		    new Object[] {compName.toString()}));
                result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable",
                    "NOT APPLICABLE [AS-WEB sun-web-app] : message-destination Element not defined"));
            }

            
        }catch(Exception ex){
            result.failed(smh.getLocalString
                (getClass().getName() + ".failed",
                    "FAILED [AS-WEB sun-web-app] could not create the servlet object"));
        }
	return result;
    }

}