/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.*;

/**
 * Represents the source file attribute in a class file
 */

public class SourceFileAttribute extends ClassAttribute {
  /* The expected attribute name */
    public static final String expectedAttrName = "SourceFile";//NOI18N

  /* The source file name */
  private ConstUtf8 sourceFileName;

  /* public accessors */

  /**
   * Returns the source file name
   * The file name should not include directories
   */
  public ConstUtf8 fileName() {
    return sourceFileName;
  }

  /**
   * Sets the source file name
   */
  public void setFileName(ConstUtf8 name) {
    sourceFileName = name;
  }

  /**
   * Constructor for a source file attribute
   */
  public SourceFileAttribute(ConstUtf8 attrName, ConstUtf8 sourceName) {
    super(attrName);
    sourceFileName = sourceName;
  }

  /* package local methods */
  static SourceFileAttribute read(ConstUtf8 attrName,
				  DataInputStream data, ConstantPool pool)
    throws IOException {
    int index = 0;
    index = data.readUnsignedShort();

    return new SourceFileAttribute(attrName,
				   (ConstUtf8) pool.constantAt(index));
  }

  void write(DataOutputStream out) throws IOException {
    out.writeShort(attrName().getIndex());
    out.writeInt(2);
    out.writeShort(sourceFileName.getIndex());
  }

  void print(PrintStream out, int indent) {
    ClassPrint.spaces(out, indent);
    out.println("SourceFile: " + sourceFileName.asString());//NOI18N
  }
}

