/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */



/*
 * EJBQLASTFactory.java
 *
 * Created on November 12, 2001
 */

package com.sun.jdo.spi.persistence.support.ejb.ejbqlc;

import persistence.antlr.collections.AST;
import persistence.antlr.ASTFactory;

import java.util.ResourceBundle;
import com.sun.jdo.spi.persistence.utility.I18NHelper;

/** 
 * Factory to create and connect EJBQLAST nodes.
 *
 * @author  Michael Bouschen
 */
public class EJBQLASTFactory
    extends ASTFactory
{
    /** The singleton EJBQLASTFactory instance. */    
    private static EJBQLASTFactory factory = new EJBQLASTFactory();

    /** I18N support. */
    private final static ResourceBundle msgs = 
        I18NHelper.loadBundle(EJBQLASTFactory.class);
    
    /** 
     * Get an instance of EJBQLASTFactory.
     * @return an instance of EJBQLASTFactory
     */    
    public static EJBQLASTFactory getInstance()
    {
        return factory;
    }
    
    /**
     * Constructor. EJBQLASTFactory is a singleton, please use 
     * {@link #getInstance} to get the factory instance.
     */
    protected EJBQLASTFactory()
    {
        this.theASTNodeTypeClass = EJBQLAST.class;
        this.theASTNodeType = this.theASTNodeTypeClass.getName();
    }
    
    /** Overwrites superclass method to create the correct AST instance. */
    public AST create() 
    {
        return new EJBQLAST();
    }

    /** Overwrites superclass method to create the correct AST instance. */
    public AST create(AST tr) 
    { 
        return create((EJBQLAST)tr);
    }

    /** Creates a clone of the specified EJBQLAST instance. */
    public EJBQLAST create(EJBQLAST tr) 
    { 
        try {
            return (tr==null) ? null : (EJBQLAST)tr.clone();
        }
        catch(CloneNotSupportedException ex) {
            throw new EJBQLException(
                I18NHelper.getMessage(msgs, "ERR_UnexpectedExceptionClone"), ex); //NOI18N
        }
    }
}

