/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * QueryValueFetcher.java
 *
 * Created on March 15, 2002
 * @author  Daniel Tonn
 */

package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import java.util.ResourceBundle;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.ValueFetcher;
import com.sun.jdo.spi.persistence.utility.I18NHelper;

/**
 * Class wrapping the actual query parameters to make them
 * accessible through the ValueFetcher interface.
 */
public class QueryValueFetcher implements ValueFetcher 
{
    /** I18N support */
    protected final static ResourceBundle messages =
        I18NHelper.loadBundle(QueryValueFetcher.class);

    /** The actual parameter values. */
    private Object[] parameters;
    
    /**
     * Constructor.
     * @param parameters the actual parameter values.
     */
    public QueryValueFetcher(Object[] parameters) 
    {
        this.parameters = parameters;
    }
    
    /**
     * Returns the parameter value for the specified parameter index
     * @param whichOne the parameter index
     * @return the parameter value
     */
    public Object getValue(int whichOne) 
    {
        if (parameters == null || whichOne >= parameters.length) 
        {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages,
                "jqlc.queryvaluefetcher.getvalue.invalidparam", //NOI18N
                String.valueOf(whichOne),
                String.valueOf((parameters == null) ? 0 : parameters.length)));
        }
        return parameters[whichOne];
    }
}
