/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldDesc;

import java.util.ArrayList;

/**
 * Implements the select plan for Exist-Subqueries.
 *
 * @author Mitesh Meswani
 * @author Markus Fuchs
 */
public class CorrelatedExistSelectPlan extends CorrelatedSelectPlan {

    public CorrelatedExistSelectPlan(RetrieveDesc desc,
                                     SQLStoreManager store,
                                     ForeignFieldDesc parentField,
                                     SelectQueryPlan parentPlan) {

        super(desc, store, parentField, parentPlan);
    }

    /**
     * There are no real fields to be selected for an (NOT)EXIST query.
     * This method just adds the table for the nested select.
     * The statement for nested select is created as a side effect.
     */
    protected void processFields() {
        for (int i = 0; i < parentField.foreignFields.size(); i++) {
            LocalFieldDesc field = (LocalFieldDesc) parentField.foreignFields.get(i);
            addTable(field);
        }
    }

    /**
     * The correlated constraint joining this subquery with the parent field.
     * The joined table is added as a side-effect.
     */
    protected void doCorrelatedJoin() {
        ArrayList foreignFields = null;

        if (parentField.useJoinTable()) {
            foreignFields = parentField.assocLocalFields;
            // The join table is included in #processJoinTable
        } else {
            foreignFields = parentField.foreignFields;
        }

        ArrayList localFields = parentField.localFields;
        // Add the constraint linking the parent query with the subquery.
        for (int i = 0; i < localFields.size(); i++) {
            LocalFieldDesc la = (LocalFieldDesc) localFields.get(i);
            LocalFieldDesc fa = (LocalFieldDesc) foreignFields.get(i);

            ConstraintFieldDesc lcfd = new ConstraintFieldDesc(la, parentPlan);
            ConstraintFieldDesc fcfd = new ConstraintFieldDesc(fa, this);

            constraint.addField(lcfd);
            constraint.addField(fcfd);
            // Subqueries always join via equijoin.
            constraint.addOperation(ActionDesc.OP_EQ);
        }
    }

    protected Statement newStatement() {
        return new SelectOneStatement(store.getVendorType(), this);
    }

}
