/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * TickEvent.java
 *
 * Create on March 3, 2000
 */

package com.sun.jdo.spi.persistence.support.sqlstore.utility;

import java.util.EventObject;

/**
 * This class defines an event that is posted by a <code>Timer</code>
 * object when its timer interval expires. 
 * It contains a description of the <code>Timer</code> that expired.
 * @see com.forte.util.Timer
 * @see com.forte.util.TickEventListener
 */
public class TickEvent extends EventObject
{
	/**
	* The <code>Timer</code> object that posted the event.
	* @serial
	*/
	public Timer					timer;

	/**
	 * Constructs an event object for the 
	 * specified <code>Timer</code> object. 
	 */
	public TickEvent(Object source)
	{
		super(source);
		this.timer = (Timer) source;
	}
}
