/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * UuidUtilPadded.java
 *
 * Created on May 26, 2005, 11:15 AM
 */

package com.sun.enterprise.util.uuid;

/**
 *
 * @author  lwhite
 */
public class UuidUtilPadded extends UuidUtil {
    
    static final int DESIRED_UUID_LENGTH = 40;
    
    //this method can take in the session object
    //and insure better uniqueness guarantees
    //needed length must be greater than not less than
    //expected returned lengths - i.e. at least 40
    public static String generateUuid(Object obj, int inputLength) {
        int desiredLength = 
            DESIRED_UUID_LENGTH >= inputLength ? DESIRED_UUID_LENGTH:inputLength;
        String unpaddedUuid = UuidUtil.generateUuid(obj);
        StringBuffer sb = new StringBuffer(unpaddedUuid);
        int neededPadding = desiredLength - unpaddedUuid.length();
        //int neededPadding = DESIRED_UUID_LENGTH - unpaddedUuid.length();
        if(neededPadding > 0) {
            for(int i=0; i<neededPadding; i++) {
                sb.append("F");
            }
        }
        return sb.toString();
    }    
    
    /**
     * Method main
     *
     *
     * @param args
     *
     * @audience
     */
    public static void main(String[] args) {
        System.out.println(UuidUtilPadded.generateUuidMM());
        System.out.println(UuidUtilPadded.generateUuid());
        System.out.println(UuidUtilPadded.generateUuid(new Object()));
        System.out.println(UuidUtilPadded.generateUuid(new Object(), 40));
    }
    
}
