/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.jauth;

/**
 * A marker interface that may be implemented by a CallBackHandler.
 * <p>
 * When a CallbackHandler that implements this interface, is passed
 * as an argument to the getServerAuthContext or getClientAuthContext
 * methods of the AuthConfig class, the AuthConfig system will wrap 
 * the handler in a special internal CallbackHandler that will 
 * delegate any unsupported Callbacks to the default CallbackHandler
 * of the AuthConfig system. The modules of the context will receive
 * this wrapping handler at initialization, and the effect will be to
 * allow systems to extend or override the callbacks handled by the 
 * default handler of the config system with those handled by the wrapped
 * handler.
 *
 * @version %I%, %G%
 */
public interface DependentCallbackHandler { }
