/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.AnnotatedElement;

import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataValidator;

/**
 * Validation class for the EJBAnnotationsProcessor and the 
 * AnnotationsSequencingProcessor.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class AnnotationsValidator extends MetadataValidator  {
    public AnnotationsValidator() {}
    
    /**
     * INTERNAL
     */
    public void throwEmbeddedIdAndIdFound(Class entityClass, String attributeName, String idAttributeName) {
        throw ValidationException.embeddedIdAndIdAnnotationFound(entityClass, attributeName, idAttributeName);
    }
    
    /**
     * INTERNAL
     */
    public void throwErrorProcessingNamedQueryAnnotation(Class entityClass, String name, Exception exception) {
        throw ValidationException.errorProcessingNamedQueryAnnotation(entityClass, name, exception);
    }
    
    /**
     * INTERNAL
     */
    public void throwExcessiveJoinColumnsSpecified(Class entityClass, Object element) {
        throw ValidationException.excessiveJoinColumnsSpecified((AnnotatedElement) element, entityClass);
    }
    
    /**
     * INTERNAL
     */
    public void throwExcessivePrimaryKeyJoinColumnsSpecified(Object element) {
        throw ValidationException.excessivePrimaryKeyJoinColumnsSpecified((AnnotatedElement) element);
    }
    
    /**
     * INTERNAL
     */
    public void throwIncompleteJoinColumnsSpecified(Class entityClass, Object element) {
        throw ValidationException.incompleteJoinColumnsSpecified((AnnotatedElement) element, entityClass);
    }
    
    /**
     * INTERNAL
     */
    public void throwIncompletePrimaryKeyJoinColumnsSpecified(Class entityClass) {
        throwIncompletePrimaryKeyJoinColumnsSpecified((AnnotatedElement) entityClass);
    }   
    
    /**
     * INTERNAL
     */
    public void throwIncompletePrimaryKeyJoinColumnsSpecified(AnnotatedElement annotatedElement) {
        throw ValidationException.incompletePrimaryKeyJoinColumnsSpecified(annotatedElement);
    }   
    
    /**
     * INTERNAL
     */
     public void throwMappingAnnotationsAppliedToTransientAttribute(AnnotatedElement annotatedElement) {
        throw ValidationException.mappingAnnotationsAppliedToTransientAttribute(annotatedElement);
     }
    
    /**
     * INTERNAL
     */
    public void throwMultipleEmbeddedIdsFound(Class entityClass, String attributeName, String embeddedIdAttributeName) {
        throw ValidationException.multipleEmbeddedIdAnnotationsFound(entityClass, attributeName, embeddedIdAttributeName);
    }
    
    /**
     * INTERNAL
     */
    public void throwNoCorrespondingSetterMethodDefined(Class entityClass, Method method) {
        throw ValidationException.noCorrespondingSetterMethodDefined(entityClass, method);
    }
    
    /**
     * INTERNAL
     */
    public void throwNoMappedByAttributeFound(Class owningClass, String owningAttributeName, Class entityClass, String attributeName) {
        throw ValidationException.noMappedByAttributeFound(owningClass, owningAttributeName, entityClass, attributeName);
    }
    
    /**
     * INTERNAL
     */
    public void throwNoPrimaryKeyAnnotationsFound(Class entityClass) {
        throw ValidationException.noPrimaryKeyAnnotationsFound(entityClass);   
    }
    
    /**
     * INTERNAL
     */
    public void throwNoTemporalTypeSpecified(Class entityClass, String attributeName) {
        throw ValidationException.noTemporalTypeSpecified(attributeName, entityClass);
    }
    
    /**
     * INTERNAL
     */
    public void throwRelationshipHasColumnSpecified(Class entityClass, String attributeName) {
        throw ValidationException.invalidColumnAnnotationOnRelationship(entityClass, attributeName);   
    }
    
    /**
     * INTERNAL
     */
    public void throwUniDirectionalOneToManyHasJoinColumnSpecified(Class entityClass, String attributeName) {
        throw ValidationException.uniDirectionalOneToManyHasJoinColumnAnnotations(entityClass, attributeName);   
    }
    
    /**
     * INTERNAL
     */
    public void throwUnspecifiedCompositePrimaryKeyNotSupported(Class entityClass) {
        throw ValidationException.unspecifiedCompositePKNotSupported(entityClass);
    }
}
