/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml;

import org.w3c.dom.Node;

public class EntityRelationshipInfo {
    private Class attributeType;        // the type of the attribute, i.e. Collection
    private Class referenceClass;       // the actual reference class, i.e. Employee
    private Class owningClass;			// the owning class; req'd to process attributes from a mapped-superclass
    private String attributeName;
    private boolean needsProcessing;
        
    public EntityRelationshipInfo(String attributeName, Class referenceClass, Class attributeType, Class owningClass) {
        this.attributeName = attributeName;
        this.referenceClass = referenceClass;
        this.attributeType = attributeType;
        this.owningClass = owningClass;
        needsProcessing = true;
    }
    
    public String getAttributeName() {
        return attributeName;
    }

    public Class getOwningClass() {
        return owningClass;
    }
    
    public Class getReferenceClass() {
        return referenceClass;
    }

    public Class getAttributeType() {
        return attributeType;
    }

    public void setNeedsProcessing(boolean needsProcessing) {
        this.needsProcessing = needsProcessing;
    }

    public boolean needsProcessing() {
        return needsProcessing;
    }
}
