/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.localization.i18n;

import java.util.ListResourceBundle;

/**
 * English ResourceBundle for TraceLocalization messages.  Traces are only localized.  They do not get translated.
 *
 * @author Shannon Chen
 * @since OracleAS TopLink 10<i>g</i> (9.0.4)
 */
public class TraceLocalizationResource extends ListResourceBundle {
    static final Object[][] contents = {
                                           { "acquire_unit_of_work_with_argument", "acquire unit of work: {0}" },
                                           { "external_transaction_has_begun_internally", "external transaction has begun internally" },
                                           { "external_transaction_has_committed_internally", "external transaction has committed internally" },
                                           { "initialize_all_identitymaps", "initialize all identitymaps" },
                                           { "initialize_identitymap", "initialize identitymap: {0}" },
                                           { "initialize_identitymaps", "initialize identitymaps" },
                                           { "external_transaction_has_rolled_back_internally", "external transaction has rolled back internally" },
                                           { "validate_cache", "validate cache." },
                                           { "stack_of_visited_objects_that_refer_to_the_corrupt_object", "stack of visited objects that refer to the corrupt object: {0}" },
                                           { "corrupt_object_referenced_through_mapping", "corrupt object referenced through mapping: {0}" },
                                           { "corrupt_object", "corrupt object: {0}" },
                                           { "begin_unit_of_work_commit", "begin unit of work commit" },
                                           { "end_unit_of_work_commit", "end unit of work commit" },
                                           { "resume_unit_of_work", "resume unit of work" },
                                           { "resuming_unit_of_work_from_failure", "resuming unit of work from failure" },
                                           { "release_unit_of_work", "release unit of work" },
                                           { "revert_unit_of_work", "revert unit of work" },
                                           { "validate_object_space", "validate object space." },
                                           { "execute_query", "Execute query {0}" },
                                           { "merge_clone", "Merge clone {0} " },
                                           { "merge_clone_with_references", "Merge clone with references {0}" },
                                           { "new_instance", "New instance {0}" },
                                           { "register_existing", "Register the existing object {0}" },
                                           { "register_new", "Register the new container bean {0}" },
                                           { "register_new_bean", "Register the new bean {0}" },
                                           { "register", "Register the object {0}" },
                                           { "revert", "Revert the object''s attributes {0}" },
                                           { "unregister", "Unregister the object {0}" },
                                           { "begin_batch_statements", "Begin batch statements" },
                                           { "end_batch_statements", "End Batch Statements" },
                                           { "query_column_meta_data_with_column", "query column meta data ({0}.{1}.{2}.{3})" },
                                           { "query_column_meta_data", "query table meta data ({0}.{1}.{2})" },
                                           { "reconnecting_to_external_connection_pool", "reconnecting to external connection pool" },
                                           { "begin_transaction", "begin transaction" },
                                           { "commit_transaction", "commit transaction" },
                                           { "rollback_transaction", "rollback transaction" },
                                           { "adapter_result", "Adapter result: {0}" },
                                           { "data_access_result", "Data access result: {0}" },
                                           { "acquire_unit_of_work", "acquire unit of work" },
                                           { "JTS_register", "JTS register" },
                                           { "JTS_after_completion", "After JTS Completion" },
                                           { "JTS_before_completion", "Before JTS Completion" },
                                           { "JTS_begin", "Begin JTS transaction" },
                                           { "JTS_commit_with_argument", "JTS#commit({0})" },
                                           { "JTS_rollback", "Rollback JTS transaction." },
                                           { "JTS_commit", "Commit JTS transaction." },
                                           { "JTS_after_completion_with_argument", "After JTS Completion ({0})" },
                                           { "TX_beforeCompletion", "TX beforeCompletion callback, status={0}" },
                                           { "TX_afterCompletion", "TX afterCompletion callback, status={0}" },
                                           { "TX_bind", "TX binding to tx mgr, status={0}" },
                                           { "TX_begin", "TX beginTransaction, status={0}" },
                                           { "TX_beginningTxn", "TX Internally starting" },
                                           { "TX_commit", "TX commitTransaction, status={0}" },
                                           { "TX_committingTxn", "TX Internally committing" },
                                           { "TX_rollback", "TX rollbackTransaction, status={0}" },
                                           { "TX_rollingBackTxn", "TX Internally rolling back" },
                                           { "lock_writer_header", "Current object locks:" },
                                           { "lock_writer_footer", "End of locked objects." },
                                           { "active_thread", "Thread : {0}" },
                                           { "locked_object", "Locked Object : {0}" },
                                           { "depth", "Depth : {0}" },
                                           { "deferred_locks", "Deferred lock on : {0}" },
                                           { "deferred_locks_released", "All deferred locks for thread \"{0}\" have been released." },
                                           { "acquiring_deferred_lock", "Thread \"{1}\" has acquired a deferred lock on object : {0} in order to avoid deadlock." },
                                           { "dead_lock_encountered_on_write", "Thread \"{1}\" encountered deadlock when attempting to lock : {0}.  Entering deadlock avoidance algorithm." },
                                           { "XML_call", "XML call" },
                                           { "XML_data_call", "XML data call" },
                                           { "XML_data_delete", "XML data delete" },
                                           { "XML_data_insert", "XML data insert" },
                                           { "XML_data_read", "XML data read" },
                                           { "XML_data_update", "XML data update" },
                                           { "XML_delete", "XML delete" },
                                           { "XML_existence_check", "XML existence check" },
                                           { "XML_insert", "XML insert" },
                                           { "XML_read_all", "XML read all" },
                                           { "XML_read", "XML read" },
                                           { "XML_update", "XML update" },
                                           { "write_BLOB", "Writing BLOB value(size = {0} bytes) through the locator to the table field: {1}" },
                                           { "write_CLOB", "Writing CLOB value(size = {0} bytes) through the locator to the table field: {1}" },
                                           { "assign_sequence", "assign sequence to the object ({0} -> {1})" },
                                           { "assign_return_row", "Assign return row {0}" },
                                           { "compare_failed", "Compare failed: {0}:{1}:{2}" },
                                           { "added_unmapped_field_to_returning_policy", "Added unmapped field {0} to ReturningPolicy of {1}" },
                                           { "field_for_unsupported_mapping_returned", "Returned field {0} specified in ReturningPolicy of {1} mapped with unsupported mapping" },
                                           { "received_updates_from_remote_server", "Received updates from Remote Server" },
                                           { "received_remote_connection_from", "Received remote connection from {0}" },
                                           { "applying_changeset_from_remote_server", "Applying changeset from remote server {0}" },
                                           { "change_from_remote_server_older_than_current_version", "Change from Remote Server is older than current Version for {0}: {1}" },
                                           { "current_version_much_older_than_change_from_remote_server", "Current Version is much older than change from remote server for {0}: {1}" },
                                           { "Merging_from_remote_server", "Merging {0}: {1} from remote server" },
                                           { "initializing_local_discovery_communication_socket", "Initializing local discovery communication socket" },
                                           { "place_local_remote_session_dispatcher_into_naming_service", "Place local remote session dispatcher into naming service" },
                                           { "connecting_to_other_sessions", "connecting to other sessions" },
                                           { "done", "Done" },
                                           { "getting_local_initial_context", "Getting local initial context" },
                                           { "received_connection_from", "Received connection from {0}" },
                                           { "sending_changeset_to_network", "Sending changeSet to network" },
                                           { "failed_to_reconnect_remote_connection", "Failed to reconnect the remote connection on error" },
                                           { "dropping_connection", "Dropping connection: {0}" },
                                           { "attempting_to_reconnect_to_JMS_service", "Attempting to reconnect to JMS service" },
                                           { "retreived_remote_message_from_JMS_topic", "Retreived remote message from JMS topic: {0}" },
                                           { "processing_topLink_remote_command", "Processing TopLink remote command" },
                                           { "JMS_exception_thrown", "JMSException thrown" },
                                           { "announcement_sent_from", "Announcement sent from {0}" },
                                           { "announcement_received_from", "Announcement received from {0}" },
                                           { "reconnect_to_jms", "Reconnect to the JMS topic name {0}" },
                                           { "sequencing_connected", "sequencing connected, state is {0}" },
                                           { "sequencing_connected_several_states", "sequencing connected, several states are used" },
                                           { "sequence_without_state", "sequence {0}: preallocation size {1}" },
                                           { "sequence_with_state", "sequence {0}: preallocation size {1}, state {2}" },
                                           { "sequencing_connected_several_states", "sequencing connected, several states are used" },
                                           { "sequencing_disconnected", "sequencing disconnected" },
                                           { "sequencing_localPreallocation", "local sequencing preallocation for {0}: objects: {1} , first: {2}, last: {3}" },
                                           { "sequencing_afterTransactionCommitted", "local sequencing preallocation is copied to preallocation after transaction commit" },
                                           { "sequencing_afterTransactionRolledBack", "local sequencing preallocation is discarded after transaction roll back" },
                                           { "sequencing_preallocation", "sequencing preallocation for {0}: objects: {1} , first: {2}, last: {3}" },
                                           { "starting_rcm", "Starting Remote Command Manager {0}" },
                                           { "stopping_rcm", "Stopping Remote Command Manager {0}" },
                                           { "initializing_discovery_resources", "Initializing discovery resources - group={0} port={1}" },
                                           { "sending_announcement", "Sending service announcement..." },
                                           { "register_local_connection_in_jndi", "Registering local connection in JNDI under name {0}" },
                                           { "register_local_connection_in_registry", "Registering local connection in RMIRegistry under name {0}" },
                                           { "context_props_for_remote_lookup", "Remote context properties: {0}" },
                                           { "looking_up_remote_conn_in_jndi", "Looking up remote connection in JNDI under name {0} at URL {1}" },
                                           { "looking_up_remote_conn_in_registry", "Looking up remote connection in RMIRegistry at {0}" },
                                           { "received_connection_from", "Received remote connection from {0}" },
                                           { "converting_to_toplink_command", "Converting {0} to TopLink Command format" },
                                           { "converting_to_user_command", "Converting {0} from TopLink Command format to user format" },
                                           { "executing_merge_changeset", "Executing MergeChangeSet command from {0}" },
                                           { "received_remote_command", "Received remote command {0} from {1}" },
                                           { "processing_internal_command", "Executing internal RCM command {0} from {1}" },
                                           { "processing_remote_command", "Executing command {0} from {1}" },
                                           { "sync_propagation", "Propagating command synchronously" },
                                           { "async_propagation", "Propagating command asynchronously" },
                                           { "propagate_command_to", "Propagating command {0} to {1}" },
                                           { "start_listening_to_jms_topic", "Start listening to JMS Topic {0} hosted at {1}" },
                                           { "stop_listening_to_jms_topic", "Stop listening to JMS Topic {0} hosted at {1}" },
                                           { "discovery_manager_active", "RCM Discovery Manager active" },
                                           { "discovery_manager_stopped", "RCM Discovery Manager stopped" },
                                           { "announcement_sent", "RCM service announcement sent out to cluster" },
                                           { "announcement_received", "RCM service announcement received from {0}" },
                                           { "creating_session_broker", "Creating session broker: {0}" },
                                           { "creating_database_session", "Creating database session: {0}" },
                                           { "creating_server_session", "Creating server session: {0}" },
                                           { "EJB_create", "Create EJB ({0}) " },
                                           { "EJB_find_all", "Find all EJB objects ({0})" },
                                           { "EJB_find_all_by_name", "Find all EJB objects by named query ({0})" },
                                           { "EJB_find_one", "Find one EJB object ({0})" },
                                           { "EJB_find_one_by_name", "Find one EJB object by named query ({0})" },
                                           { "EJB_load", "Load EJB" },
                                           { "EJB_remove", "Remove EJB ({0})" },
                                           { "EJB_store", "Store EJB ({0})" },
                                           { "error_in_preInvoke", "Error in preInvoke." },
                                           { "unable_to_load_generated_subclass", "Unable to load generated subclass: {0}" },
                                           { "ProjectDeployment_registeringMBeans_enter", "ProjectDeployment.registeringMBeans enter" },
                                           { "ProjectDeployment_registeringMBeans_return", "ProjectDeployment.registeringMBeans return" },
                                           { "executeFinder_query", "executeFinder query: {0}, {1}" },
                                           { "executeFinder_finder_execution_results", "executeFinder - finder execution results: {0}" },
                                           { "PM_initialize_enter", "PersistenceManager.initialize enter for {0}" },
                                           { "PM_initialize_return", "PersistenceManager.initialize return for {0}" },
                                           { "PM_preDeploy_enter", "PersistenceManager.preDeploy enter for {0}" },
                                           { "PM_preDeploy_return", "PersistenceManager.preDeploy return for {0}" },
                                           { "PM_postDeploy_enter", "PersistenceManager.postDeploy enter for {0}" },
                                           { "PM_postDeploy_return", "PersistenceManager.postDeploy return for {0}" },
                                           { "createEJB_call", "createEJB call: {0}" },
                                           { "createEJB_return", "createEJB return: {0}" },
                                           { "removeEJB_call", "removeEJB call: {0}" },
                                           { "removeEJB_return", "removeEJB return: {0}" },
                                           { "invokeHomeMethod_call", "invokeHomeMethod call: {0}({1})" },
                                           { "invokeHomeMethod_return", "invokeHomeMethod return" },
                                           { "ProjectDeployment_undeploy_enter", "ProjectDeployment.undeploy enter" },
                                           { "ProjectDeployment_undeploy_return", "ProjectDeployment.undeploy return" },
                                           { "ProjectDeployment_configureDescriptor_enter", "ProjectDeployment.configureDescriptor enter: {0}" },
                                           { "ProjectDeployment_configureDescriptor_return", "ProjectDeployment.configureDescriptor return" },
                                           { "ProjectDeployment_configureDescriptors_enter", "ProjectDeployment.configureDescriptors enter" },
                                           { "ProjectDeployment_configureDescriptors_return", "ProjectDeployment.configureDescriptors return" },
                                           { "configuring_descriptor", "configuring descriptor: {0}, {1}" },
                                           { "concrete_class", "concrete class: {0}" },
                                           { "setting_ref_class_of_foreign_ref_mapping", "setting ref class of foreign ref mapping: {0}, {1}" },
                                           { "setting_ref_class_of_aggregate_mapping", "setting ref class of aggregate mapping: {0}, {1}" },
                                           { "desc_has_inheritance_policy", "Descriptor has inheritance policy: {0}" },
                                           { "one_time_initialization_of_ProjectDeployment", "one-time initialization of ProjectDeployment" },
                                           { "generateBeanSubclass_call", "generateBeanSubclass call: {0}" },
                                           { "remote_and_local_homes", "remote and local homes: {0}, {1}" },
                                           { "generateBeanSubclass_return", "generateBeanSubclass return: {0}" },
                                           { "error_in_startBusinessCall", "Error in startBusinessCall." },
                                           { "error_in_endLocalTx", "Error in endLocalTx." },
                                           { "EJB20_Project_Deployment_adjustDescriptorsForUOW_enter", "UOWChangeSetFlagCodeGenerator.adjustDescriptorForUOWFlag enter" },
                                           { "EJB20_Codegeneration_For_UOW_Change_Policy_enter", "UOWChangePolicyCodeGenerator.generateCodeForUOWChangePolicy enter" },
                                           { "OBJECTCHANGEPOLICY_TURNED_ON", "Change tracking turned on for: {0}" },
                                           { "PM_DescriptorContents", "********** PersistenceManager.getPMDescriptorContents()" },
                                           { "project_class_used", "The project class [{0}] is being used." },
                                           { "pessimistic_lock_bean", "prepare pessimistic locking for bean {0}" },
                                           { "changetracker_interface_not_implemented", "Class [{0}] for attribute [{1}] does not implement ChangeTracker interface. This class is being reverted to DeferredChangeDetectionPolicy." },
                                           { "changetracker_interface_not_implemented_non_cmp", "Class [{0}] is being reverted to DeferredChangeDetectionPolicy since the attribute [{1}] " + "is a non-cmp field but the owinging class does not implement ChangeTracker interface." },
                                           { "acquire_client_session_broker", "acquire client session broker" },
                                           { "releasing_client_session_broker", "releasing client session broker" },
                                           { "client_released", "client released" },
                                           { "client_acquired", "client acquired" },
                                           { "tracking_pl_object", "track pessimistic locked object {0} with UnitOfWork {1}" },
                                           { "instantiate_pl_relationship", "instantiate pessimistic locking relationship when relationship is accessed in a new transaction." },
                                           { "descriptor_xml_not_in_jar", "The descriptor file ({0}) is not found in jar({1}) file, no migration therefore will be performed for this jar." },
                                           { "pessimistic_locking_migrated", "The native CMP setting 'pessimistic-locking' on entity({0}) has been migrated and supported." },
                                           { "read_only_migrated", "The native CMP setting 'read-only' on entity({0}) has been migrated and supported." },
                                           { "call_timeout_migrated", "Oc4j native CMP setting 'time-out' on entity({0}) has been migrated and supported." },
                                           { "verifiy_columns_version_locking_migrated", "Optimistic setting 'Version' on 'verifiy-columns' in entity ({0}) has been migrated." },
                                           { "verifiy_columns_timestamp_locking_migrated", "Optimistic setting 'Timestamp' on 'verifiy-columns' in entity ({0}) has been migrated." },
                                           { "verifiy_columns_changedField_locking_migrated", "Optimistic setting 'Modify' on 'verifiy-columns' in entity ({0}) has been migrated." },
                                           { "order_database_operations_supported", "WLS native CMP setting 'order-database-operations' has been supported and migrated" },
                                           { "pattern_syntax_error", "Regular expression syntax error, exception is: {0}" },
                                           { "weaver_adding_embeddable_class", "Adding Embeddable class [{0}] to list of weaving candidate Entities."},
                                           { "weaver_user_impl_change_tracking", "Weaving for change tracking not required for class [{0}] because it already implements the ChangeTracker interface."},
                                           { "weaver_found_field_lock", "Weaving for change tracking not enabled for class [{0}] because it uses field-based optimisitic locking."},
                                           { "weaver_class_not_in_project", "Weaver found class [{0}] in configuration but not in TopLink project."},
                                           { "weaver_processing_class", "Weaver processing class [{0}]."},
                                           { "cmp_init_invoke_predeploy", "javaSECMPInitializer - predeploying {0}."},
                                           { "cmp_init_register_transformer", "javaSECMPInitializer - registering transformer for {0}."},
                                           { "cmp_init_tempLoader_created", "javaSECMPInitializer - created temporary ClassLoader: {0}."},
                                           { "cmp_init_shouldOverrideLoadClassForCollectionMembers", "javaSECMPInitializer - override load class for collection members: {0}."},
                                           { "cmp_loading_entities_using_loader", "javaSECMPInitializer - loading entities using ClassLoader: {0}."},
                                           { "cmp_init_transformer_is_null", "javaSECMPInitializer - transformer is null."},
                                           { "cmp_init_globalInstrumentation_is_null", "javaSECMPInitializer - global instrumentation is null."},
                                           { "cmp_init_invoke_deploy", "javaSECMPInitializer - deploying {0}."},
                                           { "cmp_init_completed_deploy", "javaSECMPInitializer - completed deploy of {0}."},
                                           { "cmp_init_initialize", "javaSECMPInitializer - initializaing {0}."},
                                           { "cmp_init_initialize_from_main", "javaSECMPInitializer - initializing from main."},

                                           { "dbPlaformHelper_detectedVendorPlatform", "Detected Vendor platform: {0}"},
                                           { "dbPlaformHelper_regExprDbPlatform", "DBPlatform: {1}, RegularExpression: {0}."},
                                           { "dbPlaformHelper_patternSyntaxException", "Exception while using regExpr : {0}." }
    };

    /**
     * Return the lookup table.
     */
    protected Object[][] getContents() {
        return contents;
    }
}
