/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.parsing;

/**
 * INTERNAL
 * <p><b>Purpose</b>: Superclass for Aggregate Nodes
 * <p><b>Responsibilities</b>:<ul>
 * <li> Apply itself to a query correctly
 * </ul>
 *    @author Jon Driscoll
 *    @since TopLink 5.0
 */

import oracle.toplink.essentials.expressions.Expression;

public abstract class AggregateNode extends Node {

    private boolean distinct = false;

    /**
     * INTERNAL
     */
    public String resolveAttribute() {
        Node arg = getLeft();
        return arg.isDotNode() ? ((DotNode)arg).resolveAttribute() : null;
    }

    /**
     * resolveClass: Answer the class associated with my left node.
     */
    public Class resolveClass(GenerationContext context) {
        return getLeft().resolveClass(context);
    }

    /**
     * INTERNAL
     * Is this node an Aggregate node
     */
    public boolean isAggregateNode() {
        return true;
    }

    /** */
    public boolean usesDistinct() {
        return distinct;
    }

    /** */
    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    /** */
    protected Expression getArgumentExpression(GenerationContext context) {
        Expression arg = getLeft().generateExpression(context);
        if (usesDistinct()) {
            arg = arg.distinct();
        }
        return arg;
    }
}
