/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: EjbModule.java,v 1.5 2005/12/25 04:27:36 tcfujii Exp $
 */

package com.sun.enterprise.ddgenerator.sun;

import java.util.*;
import java.io.File;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.deployment.io.DescriptorConstants;
import com.sun.enterprise.util.io.FileUtils;

import com.sun.enterprise.deployment.archivist.*;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.interfaces.*;

/**
 * Class description
 *
 * @author Sreenivas Munnangi
 */

public class EjbModule implements DDGenerator {

    private EjbBundleDescriptor ejbBundleDescriptor = null;
    private String applicationDirectory = null;

    public EjbModule () {
    }

    public EjbModule (EjbBundleDescriptor ejbBundleDescriptor, String applicationDirectory) {
	this.ejbBundleDescriptor = ejbBundleDescriptor;
	this.applicationDirectory = applicationDirectory;
    }

    public void setApplicationDirectory(String applicationDirectory) {
	this.applicationDirectory = applicationDirectory;
    }

    public void setDescriptor(com.sun.enterprise.deployment.Descriptor descriptor) {
	this.ejbBundleDescriptor = (com.sun.enterprise.deployment.EjbBundleDescriptor) descriptor;
    }

    public void generate() {
	if (ejbBundleDescriptor == null) return;

	java.util.Set ejbDescriptors = ejbBundleDescriptor.getEjbs();

	for (Iterator it = ejbDescriptors.iterator(); it.hasNext();) {
		EjbDescriptor ejbDescriptor = (EjbDescriptor) it.next();
		String jndiName = ejbDescriptor.getJndiName();
		if ((jndiName == null) || (jndiName.length() <1)) {
			String homeName = ejbDescriptor.getHomeClassName();
			ejbDescriptor.setJndiName(homeName);
		}
	}

    }

    public boolean hasSunDescriptor() {
	
	File file = getSunDescriptorFile();

	if (file == null) return false;

	if (file.exists()) {
		return true;
	} 

	return false;
    }

    public void backupSunDescriptor() {

	File file = getSunDescriptorFile();

	if (file == null) return;

	if (file.exists()) {
	    try {
		FileUtils.copy(file, new File(file.getAbsolutePath() + ".bak"));
	    } catch (java.io.IOException ioe) {
	    }
	}

    }


    private File getSunDescriptorFile () {
	
	File file = null;

	String archiveUri = ejbBundleDescriptor.getModuleDescriptor().getArchiveUri();

	String friendlyFileName = FileUtils.makeFriendlyFilename(archiveUri);

	String sunXmlFileName = (applicationDirectory + File.separator + 
				 friendlyFileName + File.separator + 
				 com.sun.enterprise.deployment.io.DescriptorConstants.S1AS_EJB_DD_ENTRY);

	file = new File(sunXmlFileName);

	return file;
    }

    public static void main (String args[]) {

        System.out.println("Ejb");

	String appDir = "/home/sreeni/TEMP/stateless-converterEjb_1";

        System.out.println("Press enter to continue ...");
	try {
		System.in.read();
	} catch (java.io.IOException ioe) {
	}

	FileArchive in = new FileArchive();

	try {
		in.open(appDir);
	} catch (java.io.IOException ioe) {
	}


	EjbArchivist ejbArchivist = new EjbArchivist();
	ejbArchivist.setXMLValidation(false);
	ejbArchivist.setClassLoader(null);

	com.sun.enterprise.deployment.Application application = null;
	try {
		application = (com.sun.enterprise.deployment.Application)
			ApplicationArchivist.openArchive(ejbArchivist, in, true);
	} catch (java.io.IOException ioe) {
	} catch (org.xml.sax.SAXParseException saxpe) {
	}

	com.sun.enterprise.ddgenerator.sun.Application app = 
		new com.sun.enterprise.ddgenerator.sun.Application(application, appDir); 

	app.generate();
    }

}
