#
# The contents of this file are subject to the terms 
# of the Common Development and Distribution License 
# (the License).  You may not use this file except in
# compliance with the License.
# 
# You can obtain a copy of the license at 
# https://glassfish.dev.java.net/public/CDDLv1.0.html or
# glassfish/bootstrap/legal/CDDLv1.0.txt.
# See the License for the specific language governing 
# permissions and limitations under the License.
# 
# When distributing Covered Code, include this CDDL 
# Header Notice in each file and include the License file 
# at glassfish/bootstrap/legal/CDDLv1.0.txt.  
# If applicable, add the following below the CDDL Header, 
# with the fields enclosed by brackets [] replaced by
# you own identifying information: 
# "Portions Copyrighted [year] [name of copyright owner]"
# 
# Copyright 2006 Sun Microsystems, Inc. All rights reserved.
#

#!/tools/ns/bin/perl
#Correct Usage: perl listpatch.pl <IAS_INSTALL_ROOT> 
#Old Usage: perl listpatch.pl <IAS_INSTALL_ROOT> [-p COMMA_SEPARATED_LIST_OF_PACKAGES]

#Attributes in the README.patchid file
#$PACKAGES="Packages";

my $ostype = $^O;
if ($ostype =~m/Win/)
{
  $platform = "windows";
  $CP = "copy";
  $MV = "ren";
  $MKDIR = "md";
  $RM = "del";
  $slash = "\\";
} else {
  $platform = "linux";
  $CP = "cp";
  $MV = "mv";
  $MKDIR = "mkdir";
  $RM = "rm";
  $slash = "/";
}

#system("$CP README.* README.txt");
#open(README, "README.txt");
#while ($line = <README>)
#{
#  ($KEY, $VALUE) = split("=", $line);
#  chomp($VALUE);
#  $table{$KEY}= $VALUE;
#}
#close README;
#system("$RM README.txt");

#@packages = split(",", $table{$PACKAGES});
#my $packagesToSearch = "ALL";
#if ($ARGV[1] eq "-p")
#{
#  $packagesToSearch = ARGV[2];
#}
#foreach $item (@packages)
#{
#  if ($packagesToSearch ne "ALL")
#  {
#    if ( ($packagesToSearch ne $item) && ($packagesToSearch !~ m/^($item,)/) && ($packagesToSearch !~ m/(,$item)$/) && ($packagesToSearch !~ m/,$item,/) )
#    {
#      next;
#    }
#  }
#  print "\n\nPackage $item -\n\n";
#  $dir = "$ARGV[0]\\$item";
  $dir = "$ARGV[0]${slash}config";
  $pkginfo = "$dir${slash}pkginfo";
  $heading = "false";
  open(PKGINFO, $pkginfo);
  while ($line = <PKGINFO>)
  {
    if ($line =~ m/^(PATCH_INFO_)/)
    {
      if ($heading eq "false") {
        print "\n\nThe installed patches are -\n";
        print "---------------------------\n";
      }
      print "$line\n";
      $heading = "true";
    }  
  }
  if ($heading eq "false") {
    print "\n\nCurrently there are no patches installed\n\n";
  }
  close PKGINFO;
#}
