/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * IIOPCluster.java
 *
 * Created on June 13, 2004, 12:02 AM
 */

package com.sun.enterprise.tools.upgrade.cluster;

/**
 *
 * @author  prakash
 */
import java.util.*;
public class IIOPCluster {
    
    // This clusterName is not really an attribute of IIOCluster element.  This is the name obtained from current cluster from common info model
    private String clusterName;
    private List iiopServerInstanceList;
    private IIOPServerInstance currentServerInstance;
    
    /** Creates a new instance of IIOPCluster */
    public IIOPCluster(String clName) {
        this.clusterName = clName;
    }
    public void addIIOPServerInstance(String serverName){
        IIOPServerInstance serverInstance = new IIOPServerInstance(serverName);
        this.currentServerInstance = serverInstance;
        if(this.iiopServerInstanceList == null)
            this.iiopServerInstanceList = new ArrayList();
        this.iiopServerInstanceList.add(serverInstance);
    }   
    public void addIIOPEndPoint(String id, String host, String port){
        this.currentServerInstance.addIIOPEndPoint(id,host,port);
    }    
    public List getIIOPServerInstanceList(){
        return this.iiopServerInstanceList;
    }
    public String getClusterName(){
        return this.clusterName;
    }
    public void setClusterName(String clName){
        this.clusterName = clName;
    }
}
