/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ProgressPanel.java
 *
 * Created on September 3, 2003, 3:14 PM
 */

package com.sun.enterprise.tools.upgrade.gui;

/**
 *
 * @author  prakash
 */
import javax.swing.*;
import java.awt.*;
import com.sun.enterprise.tools.upgrade.common.*;
import java.util.logging.*;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.tools.upgrade.logging.*;

public class ProgressPanel extends javax.swing.JPanel {
    
    private FlowLabel flowProgressLabel;
    private JTextArea resultTextArea;
    private ProgressBar progressBar;
    private JScrollPane jscrollpane;
    
    private StringManager stringManager = StringManager.getManager("com.sun.enterprise.tools.upgrade.gui");
    private Logger logger = com.sun.enterprise.tools.upgrade.common.CommonInfoModel.getDefaultLogger();    
    
    /** Creates a new instance of ProgressPanel */
    public ProgressPanel() {
        initialize();
    }
  
    private void initialize(){
        this.setLayout(new BorderLayout());
        HeaderPanel headerPanel = new HeaderPanel(stringManager.getString("upgrade.gui.progresspanel.headerPanel"));
        headerPanel.setInsets(new java.awt.Insets(12, 10, 12, 10));
        add(headerPanel, "North");
        add(getWizardPanel(), "Center");
        
    }  
    private JPanel getWizardPanel(){
        JPanel panel = new JPanel(new GridBagLayout());
        FlowLabel flowTopLabel = new FlowLabel();
        FlowLabel flowTextAreaLabel = new FlowLabel();
        flowProgressLabel = new FlowLabel();
        progressBar = new ProgressBar();
        resultTextArea = new JTextArea(){
            public boolean isFocusTraversable()
            {
                return false;
            }
        };
        resultTextArea.setEditable(false);
        resultTextArea.setLineWrap(true);
        jscrollpane = new JScrollPane(resultTextArea, 20, 30);
        jscrollpane.setAutoscrolls(true);
        resultTextArea.setAutoscrolls(true);
        
        flowTopLabel.setText(stringManager.getString("upgrade.gui.progresspanel.flowContentLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 10, 0);
        gridBagConstraints.weightx = 1.0;
        panel.add(flowTopLabel, gridBagConstraints);
        
        flowTextAreaLabel.setText(stringManager.getString("upgrade.gui.progresspanel.textAreaText"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 0, 10);
        gridBagConstraints.weightx = 1.0;
        panel.add(flowTextAreaLabel, gridBagConstraints);
        
        gridBagConstraints = new java.awt.GridBagConstraints();  
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 10, 10);
        gridBagConstraints.weightx = 1.0; gridBagConstraints.weighty = 1.0;
        panel.add(jscrollpane, gridBagConstraints);
        
        flowProgressLabel.setText(stringManager.getString("upgrade.gui.progresspanel.progressLabel"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        gridBagConstraints.weightx = 1.0;
        panel.add(flowProgressLabel, gridBagConstraints);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
        panel.add(progressBar, gridBagConstraints);
        
        return panel;
    }
    public void updateLog(LogMessageEvent evt){
        java.util.logging.LogRecord logRecord = evt.getLogRecord();
        if(logRecord != null){
            if((logRecord.getLevel().equals(Level.SEVERE)) || (logRecord.getLevel().equals(Level.WARNING))){
                //java.awt.Font origFont = this.resultTextArea.getFont();
                //java.awt.Font spFont = new java.awt.Font(this.resultTextArea.getFont().getName(), java.awt.Font.BOLD, this.resultTextArea.getFont().getSize());
                //this.resultTextArea.setFont(spFont);
                this.resultTextArea.append(logRecord.getMessage());
                this.resultTextArea.revalidate();
                //jscrollpane.getVerticalScrollBar().setValue(jscrollpane.getVerticalScrollBar().getMaximum());
                //jscrollpane.getVerticalScrollBar().setVisibleAmount(jscrollpane.getVerticalScrollBar().getMaximum());
                //this.resultTextArea.setFont(origFont);
            }else{
                this.resultTextArea.append(logRecord.getMessage());
            }
            this.resultTextArea.append("\n");            
        }else{
            this.resultTextArea.append(evt.getMessage());
        }
        this.resultTextArea.revalidate();
        jscrollpane.getVerticalScrollBar().setValue(jscrollpane.getVerticalScrollBar().getMaximum());
        jscrollpane.getVerticalScrollBar().setVisibleAmount(jscrollpane.getVerticalScrollBar().getMaximum());
    }
    public void updateProgress(UpgradeUpdateEvent evt){
        int progressState = evt.getProgressState();
        String labelText = null;
        if(evt.getProgressState() == 100){
                labelText = stringManager.getString("upgrade.gui.progresspanel.progressLabel.DONE");
        }
        if(evt.getProgressState() == -1){
            progressState = 0;
            labelText = stringManager.getString("upgrade.gui.progresspanel.progressLabel.ERROR");
            javax.swing.JOptionPane.showMessageDialog(this, stringManager.getString("upgrade.gui.progresspanel.errorProgressMsg"),
						      stringManager.getString("upgrade.gui.progresspanel.errorProgressMsgTitle"),
						      javax.swing.JOptionPane.ERROR_MESSAGE); 
        }
        this.progressBar.setProgress(progressState);         
        if(labelText != null)
            flowProgressLabel.setText(labelText);
    }    
}
