/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Element.java
 *
 * Created on August 4, 2003, 2:04 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  prakash
 */
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;

public class Description extends BaseElement {
    
    /** Creates a new instance of Element */
    public Description() {
    }
    /**
     * element - description
     * parentSource - parent of description
     * parentResult - result element to which description to be updated
     */
    public void transform(Element element, Element parentSource, Element parentResult){
        // description is updated if exists, else added if not exists.
        NodeList resultDescs = parentResult.getElementsByTagName("description");
        Element resultDesc = null;
        if(resultDescs.getLength() == 0){
            resultDesc = parentResult.getOwnerDocument().createElement("description");
            Node textNode = parentResult.getOwnerDocument().createTextNode(this.getTextNodeData(element));
            resultDesc.appendChild(textNode);
            parentResult.appendChild(resultDesc);
        }else {
            resultDesc = (Element)resultDescs.item(0);
            if((this.getTextNodeData(element)).equals(this.getTextNodeData((Element)resultDesc))){
                // If both are same there is nothing to be done, just break.
            }else if(this.getTextNode(resultDesc) == null){
                Node textNode = parentResult.getOwnerDocument().createTextNode(this.getTextNodeData(element));
                resultDesc.appendChild(textNode);
            }else{
                this.setTextNodeData(resultDesc, this.getTextNodeData(element));
            }
        }                
    }
    private String getTextNodeData(Element element){
        NodeList children = element.getChildNodes();
        for(int index=0; index < children.getLength(); index++){
            if(children.item(index).getNodeType() == Node.TEXT_NODE){
                return children.item(index).getNodeValue();
            }
        }
        return "";
    }
    private Node getTextNode(Element element){
        NodeList children = element.getChildNodes();
        for(int index=0; index < children.getLength(); index++){
            if(children.item(index).getNodeType() == Node.TEXT_NODE){
                return children.item(index);
            }
        }
        return null;
    }
    private void setTextNodeData(Element element, String textNodeData){
        NodeList children = element.getChildNodes();
        for(int index=0; index < children.getLength(); index++){
            if(children.item(index).getNodeType() == Node.TEXT_NODE){
                children.item(index).setNodeValue(textNodeData);
                return;
            }
        }        
    }
    
}
