package com.sun.enterprise.tools.verifier.tests.ejb.ias.resource;

/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.*;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;

import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ResourceEnvRef;
import com.sun.enterprise.tools.common.dd.DefaultResourcePrincipal;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;

/** ejb [0,n]
 *  resource-env-ref [0,n]
 *      resource-env-ref-name [String]
 *      jndi-name [String]
 *
 * The resource-env-ref holds all the runtime bindings for a resource
 * environment reference
 *
 *
 * @author Irfan Ahmed
 */
public class ASEjbResEnvRef extends EjbTest implements EjbCheck { 

    public Ejb testCase = null;
    public ResourceEnvRef resRefs[];
    public Result result;
    public ComponentNameConstructor compName;
    
    public void getEjb(EjbDescriptor desc, SunEjbJar iasJar)
    {
        testCase = super.getEjb(desc.getName(),iasJar);
        result = getInitializedResult();
        compName = new ComponentNameConstructor(desc);
        resRefs = testCase.getResourceEnvRef();
    }
    
    public Result check(EjbDescriptor descriptor) 
    {
        SunEjbJar ejbJar = descriptor.getEjbBundleDescriptor().getIasEjbObject();
        boolean oneFailed = false;
        
        if(ejbJar!=null)
        {
            getEjb(descriptor,ejbJar);
            if(resRefs.length > 0)
            {
                for(int j=0;j<resRefs.length;j++)
                {
                    String refName = resRefs[j].getResourceEnvRefName();
                    try
                    {
                        descriptor.getJmsDestinationReferenceByName(refName);
                        result.passed(smh.getLocalString(getClass().getName()+".passed",
                            "PASSED [AS-EJB resource-env-ref] : res-env-ref-name {0} is verified with ejb-jar.xml",
                            new Object[]{refName}));
                    }
                    catch(IllegalArgumentException iaex)
                    {
                        Verifier.debug(iaex);
                        result.failed(smh.getLocalString(getClass().getName()+".failed",
                            "FAILED [AS-EJB resource-env-ref] : The res-env-ref-name {0} is not defined in ejb-jar.xml for this bean",
                            new Object[]{refName}));
                    }
                }
            }
            else
            {
                 result.notApplicable(smh.getLocalString
                         (getClass().getName() + ".notApplicable",
                          "{0} Does not define any resource-env-ref Elements",
                          new Object[] {descriptor.getName()}));
            }
        }
        else
        {
            result.addErrorDetails(smh.getLocalString
                 (getClass().getName() + ".notRun",
                  "NOT RUN [AS-EJB] : Could not create an SunEjbJar object"));
        }
        return result;
    }
}
