package s2b;

import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.File;

/*
 * FormatDtd.java
 *
 * Created on June 13, 2002, 2:29 PM
 */

/**
 *
 * @author  sridatta
 */
public class FormatDtd {

    /** Creates a new instance of FormatDtd */
    public FormatDtd() {
    }

    private static final String USAGE =
        "java s2b.FormatDtd <originaldtd> <newdtd>";
    
    public static void usage() {
        System.out.println(USAGE);
        System.exit(1);
    }
    
    private static void generate(String origDtd, String genDtd) {
        BufferedReader fis = null;
        BufferedWriter fos = null;
        try {
            FileReader f = new FileReader(origDtd);
            fis = new BufferedReader(f);
            FileWriter outF = new FileWriter(genDtd);
            fos = new BufferedWriter(outF);
            String line = null;
            String outLine = null;
            while((line=fis.readLine()) != null) {
                //remove entities
                if(line == null) {
                    continue;
                }
                if  (line.startsWith("<!ENTITY")) {
                    if (line.endsWith(">")){ // Entity on one line -
                                             // skip it
                        continue;
                    } else {    // Entity on 2 lines skip this and next
                        fis.readLine();
                        continue;
                    }
                }
                
                outLine = line;
                outLine = line.replaceAll("property", "element-property");
                outLine = outLine.replaceAll("system-element-property", "system-property");
                outLine = outLine.replaceAll("%.*;", "CDATA   ");
                outLine = outLine.replaceAll("\t", "    ");
//                 outLine = outLine.replaceAll("CDATA(\\s+)(\")([\\S&&[^\"]]+)(\\s)([\\S&&[^\"]]+)(.*)(>)", "CDATA  \"FIXME_NOW\">");
//                 outLine = outLine.replaceAll("CDATA(\\s+)(\")([\\S&&[^\"]]+)(\\s)([\\S&&[^\"]]+)(.*)", "CDATA  \"FIXME_NOW\"");
                fos.write(outLine);
                fos.write("\n");
            }
        } catch(Exception e) {
            e.printStackTrace();
        } finally {
            try {
                fis.close();
            } catch(Exception e){}
            
            try {
                fos.close();
            } catch(Exception e){}
        }
    }
    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) {

        if(args.length != 2)
            usage();

        String origDtd = args[0];
        String genDtd = args[1];
        
        System.out.println("origdtd  " + origDtd);
        System.out.println("path  " + genDtd);
        generate(origDtd, genDtd);
    }

}
