/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.ClassToClassMapping;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil {
    private static final ClassNameToClassMapping[] sPrimitiveNameToObjectClass = new ClassNameToClassMapping[]{new ClassNameToClassMapping("int", Integer.TYPE), new ClassNameToClassMapping("long", Long.TYPE), new ClassNameToClassMapping("short", Short.TYPE), new ClassNameToClassMapping("byte", Byte.TYPE), new ClassNameToClassMapping("boolean", Boolean.TYPE), new ClassNameToClassMapping("float", Float.TYPE), new ClassNameToClassMapping("double", Double.TYPE), new ClassNameToClassMapping("char", Character.TYPE), new ClassNameToClassMapping("void", Void.TYPE)};
    private static final ClassToClassMapping[] sPrimitiveClassToObjectClass = new ClassToClassMapping[]{new ClassToClassMapping(Boolean.TYPE, Boolean.class), new ClassToClassMapping(Byte.TYPE, Byte.class), new ClassToClassMapping(Character.TYPE, Character.class), new ClassToClassMapping(Short.TYPE, Short.class), new ClassToClassMapping(Integer.TYPE, Integer.class), new ClassToClassMapping(Long.TYPE, Long.class), new ClassToClassMapping(Float.TYPE, Float.class), new ClassToClassMapping(Double.TYPE, Double.class)};
    static final String javaLang = "java.lang.";
    static final String[] sJavaLangTypes = new String[]{"Character", "Boolean", "Byte", "Short", "Integer", "Long", "Float", "Double", "String", "Object"};
    static final int sNumBaseTypes = Array.getLength(sJavaLangTypes);

    private ClassUtil() {
    }

    public static boolean classIsAccessible(String name) {
        boolean accessible = false;
        try {
            accessible = ClassUtil.getClassFromName(name) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return accessible;
    }

    public static boolean sigsEqual(Class[] sig1, Class[] sig2) {
        boolean equal;
        boolean bl = equal = sig1.length == sig2.length;
        if (equal) {
            for (int i = 0; i < sig1.length; ++i) {
                if (sig1[i] == sig2[i]) continue;
                equal = false;
                break;
            }
        }
        return equal;
    }

    public static boolean objectIsArray(Object o) {
        return ClassUtil.classIsArray(o.getClass());
    }

    public static boolean classIsArray(Class theClass) {
        return ClassUtil.classnameIsArray(theClass.getName());
    }

    public static boolean objectIsPrimitiveArray(Object o) {
        return ClassUtil.getPrimitiveArrayTypeCode(o.getClass()) != '\u0000';
    }

    public static boolean classnameIsArray(String classname) {
        return classname.startsWith("[");
    }

    public static String stripPackageName(String classname) {
        int lastDot = classname.lastIndexOf(".");
        if (lastDot < 0) {
            return classname;
        }
        return classname.substring(lastDot + 1, classname.length());
    }

    public static boolean classnameIsPrimitiveArray(String classname) {
        return ClassUtil.getPrimitiveArrayTypeCode(classname) != '\u0000';
    }

    public static char getPrimitiveArrayTypeCode(Class theClass) {
        char typeCode = '\u0000';
        if (ClassUtil.classIsArray(theClass)) {
            typeCode = ClassUtil.getPrimitiveArrayTypeCode(theClass.getName());
        }
        return typeCode;
    }

    public static char getPrimitiveArrayTypeCode(String classname) {
        char typeCode = '\u0000';
        int length = classname.length();
        if (ClassUtil.classnameIsArray(classname) && classname.charAt(length - 2) == '[') {
            typeCode = classname.charAt(length - 1);
            switch (typeCode) {
                default: {
                    typeCode = '\u0000';
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': 
            }
        }
        return typeCode;
    }

    public static String getArrayMemberClassName(String classname) {
        String result = null;
        if (!ClassUtil.classnameIsArray(classname)) {
            throw new IllegalArgumentException("not an array");
        }
        int classnameLength = classname.length();
        if (ClassUtil.classnameIsPrimitiveArray(classname)) {
            char lastChar = classname.charAt(classnameLength - 1);
            switch (lastChar) {
                default: {
                    throw new RuntimeException("illegal primitive");
                }
                case 'Z': {
                    result = "boolean";
                    break;
                }
                case 'B': {
                    result = "byte";
                    break;
                }
                case 'C': {
                    result = "char";
                    break;
                }
                case 'S': {
                    result = "short";
                    break;
                }
                case 'I': {
                    result = "int";
                    break;
                }
                case 'J': {
                    result = "long";
                    break;
                }
                case 'F': {
                    result = "float";
                    break;
                }
                case 'D': {
                    result = "double";
                    break;
                }
            }
        } else {
            result = classname.substring(2, classnameLength - 1);
        }
        return result;
    }

    public static Class<?> classForName(String name) throws ClassNotFoundException {
        Class<?> c = null;
        try {
            c = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            c = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        catch (NoClassDefFoundError e) {
            c = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        return c;
    }

    public static Class getClassFromName(String classname) throws ClassNotFoundException {
        Class theClass = null;
        if (classname.startsWith("[L")) {
            theClass = ClassUtil.classForName(classname);
        } else {
            int numMappings = Array.getLength(sPrimitiveNameToObjectClass);
            for (int i = 0; i < numMappings; ++i) {
                if (!ClassUtil.sPrimitiveNameToObjectClass[i].mName.equals(classname)) continue;
                theClass = ClassUtil.sPrimitiveNameToObjectClass[i].mClass;
                break;
            }
            if (theClass == null) {
                theClass = ClassUtil.classForName(classname);
            }
        }
        return theClass;
    }

    public static Class PrimitiveClassToObjectClass(Class theClass) {
        Class result = theClass;
        int numMappings = Array.getLength(sPrimitiveClassToObjectClass);
        for (int i = 0; i < numMappings; ++i) {
            ClassToClassMapping mapping = sPrimitiveClassToObjectClass[i];
            if (mapping.mSrc != theClass) continue;
            result = mapping.mDest;
            break;
        }
        return result;
    }

    public static Class ObjectClassToPrimitiveClass(Class theClass) {
        Class result = theClass;
        int numMappings = Array.getLength(sPrimitiveClassToObjectClass);
        for (int i = 0; i < numMappings; ++i) {
            ClassToClassMapping mapping = sPrimitiveClassToObjectClass[i];
            if (mapping.mDest != theClass) continue;
            result = mapping.mSrc;
            break;
        }
        return result;
    }

    public static boolean IsPrimitiveClass(Class theClass) {
        boolean isSimple = false;
        int numMappings = Array.getLength(sPrimitiveClassToObjectClass);
        for (int i = 0; i < numMappings; ++i) {
            ClassToClassMapping mapping = sPrimitiveClassToObjectClass[i];
            if (!mapping.mSrc.equals(theClass)) continue;
            isSimple = true;
            break;
        }
        return isSimple;
    }

    public static String PrimitiveLetterToClassName(char primitive) {
        String result = "" + primitive;
        switch (primitive) {
            case 'B': {
                result = "byte";
                break;
            }
            case 'C': {
                result = "char";
                break;
            }
            case 'D': {
                result = "double";
                break;
            }
            case 'F': {
                result = "float";
                break;
            }
            case 'I': {
                result = "int";
                break;
            }
            case 'J': {
                result = "long";
                break;
            }
            case 'S': {
                result = "short";
                break;
            }
            case 'Z': {
                result = "boolean";
            }
        }
        return result;
    }

    public static String[] getTypes(Object[] args) {
        if (args == null) {
            return null;
        }
        int numArgs = Array.getLength(args);
        String[] types = new String[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            types[i] = args[i] == null ? null : args[i].getClass().getName();
        }
        return types;
    }

    public static Class[] signatureFromClassnames(String[] classnames) throws ClassNotFoundException {
        if (classnames == null) {
            return null;
        }
        Class[] signature = new Class[classnames.length];
        for (int i = 0; i < signature.length; ++i) {
            signature[i] = ClassUtil.getClassFromName(classnames[i]);
        }
        return signature;
    }

    public static String[] classnamesFromSignature(Class[] classes) {
        String[] classnames = new String[classes.length];
        for (int i = 0; i < classnames.length; ++i) {
            classnames[i] = classes[i].getName();
        }
        return classnames;
    }

    public static String getFriendlyClassname(Class theClass) {
        return ClassUtil.getFriendlyClassname(theClass.getName());
    }

    public static String getFriendlyClassname(String type) {
        String result = type;
        if (type.startsWith("[")) {
            int depth = 0;
            while (type.charAt(depth) == '[') {
                ++depth;
            }
            result = type.substring(depth, type.length());
            if (result.startsWith("L") && result.endsWith(";")) {
                result = result.substring(1, result.length() - 1);
            } else if (result.length() == 1) {
                switch (result.charAt(0)) {
                    case 'Z': {
                        result = "boolean";
                        break;
                    }
                    case 'B': {
                        result = "byte";
                        break;
                    }
                    case 'C': {
                        result = "char";
                        break;
                    }
                    case 'S': {
                        result = "short";
                        break;
                    }
                    case 'I': {
                        result = "int";
                        break;
                    }
                    case 'J': {
                        result = "long";
                        break;
                    }
                    case 'F': {
                        result = "float";
                        break;
                    }
                    case 'D': {
                        result = "double";
                    }
                }
            }
            for (int i = 0; i < depth; ++i) {
                result = result + "[]";
            }
        }
        if (result.startsWith(javaLang)) {
            result = result.substring(javaLang.length(), result.length());
        }
        return result;
    }

    public static int getArrayDimensions(Class theClass) {
        String classname = theClass.getName();
        int dim = 0;
        while (classname.charAt(dim) == '[') {
            ++dim;
        }
        return dim;
    }

    public static Class getArrayElementClass(Class arrayClass) {
        Class theClass;
        block7: {
            String arrayClassName = arrayClass.getName();
            if (!ClassUtil.classnameIsArray(arrayClassName)) {
                throw new IllegalArgumentException("not an array");
            }
            String name = arrayClassName;
            if (!(name = name.substring(1, name.length())).startsWith("[")) {
                if (name.startsWith("L")) {
                    name = name.substring(1, name.length() - 1);
                } else if (name.length() == 1) {
                    name = ClassUtil.PrimitiveLetterToClassName(name.charAt(0));
                }
            }
            theClass = null;
            try {
                theClass = ClassUtil.getClassFromName(name);
            }
            catch (ClassNotFoundException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
        return theClass;
    }

    public static Class getInnerArrayElementClass(Class arrayClass) throws ClassNotFoundException {
        Class elementClass = arrayClass;
        while (ClassUtil.classIsArray(elementClass = ClassUtil.getArrayElementClass(elementClass))) {
        }
        return elementClass;
    }

    private static Object InstantiateObject(String theString) throws Exception {
        Object result = null;
        try {
            result = ClassUtil.InstantiateNumber(theString);
        }
        catch (NumberFormatException e) {
            result = theString;
        }
        return result;
    }

    public static boolean signaturesAreCompatible(Class<?>[] callee, Class<?>[] argsSignature) {
        boolean compatible = false;
        if (callee.length == argsSignature.length) {
            compatible = true;
            for (int i = 0; i < callee.length; ++i) {
                if (callee[i].isAssignableFrom(argsSignature[i])) continue;
                compatible = false;
                break;
            }
        }
        return compatible;
    }

    public static final Method findMethod(Class theClass, String methodName, Class[] sig) {
        Method m = null;
        try {
            m = theClass.getMethod(methodName, sig);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return m;
    }

    public static final Set<Method> findMethods(Method[] candidates, String methodName) {
        HashSet<Method> s = new HashSet<Method>();
        for (int methodIdx = 0; methodIdx < candidates.length; ++methodIdx) {
            Method method = candidates[methodIdx];
            if (!method.getName().equals(methodName)) continue;
            s.add(method);
        }
        return s;
    }

    public static Object InstantiateObject(Class theClass, Object[] args) throws Exception {
        Constructor<Object> constructor;
        block7: {
            Class[] signature = new Class[args.length];
            for (int i = 0; i < signature.length; ++i) {
                signature[i] = args[i].getClass();
            }
            constructor = null;
            try {
                constructor = theClass.getConstructor(signature);
            }
            catch (NoSuchMethodException e) {
                Constructor<?>[] constructors = theClass.getConstructors();
                int numMatches = 0;
                for (int i = 0; i < constructors.length; ++i) {
                    Constructor<?> tempConstructor = constructors[i];
                    Class<?>[] tempSignature = tempConstructor.getParameterTypes();
                    if (!ClassUtil.signaturesAreCompatible(tempSignature, signature)) continue;
                    ++numMatches;
                    constructor = tempConstructor;
                }
                if (numMatches == true) break block7;
                throw e;
            }
        }
        Object result = null;
        try {
            result = constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
        return result;
    }

    public static Object InstantiateObject(Class theClass, String theString) throws Exception {
        Class[] signature = new Class[]{String.class};
        Constructor constructor = theClass.getConstructor(signature);
        Object result = null;
        try {
            result = constructor.newInstance(theString);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
        return result;
    }

    private static Object InstantiateNumber(String theString) throws Exception {
        Object result = null;
        if (theString.indexOf(46) >= 0) {
            result = ClassUtil.InstantiateObject(Double.class, theString);
        } else {
            try {
                result = ClassUtil.InstantiateObject(Integer.class, theString);
            }
            catch (NumberFormatException e) {
                result = ClassUtil.InstantiateObject(Long.class, theString);
            }
        }
        return result;
    }

    public static Object InstantiateFromString(Class theClass, String theString) throws Exception {
        Object result = null;
        if (theClass == Object.class) {
            result = ClassUtil.InstantiateObject(theString);
        } else if (theClass == Number.class) {
            result = ClassUtil.InstantiateNumber(theString);
        } else if (theClass == Character.class || theClass == Character.TYPE) {
            if (theString.length() != 1) {
                throw new IllegalArgumentException("not a character: " + theString);
            }
            result = new Character(theString.charAt(0));
        } else {
            Class objectClass = ClassUtil.PrimitiveClassToObjectClass(theClass);
            result = ClassUtil.InstantiateObject(objectClass, theString);
        }
        return result;
    }

    public static Object InstantiateDefault(Class inClass) throws Exception {
        Object result = null;
        Class objectClass = ClassUtil.PrimitiveClassToObjectClass(inClass);
        if (Number.class.isAssignableFrom(objectClass)) {
            result = ClassUtil.InstantiateFromString(objectClass, "0");
        } else if (objectClass == Boolean.class) {
            result = new Boolean("true");
        } else if (objectClass == Character.class) {
            result = new Character('X');
        } else if (ClassUtil.classIsArray(objectClass)) {
            result = Array.newInstance(objectClass, 0);
        } else if (objectClass == Object.class) {
            result = new String("anyObject");
        } else if (objectClass == String.class) {
            result = new String("");
        } else if (objectClass == URL.class) {
            result = new URL("http://www.sun.com");
        } else if (objectClass == URI.class) {
            result = new URI("http://www.sun.com");
        } else if (ClassUtil.classIsArray(inClass)) {
            int dimensions = 3;
            result = Array.newInstance(ClassUtil.getInnerArrayElementClass(inClass), 3);
        } else {
            result = objectClass.newInstance();
        }
        return result;
    }

    public static String ExpandClassName(String name) {
        String fullName = name;
        int numTypes = sNumBaseTypes;
        for (int i = 0; i < numTypes; ++i) {
            if (!name.equals(sJavaLangTypes[i])) continue;
            fullName = javaLang + name;
            break;
        }
        if (fullName == name) {
            if (name.equals("Number")) {
                fullName = javaLang + name;
            } else if (name.equals("BigDecimal") || name.equals("BigInteger")) {
                fullName = "java.math." + name;
            } else if (name.equals("URL") || name.equals("URI")) {
                fullName = "java.net." + name;
            } else if (name.equals("Date")) {
                fullName = "java.util." + name;
            } else if (name.equals("ObjectName")) {
                fullName = "javax.management." + name;
            }
        }
        return fullName;
    }

    public static Class convertArrayClass(Class arrayClass, Class newInnerType) throws ClassNotFoundException {
        String arrayClassname = arrayClass.getName();
        if (!arrayClassname.endsWith(";")) {
            throw new IllegalArgumentException("not an array of Object");
        }
        int innerNameBegin = 1 + arrayClassname.indexOf("L");
        String newClassName = arrayClassname.substring(0, innerNameBegin) + newInnerType.getName() + ";";
        Class newClass = ClassUtil.getClassFromName(newClassName);
        return newClass;
    }

    public static Package[] getPackages() {
        return new MyClassLoader().getPackages();
    }

    public static Package[] getPackages(ClassLoader cl) {
        return new MyClassLoader(cl).getPackages();
    }

    public static Object getFieldValue(Class theInterface, String name) {
        Object value = null;
        try {
            Field field = theInterface.getField(name);
            value = field.get(theInterface);
        }
        catch (Exception e) {
            value = null;
        }
        return value;
    }

    public static String stripPackagePrefix(String classname) {
        int index = classname.lastIndexOf(".");
        String result = classname;
        if (index > 0) {
            result = classname.substring(index + 1, classname.length());
        }
        return result;
    }

    public static String getPackagePrefix(String classname) {
        int index = classname.lastIndexOf(".");
        String result = classname;
        if (index > 0) {
            result = classname.substring(0, index);
        }
        return result;
    }

    static final class ClassNameToClassMapping {
        String mName;
        Class mClass;

        ClassNameToClassMapping(String name, Class theClass) {
            this.mName = name;
            this.mClass = theClass;
        }
    }

    private static class MyClassLoader
    extends ClassLoader {
        MyClassLoader() {
            this(Thread.currentThread().getContextClassLoader());
        }

        MyClassLoader(ClassLoader cl) {
            super(cl);
        }

        public Package[] getPackages() {
            return super.getPackages();
        }
    }
}

