/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server;

import com.sun.appserv.server.LifecycleEvent;
import com.sun.appserv.server.LifecycleEventContext;
import com.sun.appserv.server.LifecycleEventContextImpl;
import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.loader.ClassLoaderUtils;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Context;

public final class ServerLifecycleModule {
    private LifecycleListener slcl;
    private String name;
    private String className;
    private String classpath;
    private int loadOrder;
    private boolean isFatal = true;
    private String statusMsg = "OK";
    private ServerContext ctx;
    private LifecycleEventContext leContext;
    private ClassLoader urlClassLoader;
    private Properties props = new Properties();
    private static Logger _logger = null;
    private static boolean _isTraceEnabled = false;
    private static ResourceBundle _rb = null;
    private ComponentInvocation lcmInvocation;

    ServerLifecycleModule(ServerContext ctx, String name, String className) {
        this.name = name;
        this.className = className;
        this.ctx = ctx;
        this.leContext = new LifecycleEventContextImpl(ctx);
        _logger = LogDomains.getLogger((String)"javax.enterprise");
        _isTraceEnabled = _logger.isLoggable(Level.FINE);
        _rb = _logger.getResourceBundle();
    }

    void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    void setProperty(String name, String value) {
        this.props.put(name, value);
    }

    Properties getProperties() {
        return this.props;
    }

    void setLoadOrder(int loadOrder) {
        this.loadOrder = loadOrder;
    }

    void setIsFatal(boolean isFatal) {
        this.isFatal = isFatal;
    }

    String getName() {
        return this.name;
    }

    String getClassName() {
        return this.className;
    }

    String getclasspath() {
        return this.classpath;
    }

    int getLoadOrder() {
        return this.loadOrder;
    }

    boolean isFatal() {
        return this.isFatal;
    }

    LifecycleListener loadServerLifecycle() throws ServerLifecycleException {
        ClassLoader classLoader = this.ctx.getLifecycleParentClassLoader();
        try {
            if (this.classpath != null) {
                URL[] urls = this.getURLs();
                if (urls != null) {
                    StringBuffer sb = new StringBuffer(128);
                    for (int i = 0; i < urls.length; ++i) {
                        sb.append(urls[i].toString());
                    }
                    if (_isTraceEnabled) {
                        _logger.fine("Lifecycle module = " + this.getName() + " has classpath URLs = " + sb.toString());
                    }
                }
                classLoader = this.urlClassLoader = new URLClassLoader(urls, classLoader);
            }
            Class<?> cl = Class.forName(this.className, true, classLoader);
            this.slcl = (LifecycleListener)cl.newInstance();
        }
        catch (Exception ee) {
            String msg = _rb.getString("lifecyclemodule.load_exception");
            Object[] params = new Object[]{this.name, ee.toString()};
            msg = MessageFormat.format(msg, params);
            _logger.log(Level.WARNING, msg);
        }
        return this.slcl;
    }

    private URL[] getURLs() {
        return ClassLoaderUtils.getUrlsFromClasspath((String)this.classpath);
    }

    private void preInvoke(InvocationManager invMgr) throws ServerLifecycleException {
        try {
            invMgr.preInvoke(this.lcmInvocation);
        }
        catch (InvocationException ie) {
            String msg = _rb.getString("lifecyclemodule.preInvoke_exception");
            Object[] params = new Object[]{this.name};
            msg = MessageFormat.format(msg, params);
            throw new ServerLifecycleException(msg, ie);
        }
    }

    private void postInvoke(InvocationManager invMgr) throws ServerLifecycleException {
        try {
            invMgr.postInvoke(this.lcmInvocation);
        }
        catch (InvocationException ie) {
            String msg = _rb.getString("lifecyclemodule.postInvoke_exception");
            Object[] params = new Object[]{this.name};
            msg = MessageFormat.format(msg, params);
            throw new ServerLifecycleException(msg, ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postEvent(int eventType, Object data, InvocationManager invMgr) throws ServerLifecycleException {
        if (this.slcl == null) {
            if (this.isFatal) {
                String msg = _rb.getString("lifecyclemodule.loadExceptionIsFatal");
                Object[] params = new Object[]{this.name};
                msg = MessageFormat.format(msg, params);
                throw new ServerLifecycleException(msg);
            }
            return;
        }
        if (this.urlClassLoader != null) {
            this.setClassLoader();
        }
        if (invMgr != null) {
            this.preInvoke(invMgr);
        }
        LifecycleEvent slcEvent = new LifecycleEvent(this, eventType, data, this.leContext);
        try {
            this.slcl.handleEvent(slcEvent);
        }
        catch (ServerLifecycleException sle) {
            String msg = _rb.getString("lifecyclemodule.event_ServerLifecycleException");
            Object[] params = new Object[]{this.name};
            msg = MessageFormat.format(msg, params);
            _logger.log(Level.WARNING, msg, sle);
            if (this.isFatal) {
                throw sle;
            }
        }
        catch (Exception ee) {
            String msg = _rb.getString("lifecyclemodule.event_Exception");
            Object[] params = new Object[]{this.name};
            msg = MessageFormat.format(msg, params);
            _logger.log(Level.WARNING, msg, ee);
            if (this.isFatal) {
                throw new ServerLifecycleException(_rb.getString("lifecyclemodule.event_exceptionIsFatal"), ee);
            }
        }
        finally {
            if (invMgr != null) {
                this.postInvoke(invMgr);
            }
        }
    }

    public void onInitialization(ServerContext context) throws ServerLifecycleException {
        this.postEvent(0, this.props, null);
    }

    public void onStartup(ServerContext context, Context invContext) throws ServerLifecycleException {
        this.lcmInvocation = new ComponentInvocation((Object)this.slcl, (Object)invContext);
        this.postEvent(1, this.props, this.ctx.getInvocationManager());
    }

    public void onReady(ServerContext context) throws ServerLifecycleException {
        this.postEvent(2, this.props, this.ctx.getInvocationManager());
    }

    public void onShutdown() throws ServerLifecycleException {
        this.postEvent(3, this.props, this.ctx.getInvocationManager());
    }

    public void onTermination() throws ServerLifecycleException {
        this.postEvent(4, this.props, this.ctx.getInvocationManager());
        this.lcmInvocation = null;
    }

    private void setClassLoader() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(ServerLifecycleModule.this.urlClassLoader);
                return null;
            }
        });
    }

    public String getStatus() {
        return this.statusMsg;
    }

    public String toString() {
        return "Server LifecycleListener support";
    }
}

