/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.client;

import com.sun.esb.management.api.administration.AdministrationService;
import com.sun.esb.management.api.configuration.ConfigurationService;
import com.sun.esb.management.api.deployment.DeploymentService;
import com.sun.esb.management.api.installation.InstallationService;
import com.sun.esb.management.api.notification.NotificationService;
import com.sun.esb.management.api.performance.PerformanceMeasurementService;
import com.sun.esb.management.api.runtime.RuntimeManagementService;
import com.sun.esb.management.common.ImplementationMap;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.Service;
import com.sun.esb.management.impl.administration.AdministrationServiceImpl;
import com.sun.esb.management.impl.configuration.ConfigurationServiceImpl;
import com.sun.esb.management.impl.deployment.DeploymentServiceImpl;
import com.sun.esb.management.impl.installation.InstallationServiceImpl;
import com.sun.esb.management.impl.notification.NotificationServiceImpl;
import com.sun.esb.management.impl.performance.PerformanceMeasurementServiceImpl;
import com.sun.esb.management.impl.runtime.RuntimeManagementServiceImpl;
import com.sun.jbi.ui.common.I18NBundle;
import java.io.Serializable;
import javax.management.MBeanServerConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementClient
implements Serializable {
    private static I18NBundle I18NBUNDLE = null;
    static final long serialVersionUID = -1L;
    boolean isRemoteConnection;
    transient MBeanServerConnection remoteConnection;

    protected static I18NBundle getI18NBundle() {
        if (I18NBUNDLE == null) {
            I18NBUNDLE = new I18NBundle("com.sun.caps.management.client");
        }
        return I18NBUNDLE;
    }

    public ManagementClient() {
        this(null, false);
    }

    public ManagementClient(MBeanServerConnection serverConnection) {
        this(serverConnection, false);
    }

    public ManagementClient(MBeanServerConnection serverConnection, boolean isRemoteConnection) {
        this.remoteConnection = serverConnection;
        this.isRemoteConnection = isRemoteConnection;
    }

    public AdministrationService getAdministrationService() throws ManagementRemoteException {
        return new AdministrationServiceImpl(this.remoteConnection, this.isRemoteConnection);
    }

    public ConfigurationService getConfigurationService() throws ManagementRemoteException {
        return new ConfigurationServiceImpl(this.remoteConnection, this.isRemoteConnection);
    }

    public DeploymentService getDeploymentService() throws ManagementRemoteException {
        return new DeploymentServiceImpl(this.remoteConnection, this.isRemoteConnection);
    }

    public InstallationService getInstallationService() throws ManagementRemoteException {
        return new InstallationServiceImpl(this.remoteConnection, this.isRemoteConnection);
    }

    public PerformanceMeasurementService getPerformanceMeasurementService() throws ManagementRemoteException {
        return new PerformanceMeasurementServiceImpl(this.remoteConnection, this.isRemoteConnection);
    }

    public RuntimeManagementService getRuntimeManagementService() throws ManagementRemoteException {
        return new RuntimeManagementServiceImpl(this.remoteConnection, this.isRemoteConnection);
    }

    public NotificationService getNotificationService() throws ManagementRemoteException {
        return new NotificationServiceImpl(this.remoteConnection, this.isRemoteConnection);
    }

    public boolean isRemoteConnection() {
        return this.isRemoteConnection;
    }

    public <CLASS_TYPE> CLASS_TYPE getService(Class<?> mapperClass) {
        ImplementationMap map = mapperClass.getAnnotation(ImplementationMap.class);
        Class<?> implementationClass = map.implementationClass();
        CLASS_TYPE theObject = null;
        Service theService = null;
        try {
            theService = (Service)implementationClass.newInstance();
            theObject = theService.getService(this.remoteConnection, this.isRemoteConnection);
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (ManagementRemoteException e) {
            // empty catch block
        }
        return theObject;
    }

    public String getClientAPIVersion(Class mapperClass) {
        String version = "";
        ImplementationMap map = mapperClass.getAnnotation(ImplementationMap.class);
        if (map != null) {
            return map.clientAPIVersion();
        }
        return version;
    }
}

