/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.data.ConsumingEndpointStatisticsData;
import com.sun.esb.management.common.data.IEndpointStatisticsData;
import com.sun.esb.management.common.data.PerformanceData;
import com.sun.esb.management.common.data.ProvisioningEndpointStatisticsData;
import com.sun.esb.management.common.data.helper.EndpointStatisticsDataXMLConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointStatisticsDataReader
extends DefaultHandler
implements EndpointStatisticsDataXMLConstants,
Serializable {
    static final long serialVersionUID = -1L;
    private boolean parsingInProgress;
    private Stack<String> qNameStack = new Stack();
    private String endpointStatisticsDataListVersion;
    private IEndpointStatisticsData data;
    private ProvisioningEndpointStatisticsData provisioningData;
    private ConsumingEndpointStatisticsData consumingData;
    private Map<String, IEndpointStatisticsData> dataMap;
    private PerformanceData performanceData;
    private Map<String, PerformanceData> performanceDataMap;
    private String performanceDataListVersion;

    public Map<String, IEndpointStatisticsData> getEndpointStatisticsDataMap() {
        return this.dataMap;
    }

    @Override
    public void startDocument() throws SAXException {
        this.parsingInProgress = true;
        this.qNameStack.removeAllElements();
    }

    @Override
    public void endDocument() throws SAXException {
        this.parsingInProgress = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName != null) {
            if (qName.endsWith("EndpointStatisticsDataList")) {
                if (attributes != null && attributes.getLength() > 0) {
                    String namespace = attributes.getValue("xmlns");
                    this.endpointStatisticsDataListVersion = attributes.getValue("version");
                    if (this.endpointStatisticsDataListVersion != null && "1.0".equals(this.endpointStatisticsDataListVersion)) {
                        this.dataMap = new HashMap<String, IEndpointStatisticsData>();
                    }
                }
            } else if (qName.endsWith("ProvisioningEndpointStatisticsData")) {
                if (this.dataMap != null) {
                    this.data = new ProvisioningEndpointStatisticsData();
                    this.provisioningData = (ProvisioningEndpointStatisticsData)this.data;
                }
            } else if (qName.endsWith("ConsumingEndpointStatisticsData")) {
                if (this.dataMap != null) {
                    this.data = new ConsumingEndpointStatisticsData();
                    this.consumingData = (ConsumingEndpointStatisticsData)this.data;
                }
            } else if (qName.endsWith("PerformanceMeasurementDataList")) {
                if (attributes != null && attributes.getLength() > 0) {
                    String namespace = attributes.getValue("xmlns");
                    this.performanceDataListVersion = attributes.getValue("version");
                    if (this.performanceDataListVersion != null && "1.0".equals(this.performanceDataListVersion)) {
                        this.performanceDataMap = new HashMap<String, PerformanceData>();
                    }
                }
            } else if (qName.endsWith("PerformanceMeasurementData") && this.performanceDataMap != null) {
                this.performanceData = new PerformanceData();
            }
            this.qNameStack.push(qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        Comparable<Long> value;
        String chars = new String(ch, start, length);
        String qName = this.qNameStack.peek();
        if (qName.endsWith("ActivationTime")) {
            if (this.data == null) {
                this.data = new ProvisioningEndpointStatisticsData();
                this.provisioningData = (ProvisioningEndpointStatisticsData)this.data;
            }
            value = null;
            SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            try {
                value = format.parse(chars);
            }
            catch (ParseException e) {
                // empty catch block
            }
            this.provisioningData.setActivationTime((Date)value);
        }
        if (qName.endsWith("NumberOfActiveExchanges")) {
            if (this.data == null) {
                this.data = new ProvisioningEndpointStatisticsData();
                this.provisioningData = (ProvisioningEndpointStatisticsData)this.data;
            }
            value = new Long(chars);
            this.provisioningData.setNumberOfActiveExchanges((Long)value);
        }
        if (qName.endsWith("NumberOfReceivedRequests")) {
            if (this.data == null) {
                this.data = new ProvisioningEndpointStatisticsData();
                this.provisioningData = (ProvisioningEndpointStatisticsData)this.data;
            }
            value = new Long(chars);
            this.provisioningData.setNumberOfReceivedRequests((Long)value);
        }
        if (qName.endsWith("NumberOfSentReplies")) {
            if (this.data == null) {
                this.data = new ProvisioningEndpointStatisticsData();
                this.provisioningData = (ProvisioningEndpointStatisticsData)this.data;
            }
            value = new Long(chars);
            this.provisioningData.setNumberOfSentReplies((Long)value);
        }
        if (qName.endsWith("Uptime")) {
            if (this.data == null) {
                this.data = new ProvisioningEndpointStatisticsData();
                this.provisioningData = (ProvisioningEndpointStatisticsData)this.data;
            }
            value = new Long(chars);
            this.provisioningData.setUptime((Long)value);
        }
        if (qName.endsWith("MessageExchangeResponseTimeAverage")) {
            if (this.data == null) {
                this.data = new ProvisioningEndpointStatisticsData();
                this.provisioningData = (ProvisioningEndpointStatisticsData)this.data;
            }
            value = new Long(chars);
            this.provisioningData.setMessageExchangeResponseTimeAverage((Long)value);
        }
        if (qName.endsWith("NumberOfReceivedReplies")) {
            if (this.data == null) {
                this.data = new ConsumingEndpointStatisticsData();
                this.consumingData = (ConsumingEndpointStatisticsData)this.data;
            }
            value = new Long(chars);
            this.consumingData.setNumberOfReceivedReplies((Long)value);
        }
        if (qName.endsWith("NumberOfSentRequests")) {
            if (this.data == null) {
                this.data = new ConsumingEndpointStatisticsData();
                this.consumingData = (ConsumingEndpointStatisticsData)this.data;
            }
            value = new Long(chars);
            this.consumingData.setNumberOfSentRequests((Long)value);
        }
        if (qName.endsWith("MessageExchangeStatusTimeAverage")) {
            if (this.data == null) {
                this.data = new ConsumingEndpointStatisticsData();
                this.consumingData = (ConsumingEndpointStatisticsData)this.data;
            }
            value = new Long(chars);
            this.consumingData.setMessageExchangeStatusTimeAverage((Long)value);
        }
        if (qName.endsWith("InstanceName") && this.data != null) {
            this.data.setInstanceName(chars);
        }
        if (qName.endsWith("ComponentName") && this.data != null) {
            this.data.setComponentName(chars);
        }
        if (qName.endsWith("ExtendedTimingStatisticsFlagEnabled")) {
            value = new Boolean(chars);
            if (this.data != null) {
                this.data.setExtendedTimingStatisticsFlagEnabled((Boolean)value);
            }
        }
        if (qName.endsWith("MessageExchangeComponentTimeAverage")) {
            value = new Long(chars);
            if (this.data != null) {
                this.data.setMessageExchangeComponentTimeAverage((Long)value);
            }
        }
        if (qName.endsWith("MessageExchangeDeliveryChannelTimeAverage")) {
            value = new Long(chars);
            if (this.data != null) {
                this.data.setMessageExchangeDeliveryChannelTimeAverage((Long)value);
            }
        }
        if (qName.endsWith("MessageExchangeServiceTimeAverage")) {
            value = new Long(chars);
            if (this.data != null) {
                this.data.setMessageExchangeServiceTimeAverage((Long)value);
            }
        }
        if (qName.endsWith("NumberOfReceivedDones")) {
            value = new Long(chars);
            if (this.data != null) {
                this.data.setNumberOfReceivedDones((Long)value);
            }
        }
        if (qName.endsWith("NumberOfReceivedErrors")) {
            value = new Long(chars);
            if (this.data != null) {
                this.data.setNumberOfReceivedErrors((Long)value);
            }
        }
        if (qName.endsWith("NumberOfReceivedFaults")) {
            value = new Long(chars);
            if (this.data != null) {
                this.data.setNumberOfReceivedFaults((Long)value);
            }
        }
        if (qName.endsWith("NumberOfSentDones")) {
            value = new Long(chars);
            if (this.data != null) {
                this.data.setNumberOfSentDones((Long)value);
            }
        }
        if (qName.endsWith("NumberOfSentErrors")) {
            value = new Long(chars);
            if (this.data != null) {
                this.data.setNumberOfSentErrors((Long)value);
            }
        }
        if (qName.endsWith("NumberOfSentFaults")) {
            value = new Long(chars);
            if (this.data != null) {
                this.data.setNumberOfSentFaults((Long)value);
            }
        }
        if (qName.endsWith("category")) {
            if (this.performanceData != null) {
                this.performanceData.setCategory(chars);
            }
        } else if (qName.endsWith("endpoint")) {
            if (this.performanceData != null) {
                this.performanceData.setEndpoint(chars);
            }
        } else if (qName.endsWith("sourceClassName")) {
            if (this.performanceData != null) {
                this.performanceData.setSourceClassName(chars);
            }
        } else if (qName.endsWith("numberOfMeasurementObjects")) {
            if (this.performanceData != null) {
                int numberOfMeasurementObjects = Integer.valueOf(chars);
                this.performanceData.setNumberOfMeasurementObjects(numberOfMeasurementObjects);
            }
        } else if (qName.endsWith("numberOfMeasurements")) {
            if (this.performanceData != null) {
                int numberOfMeasurements = Integer.valueOf(chars);
                this.performanceData.setNumberOfMeasurements(numberOfMeasurements);
            }
        } else if (qName.endsWith("average")) {
            if (this.performanceData != null) {
                double average = Double.valueOf(chars);
                this.performanceData.setAverage(average);
            }
        } else if (qName.endsWith("averageWithoutFirstMeasurement")) {
            if (this.performanceData != null) {
                double averageWithoutFirstMeasurement = Double.valueOf(chars);
                this.performanceData.setAverageWithoutFirstMeasurement(averageWithoutFirstMeasurement);
            }
        } else if (qName.endsWith("firstMeasurementTime")) {
            if (this.performanceData != null) {
                double firstMeasurementTime = Double.valueOf(chars);
                this.performanceData.setFirstMeasurementTime(firstMeasurementTime);
            }
        } else if (qName.endsWith("load")) {
            if (this.performanceData != null) {
                double load = Double.valueOf(chars);
                this.performanceData.setLoad(load);
            }
        } else if (qName.endsWith("median")) {
            if (this.performanceData != null) {
                double median = Double.valueOf(chars);
                this.performanceData.setMedian(median);
            }
        } else if (qName.endsWith("throughput")) {
            if (this.performanceData != null) {
                double throughput = Double.valueOf(chars);
                this.performanceData.setThroughput(throughput);
            }
        } else if (qName.endsWith("timeTaken")) {
            if (this.performanceData != null) {
                double timeTaken = Double.valueOf(chars);
                this.performanceData.setTimeTaken(timeTaken);
            }
        } else if (qName.endsWith("totalTime") && this.performanceData != null) {
            double totalTime = Double.valueOf(chars);
            this.performanceData.setTotalTime(totalTime);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.qNameStack.pop();
        if (qName != null) {
            if (qName.endsWith("ProvisioningEndpointStatisticsData") && this.dataMap != null && this.data != null) {
                this.dataMap.put(this.data.getInstanceName(), this.provisioningData);
                this.data = null;
                this.provisioningData = null;
            }
            if (qName.endsWith("ConsumingEndpointStatisticsData") && this.dataMap != null && this.data != null) {
                this.dataMap.put(this.data.getInstanceName(), this.consumingData);
                this.data = null;
                this.consumingData = null;
            }
            if (qName.endsWith("PerformanceMeasurementData") && this.dataMap != null && this.data != null && this.performanceDataMap != null && this.performanceData != null) {
                this.performanceDataMap.put(this.performanceData.getCategory(), this.performanceData);
                this.performanceData = null;
            }
            if (qName.endsWith("PerformanceMeasurementDataList") && this.dataMap != null && this.data != null && this.performanceDataMap != null) {
                this.data.setCategoryToPerformanceDataMap(this.performanceDataMap);
                this.performanceDataMap = null;
                this.performanceData = null;
            }
        }
    }

    public static Map<String, IEndpointStatisticsData> parseFromXMLData(String rawXMLData) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        StringReader reader = new StringReader(rawXMLData);
        InputSource inputSource = new InputSource(reader);
        EndpointStatisticsDataReader parser = new EndpointStatisticsDataReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getEndpointStatisticsDataMap();
    }

    public static Map<String, IEndpointStatisticsData> parseFromFile(String fileName) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        File file = new File(fileName);
        return EndpointStatisticsDataReader.parseFromFile(file);
    }

    public static Map<String, IEndpointStatisticsData> parseFromFile(File file) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        FileInputStream inputStream = new FileInputStream(file);
        InputSource inputSource = new InputSource(inputStream);
        EndpointStatisticsDataReader parser = new EndpointStatisticsDataReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getEndpointStatisticsDataMap();
    }

    public static Map<String, IEndpointStatisticsData> parseFromURI(String uriString) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        URI uri = new URI(uriString);
        return EndpointStatisticsDataReader.parseFromURI(uri);
    }

    public static Map<String, IEndpointStatisticsData> parseFromURI(URI uri) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        InputStream inputStream = uri.toURL().openStream();
        InputSource inputSource = new InputSource(inputStream);
        EndpointStatisticsDataReader parser = new EndpointStatisticsDataReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getEndpointStatisticsDataMap();
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/endpointstatistics/EndpointStatisticsData.xml";
        try {
            Map<String, IEndpointStatisticsData> map = null;
            map = EndpointStatisticsDataReader.parseFromFile(uri);
            for (String instanceName : map.keySet()) {
                System.out.println("////////////////////////");
                System.out.println("//" + instanceName);
                System.out.println("////////////////////////");
                System.out.println(map.get(instanceName).getDisplayString());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

