/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.eventmanagement.impl;

import com.sun.esb.eventmanagement.api.AlertPersistenceDBType;
import com.sun.esb.eventmanagement.impl.EventForwarderMBean;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.ui.common.I18NBundle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DBSchemaCreation {
    private static String CREATE_TABLES_SCRIPT = "create_event_store_tables.sql";
    private static String DROP_TABLES_SCRIPT = "drop_event_store_tables.sql";
    private static String TRUNCATE_TABLES_SCRIPT = "truncate_event_store_tables.sql";
    private static final Logger mLogger = Logger.getLogger(EventForwarderMBean.class.getName());
    private static boolean isDebugEnabled = mLogger.isLoggable(Level.FINEST);
    private I18NBundle I18NPACKAGEBUNDLE;
    private String mUniqueTableName;
    private static String DELIMITER = ";";

    public void checkAndCreateTables(AlertPersistenceDBType dbType, DataSource aDataSource) throws ManagementRemoteException {
        if (!this.checkTablesIntegrity(aDataSource)) {
            this.createTables(dbType, aDataSource);
        }
    }

    public void createTables(AlertPersistenceDBType dbType, DataSource aDataSource) throws ManagementRemoteException {
        StringTokenizer tokens = this.populateCreateScript(dbType, CREATE_TABLES_SCRIPT);
        this.executeScript(tokens, aDataSource);
    }

    public void dropTables(AlertPersistenceDBType dbType, DataSource aDataSource) throws ManagementRemoteException {
        StringTokenizer tokens = this.populateCreateScript(dbType, this.getDropScriptName());
        this.executeScript(tokens, aDataSource);
    }

    public void truncateTables(AlertPersistenceDBType dbType, DataSource aDataSource) throws ManagementRemoteException {
        StringTokenizer tokens = this.populateCreateScript(dbType, this.getTruncateScriptName());
        this.executeScript(tokens, aDataSource);
    }

    public boolean checkTablesIntegrity(DataSource aDataSource) throws ManagementRemoteException {
        boolean allTablesPresent = false;
        String dbUserName = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = aDataSource.getConnection();
            dbUserName = connection.getMetaData().getUserName();
            int numTablesFound = 0;
            String[] objectsToSearchFor = new String[]{"TABLE"};
            resultSet = connection.getMetaData().getTables(null, "%", "%", objectsToSearchFor);
            block18: while (resultSet.next() && numTablesFound != this.getTabels().length) {
                String rsTableName = resultSet.getString("TABLE_NAME");
                String rsTableSchemaName = resultSet.getString("TABLE_SCHEM");
                if (!dbUserName.equalsIgnoreCase(rsTableSchemaName)) continue;
                for (int i = 0; i < this.getTabels().length; ++i) {
                    String tableItem = this.getTabels()[i];
                    if (!rsTableName.equalsIgnoreCase(tableItem)) continue;
                    ++numTablesFound;
                    continue block18;
                }
            }
            if (numTablesFound == this.getTabels().length) {
                boolean bl = allTablesPresent = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new ManagementRemoteException(this.getPackageBundle().getMessage("DBSchemaCreation.Table.Integrity.Check.Exception", new Object[]{dbUserName}), e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException resCloseExcp) {
                    mLogger.log(Level.SEVERE, this.getPackageBundle().getMessage("DBSchemaCreation.Resultset.Close.Exception"), resCloseExcp);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    mLogger.log(Level.SEVERE, this.getPackageBundle().getMessage("DBSchemaCreation.Connection.Close.Exception"), ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringTokenizer populateCreateScript(AlertPersistenceDBType dbType, String scriptName) throws ManagementRemoteException {
        String scriptsPath = "scripts/";
        if (dbType.equals((Object)AlertPersistenceDBType.DB2)) {
            scriptsPath = scriptsPath + "db2/" + scriptName;
        } else if (dbType.equals((Object)AlertPersistenceDBType.ORACLE)) {
            scriptsPath = scriptsPath + "oracle/" + scriptName;
        } else if (dbType.equals((Object)AlertPersistenceDBType.POINTBASE)) {
            scriptsPath = scriptsPath + "pointbase/" + scriptName;
        } else if (dbType.equals((Object)AlertPersistenceDBType.SYBASE)) {
            scriptsPath = scriptsPath + "sybase/" + scriptName;
        } else if (dbType.equals((Object)AlertPersistenceDBType.DERBY)) {
            scriptsPath = scriptsPath + "derby/" + scriptName;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        InputStream is = null;
        try {
            int c;
            is = DBSchemaCreation.class.getResourceAsStream(scriptsPath);
            while ((c = is.read()) != -1) {
                os.write(c);
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ex) {}
        }
        String script = new String(os.toByteArray());
        StringTokenizer tokens = new StringTokenizer(script, DELIMITER);
        return tokens;
    }

    private void executeScript(StringTokenizer tokens, DataSource aDataSource) throws ManagementRemoteException {
        Statement stmt = null;
        Connection connection = null;
        try {
            connection = aDataSource.getConnection();
            connection.setAutoCommit(false);
            stmt = connection.createStatement();
            String element = null;
            int size = tokens.countTokens();
            for (int i = 0; i < size - 1; ++i) {
                element = tokens.nextToken();
                if (element.indexOf(" NOTIFICATION_EVENT") != -1) {
                    element = this.fixTableName(element);
                }
                stmt.execute(element);
            }
            connection.commit();
        }
        catch (Exception ex) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException e) {
                    String msg = this.getPackageBundle().getMessage("DBSchemaCreation.Connection.Rollback.Exception");
                    mLogger.log(Level.SEVERE, msg, e);
                    throw new ManagementRemoteException(msg, e);
                }
            }
            throw new ManagementRemoteException(this.getPackageBundle().getMessage("DBSchemaCreation.Exception.While.Creating.Tables"), ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    mLogger.log(Level.INFO, this.getPackageBundle().getMessage("DBSchemaCreation.Statement.Close.Exception"), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    mLogger.log(Level.INFO, this.getPackageBundle().getMessage("DBSchemaCreation.Connection.Close.Exception"), e);
                }
            }
        }
    }

    private I18NBundle getPackageBundle() {
        if (this.I18NPACKAGEBUNDLE == null) {
            this.I18NPACKAGEBUNDLE = new I18NBundle("com.sun.esb.eventmanagement.impl");
        }
        return this.I18NPACKAGEBUNDLE;
    }

    private String[] getTabels() {
        String[] tables = new String[]{this.mUniqueTableName};
        return tables;
    }

    private String getCreateScriptName() {
        return CREATE_TABLES_SCRIPT;
    }

    private String getDropScriptName() {
        return DROP_TABLES_SCRIPT;
    }

    private String getTruncateScriptName() {
        return TRUNCATE_TABLES_SCRIPT;
    }

    public void setUniqueTableName(String uniqueTableName) {
        this.mUniqueTableName = uniqueTableName;
    }

    private String fixTableName(String originalScript) {
        String fixedScript = originalScript.replace("NOTIFICATION_EVENT", this.mUniqueTableName);
        return fixedScript;
    }
}

