/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.eventmanagement.impl;

import com.sun.esb.eventmanagement.api.AlertPersistenceDBType;
import com.sun.esb.eventmanagement.api.Event;
import com.sun.esb.eventmanagement.api.InstanceIdentifier;
import com.sun.esb.eventmanagement.api.NotificationEvent;
import com.sun.esb.eventmanagement.impl.AlertLevelType;
import com.sun.esb.eventmanagement.impl.AlertPersistenceConfiguration;
import com.sun.esb.eventmanagement.impl.AlertUtil;
import com.sun.esb.eventmanagement.impl.DBEventStore;
import com.sun.esb.eventmanagement.impl.EventDataConverter;
import com.sun.esb.eventmanagement.impl.EventForwardingHelper;
import com.sun.esb.eventmanagement.impl.EventManagementConstants;
import com.sun.esb.eventmanagement.impl.InstanceIdentifierFactory;
import com.sun.esb.eventmanagement.impl.NotificationEventImpl;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.platform.PlatformContext;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnector;

public final class EventForwarderMBean
extends NotificationBroadcasterSupport
implements DynamicMBean,
MBeanRegistration,
Serializable,
EventManagementConstants {
    ExecutorService mExecutorService;
    protected ArrayList<MBeanAttributeInfo> mAttributesInfo = new ArrayList();
    protected ArrayList<MBeanConstructorInfo> mConstructorsInfo = new ArrayList();
    protected ArrayList<MBeanOperationInfo> mOperationsInfo = new ArrayList();
    protected ArrayList<MBeanNotificationInfo> mNotificationsInfo = new ArrayList();
    protected MBeanInfo mMBeanInfo;
    private JMXConnector mConnector;
    private static final Logger mLogger = Logger.getLogger(EventForwarderMBean.class.getName());
    private static boolean isDebugEnabled = mLogger.isLoggable(Level.FINEST);
    private Properties mPersistedProps;
    private MBeanServerConnection mMBeanServer;
    private transient DBEventStore mEventStore;
    private transient Thread eventForwarderThread;
    private String mHostingHostName;
    private String mHostingHttpPort;
    private boolean mShutdownInProgress;
    private String mLastCachedId;
    private long mNotificationSeqNum;
    private String mJBIinstanceRoot;
    private EventForwardingHelper mEventForwardingHelper;
    private AlertPersistenceConfiguration mAlertPersistenceConfiguration;
    private PlatformContext mPlatformContext;
    private LinkedBlockingQueue<CompositeData> mEventsQueue;
    private boolean mExecutorActive;
    private Object mSynchronizationObject = new Object();
    private Boolean mPersisteanceeEnabled = new Boolean(false);
    private AlertPersistenceDBType mDBType;
    private String mJNDIName;
    private String mDomainUniqueAlertTableName;
    private EventDataConverter mEventDataConverter;
    private String mPhysicalHostAndPort;

    public EventForwarderMBean(EnvironmentContext context) throws Exception {
        this.buildDynamicMBeanInfo();
        this.mPlatformContext = context.getPlatformContext();
        this.mExecutorService = Executors.newFixedThreadPool(2);
        this.mEventsQueue = new LinkedBlockingQueue();
        this.mJBIinstanceRoot = context.getJbiInstanceRoot() + "/config";
        this.mMBeanServer = this.mPlatformContext.getMBeanServer();
        this.mEventForwardingHelper = new EventForwardingHelper(this.mJBIinstanceRoot);
        this.mAlertPersistenceConfiguration = AlertPersistenceConfiguration.getInstance(this.mMBeanServer);
        this.mAlertPersistenceConfiguration.setAdminServer(this.mPlatformContext.isAdminServer());
        this.mPersistedProps = this.mEventForwardingHelper.GetProperties();
        this.initializeSetting();
        this.mEventStore = DBEventStore.getInstance(this.mAlertPersistenceConfiguration, this.mMBeanServer, this.mPlatformContext);
        if (this.mAlertPersistenceConfiguration.getPersistenceEnabled().booleanValue()) {
            try {
                this.mEventStore.initializeDataSource();
            }
            catch (ManagementRemoteException e) {
                mLogger.log(Level.WARNING, AlertUtil.getPackageBundle().getMessage("caps.management.server.alert.persistence.setup.error.log.msg"), e);
            }
        }
        this.mAlertPersistenceConfiguration.setDBEventStore(this.mEventStore);
    }

    protected void buildDynamicMBeanInfo() {
        this.mConstructorsInfo.add(new MBeanConstructorInfo("EventForwarderMBean Constructor", this.getClass().getConstructors()[0]));
        this.addOperationsInfo();
        this.addAttributesInfo();
        this.mMBeanInfo = new MBeanInfo(this.getClass().getName(), "Event Forwarder DynamicMBean", this.mAttributesInfo.toArray(new MBeanAttributeInfo[this.mAttributesInfo.size()]), this.mConstructorsInfo.toArray(new MBeanConstructorInfo[this.mConstructorsInfo.size()]), this.mOperationsInfo.toArray(new MBeanOperationInfo[this.mOperationsInfo.size()]), this.mNotificationsInfo.toArray(new MBeanNotificationInfo[this.mNotificationsInfo.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String aName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (aName.equals("enableTargetPersistence") || aName.equals("alertsPersistenceEnabled")) {
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                return this.mAlertPersistenceConfiguration.getPersistenceEnabled();
            }
        }
        if (aName.equals("DBJndiName")) {
            return this.mAlertPersistenceConfiguration.getDataSourceJndiName();
        }
        if (aName.equals("DBType")) {
            return this.mAlertPersistenceConfiguration.getAlertPersistenceDBType().getDatabasetype();
        }
        if (aName.equals("alertTableName")) {
            return this.mAlertPersistenceConfiguration.getAlertTableName();
        }
        if (aName.equals("PhysicalHostAndPort")) {
            return this.mPhysicalHostAndPort == null ? this.getHostAndPort() : this.mPhysicalHostAndPort;
        }
        throw new AttributeNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(Attribute aAttribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Object aNewJndi;
        if (aAttribute.getName().equals("enableTargetPersistence")) {
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                try {
                    this.mAlertPersistenceConfiguration.setPersistenceEnabled((Boolean)aAttribute.getValue());
                }
                catch (ManagementRemoteException managementRemoteException) {
                    // empty catch block
                }
            }
        }
        if (aAttribute.getName().equals("DBJndiName")) {
            aNewJndi = (String)aAttribute.getValue();
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                this.mAlertPersistenceConfiguration.setDataSourceJndiName((String)aNewJndi);
            }
            if (this.mAlertPersistenceConfiguration.getPersistenceEnabled().booleanValue()) {
                this.mEventStore.reInitializeDataSource((String)aNewJndi);
            }
        } else {
            if (aAttribute.getName().equals("DBType")) {
                aNewJndi = this.mAlertPersistenceConfiguration;
                synchronized (aNewJndi) {
                    this.mAlertPersistenceConfiguration.setAlertPersistenceDBType(AlertPersistenceDBType.valueOf((String)aAttribute.getValue()));
                }
            }
            if (aAttribute.getName().equals("alertTableName")) {
                aNewJndi = this.mAlertPersistenceConfiguration;
                synchronized (aNewJndi) {
                    this.mAlertPersistenceConfiguration.setAlertTableName((String)aAttribute.getValue());
                }
            }
        }
        if (!this.mPlatformContext.isAdminServer()) {
            Properties alertRemovalProps = this.mAlertPersistenceConfiguration.getPersistenceProperties();
            this.mPersistedProps.putAll((Map<?, ?>)alertRemovalProps);
            this.mEventForwardingHelper.saveProperties(this.mPersistedProps);
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this.mMBeanInfo;
    }

    public AttributeList getAttributes(String[] aNames) {
        AttributeList attributes = new AttributeList(aNames.length);
        for (int i = 0; i < aNames.length; ++i) {
            try {
                attributes.add(new Attribute(aNames[i], this.getAttribute(aNames[i])));
                continue;
            }
            catch (Exception e) {
                if (!mLogger.isLoggable(Level.FINE)) continue;
                mLogger.fine(">>>>EventForwarderMBean :: Unable to add attribute " + aNames[i] + " " + e);
            }
        }
        return attributes;
    }

    public AttributeList setAttributes(AttributeList aAttributes) {
        for (Attribute attribute : aAttributes) {
            try {
                this.setAttribute(attribute);
            }
            catch (Exception e) {}
        }
        return aAttributes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Object result = null;
        if (operationName.equalsIgnoreCase("forwardEvent")) {
            NotificationEvent lEvent = null;
            if (params[0] instanceof CompositeData) {
                EventDataConverter converter = new EventDataConverter();
                lEvent = converter.getEventFromCompositeData((CompositeData)params[0]);
            } else {
                lEvent = (NotificationEvent)params[0];
            }
            this.forwardEvent(lEvent);
            return result;
        } else if (operationName.equalsIgnoreCase("createAndForwardEvent")) {
            String physicalHostName = (String)params[0];
            String serverType = (String)params[1];
            String componentType = (String)params[2];
            String type = (String)params[3];
            int severity = (Integer)params[4];
            String messageCode = (String)params[5];
            String messageDetails = (String)params[6];
            if (params.length == 7) {
                this.createAndForwordEvent(physicalHostName, serverType, componentType, type, severity, messageCode, messageDetails);
                return result;
            } else if (params.length == 8) {
                int state = (Integer)params[7];
                this.createAndForwordEvent(physicalHostName, serverType, componentType, type, severity, messageCode, messageDetails, state);
                return result;
            } else {
                if (params.length != 10) throw new RuntimeOperationsException(new IllegalArgumentException("invalid number of arguments only 7,8 or 10 are allowed"));
                int state = (Integer)params[7];
                String serverName = (String)params[8];
                String componentName = (String)params[9];
                this.createAndForwordEvent(physicalHostName, serverType, componentType, type, severity, messageCode, messageDetails, state, serverName, componentName);
            }
            return result;
        } else if (operationName.equals("testSendEvent")) {
            String message = (String)params[0];
            Integer severity = (Integer)params[1];
            this.testSendEvent(message, severity);
            return result;
        } else if (operationName.equals("testSendEvents")) {
            String message = (String)params[0];
            Boolean randomize = (Boolean)params[1];
            Integer count = (Integer)params[2];
            this.testSendEvents(message, randomize, count);
            return result;
        } else {
            if (!operationName.equals("getQueuedEvents")) return result;
            return this.getQueuedEvents();
        }
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() {
        this.mShutdownInProgress = true;
        this.mEventStore.unRegisterTimerService();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardEvent(NotificationEvent aEvent) throws MBeanException {
        if (this.mShutdownInProgress) {
            this.mExecutorService.shutdown();
            return;
        }
        if (this.mEventDataConverter == null) {
            this.mEventDataConverter = new EventDataConverter();
        }
        this.fixEventPhysicalHostAttribute(aEvent);
        this.fixEventServerNameAttribute(aEvent);
        Object object = this.mAlertPersistenceConfiguration;
        synchronized (object) {
            if (this.mAlertPersistenceConfiguration.getPersistenceEnabled().booleanValue()) {
                try {
                    this.mEventStore.save(aEvent);
                }
                catch (ManagementRemoteException e) {
                    throw new MBeanException(e);
                }
                return;
            }
        }
        try {
            CompositeData compositeData = this.mEventDataConverter.getEventCompositeData(aEvent, "");
            this.mEventsQueue.add(compositeData);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        object = this.mSynchronizationObject;
        synchronized (object) {
            if (!this.mExecutorActive) {
                this.mExecutorService.execute(new EventQueueHandler());
                this.mExecutorActive = true;
            }
        }
    }

    private Object getQueuedEvents() {
        ArrayList eventsData = new ArrayList();
        this.mEventsQueue.drainTo(eventsData);
        return eventsData;
    }

    private void createAndForwordEvent(String physicalHostName, String serverType, String componentType, String type, int severity, String messageCode, String messageDetails) {
        NotificationEventImpl lEvent = new NotificationEventImpl();
        lEvent.setPhysicalHostName(physicalHostName);
        lEvent.setServerType(serverType);
        lEvent.setComponentType(componentType);
        lEvent.setType(type);
        lEvent.setSeverity(severity);
        lEvent.setMessageCode(messageCode);
        lEvent.setMessageDetails(messageDetails);
        lEvent.setTimeStamp(new Date().getTime());
        try {
            this.forwardEvent(lEvent);
        }
        catch (MBeanException e) {
            mLogger.log(Level.FINEST, "forwarding event failed", e);
        }
    }

    private void createAndForwordEvent(String physicalHostName, String serverType, String componentType, String type, int severity, String messageCode, String messageDetails, int opState) {
        NotificationEventImpl lEvent = new NotificationEventImpl();
        lEvent.setPhysicalHostName(physicalHostName);
        lEvent.setServerType(serverType);
        lEvent.setComponentType(componentType);
        lEvent.setType(type);
        lEvent.setSeverity(severity);
        lEvent.setMessageCode(messageCode);
        lEvent.setMessageDetails(messageDetails);
        lEvent.setTimeStamp(new Date().getTime());
        lEvent.setOperationalState(opState);
        try {
            this.forwardEvent(lEvent);
        }
        catch (MBeanException e) {
            mLogger.log(Level.FINEST, "forwarding event failed", e);
        }
    }

    private void createAndForwordEvent(String physicalHostName, String serverType, String componentType, String type, int severity, String messageCode, String messageDetails, int opState, String serverName, String componentName) {
        NotificationEventImpl lEvent = new NotificationEventImpl();
        lEvent.setPhysicalHostName(physicalHostName);
        lEvent.setServerType(serverType);
        lEvent.setComponentType(componentType);
        lEvent.setType(type);
        lEvent.setSeverity(severity);
        lEvent.setMessageCode(messageCode);
        lEvent.setMessageDetails(messageDetails);
        lEvent.setTimeStamp(new Date().getTime());
        lEvent.setOperationalState(opState);
        lEvent.setComponentName(componentName);
        lEvent.setServerName(serverName);
        try {
            this.forwardEvent(lEvent);
        }
        catch (MBeanException e) {
            mLogger.log(Level.FINEST, "forwarding event failed", e);
        }
    }

    private void fixEventPhysicalHostAttribute(Event aEvent) {
        if (aEvent == null) {
            return;
        }
        String lPhysicalHost = this.getHostAndPort();
        aEvent.setPhysicalHostName(lPhysicalHost);
    }

    private String getPhysicalHostName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        if (hostName == null) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e1) {
                mLogger.log(Level.FINEST, "unknow host failure", e1);
            }
        }
        if (hostName == null) {
            hostName = "127.0.0.1";
        }
        return hostName;
    }

    private void fixEventServerNameAttribute(Event aEvent) {
        if (aEvent == null) {
            return;
        }
        String serverName = this.mPlatformContext.getInstanceName();
        aEvent.setServerName(serverName);
    }

    private void testSendEvent(String message, Integer severity) {
        message = message == null ? "" : message;
        this.createAndForwordEvent(this.mPlatformContext.getInstanceName(), "INTEGRATION", "EventManagement", "Alert", severity, "CUSTOM-00001", message);
    }

    private void testSendEvents(String message, Boolean randomSeverity, Integer alertCount) {
        message = message == null ? "" : message;
        int severity = 5;
        int count = alertCount == null || alertCount < 1 ? 1 : alertCount;
        Random r = new Random(100000L);
        boolean randomizeSeverity = randomSeverity == null ? false : randomSeverity;
        for (int i = 0; i < count; ++i) {
            if (randomizeSeverity && (severity = r.nextInt() % 6) < 0) {
                severity = -severity;
            }
            this.testSendEvent(i + ": " + message, severity);
        }
    }

    private Long getPersistedEventsCount() {
        int count = this.mEventStore.getPersistedEventCount();
        return new Long(count);
    }

    private void addOperationsInfo() {
        this.mOperationsInfo.add(new MBeanOperationInfo("testSendEvent", "Send a test event via the EventForwarder", new MBeanParameterInfo[]{new MBeanParameterInfo("message", "java.lang.String", "the message assoc. with this test event"), new MBeanParameterInfo("severity", "java.lang.Integer", "the message assoc. with this test even (0-5)")}, "void", 1));
        this.mOperationsInfo.add(new MBeanOperationInfo("testSendEvents", "Send a test event via the EventForwarder", new MBeanParameterInfo[]{new MBeanParameterInfo("message", "java.lang.String", "the message assoc. with this test event"), new MBeanParameterInfo("randomSeverity", "java.lang.Boolean", "flag to indicate random severity should be applied to the test message"), new MBeanParameterInfo("alertCount", "java.lang.Integer", "Number of alerts to be sent")}, "void", 1));
        this.mOperationsInfo.add(new MBeanOperationInfo("getQueuedEvents", "get all events currently queued in the EventForwarder", null, "java.util.Collection", 1));
    }

    private void addAttributesInfo() {
        this.mAttributesInfo.add(new MBeanAttributeInfo("enableTargetPersistence", "java.lang.Boolean", "flag to indicate if the db persistence should be enabled or disabled. ", true, true, false));
        this.mAttributesInfo.add(new MBeanAttributeInfo("DBJndiName", "java.lang.String", "The JNDI name for the data source used when alert are persisted", true, true, false));
        this.mAttributesInfo.add(new MBeanAttributeInfo("DBType", "java.lang.String", "The database type used for persistence - need because saving event require diffrent statements base on database type", true, true, false));
        this.mAttributesInfo.add(new MBeanAttributeInfo("EMuniqueTableName", "java.lang.Integer", "Each domain in the enterprise has unique name from the alert it generated and persistedEnterprise monitor", true, true, false));
        this.mAttributesInfo.add(new MBeanAttributeInfo("PhysicalHostAndPort", "java.lang.String", "the Physical host name combined with the admin port for the DAS or http port for the instances", true, false, false));
    }

    private void initializeSetting() {
        if (this.mPersistedProps == null || this.mPersistedProps.size() == 0) {
            try {
                this.mAlertPersistenceConfiguration.setPersistenceEnabled(new Boolean(false));
            }
            catch (ManagementRemoteException e) {
                // empty catch block
            }
            this.mAlertPersistenceConfiguration.setPersistenceAlertPolicyExecInterval(DEFAULT_POLICY_EXEC_INTERVAL);
            this.mAlertPersistenceConfiguration.setPersistedAlertRemovalPolicyExecEnabled(new Boolean(false));
            this.mAlertPersistenceConfiguration.setPersistenceAlertLevelPolicyValue(AlertLevelType.NONE);
            this.mAlertPersistenceConfiguration.setPersistenceAlertAgePolicyValue(new Long(-1L));
            this.mAlertPersistenceConfiguration.setPersistenceAlertCountPolicyValue(new Long(-1L));
            this.mAlertPersistenceConfiguration.setAlertPersistenceDBType(AlertPersistenceDBType.DERBY);
            this.mAlertPersistenceConfiguration.setDataSourceJndiName("AlertPersistenceDB");
            this.mAlertPersistenceConfiguration.setAlertTableName(this.createTableName());
            Properties alertRemovalProps = this.mAlertPersistenceConfiguration.getPersistenceProperties();
            this.mPersistedProps.putAll((Map<?, ?>)alertRemovalProps);
            this.mEventForwardingHelper.saveProperties(this.mPersistedProps);
        } else {
            String propValue = this.mPersistedProps.getProperty("PersistenceEnabled");
            try {
                this.mAlertPersistenceConfiguration.setPersistenceEnabled(propValue == null ? new Boolean(false) : new Boolean(propValue));
                this.mPersisteanceeEnabled = this.mAlertPersistenceConfiguration.getPersistenceEnabled();
            }
            catch (ManagementRemoteException managementRemoteException) {
                // empty catch block
            }
            if (this.mPlatformContext.isAdminServer()) {
                propValue = this.mPersistedProps.getProperty("PersistencePolicyExecEnabled");
                this.mAlertPersistenceConfiguration.setPersistedAlertRemovalPolicyExecEnabled(propValue == null ? new Boolean(false) : new Boolean(propValue));
                propValue = this.mPersistedProps.getProperty("PersistencePolicyExecInterval");
                this.mAlertPersistenceConfiguration.setPersistenceAlertPolicyExecInterval(propValue == null ? DEFAULT_POLICY_EXEC_INTERVAL : new Long(propValue));
                propValue = this.mPersistedProps.getProperty("PersistenceAlertAge");
                this.mAlertPersistenceConfiguration.setPersistenceAlertAgePolicyValue(propValue == null ? new Long(-1L) : new Long(propValue));
                propValue = this.mPersistedProps.getProperty("PersistenceAlertCount");
                this.mAlertPersistenceConfiguration.setPersistenceAlertCountPolicyValue(propValue == null ? new Long(-1L) : new Long(propValue));
                propValue = this.mPersistedProps.getProperty("PersistenceAlertLevel");
                this.mAlertPersistenceConfiguration.setPersistenceAlertLevelPolicyValue(propValue == null ? AlertLevelType.NONE : AlertLevelType.valueOf(propValue));
            }
            this.mAlertPersistenceConfiguration.setDataSourceJndiName((propValue = this.mPersistedProps.getProperty("DBJndiName")) == null ? "" : propValue);
            this.mJNDIName = this.mAlertPersistenceConfiguration.getDataSourceJndiName();
            propValue = this.mPersistedProps.getProperty("DatabaseType");
            this.mAlertPersistenceConfiguration.setAlertPersistenceDBType(propValue == null ? AlertPersistenceDBType.DERBY : AlertPersistenceDBType.valueOf(propValue));
            this.mDBType = this.mAlertPersistenceConfiguration.getAlertPersistenceDBType();
            propValue = this.mPersistedProps.getProperty("AlertTableName");
            this.mAlertPersistenceConfiguration.setAlertTableName(propValue);
            this.mDomainUniqueAlertTableName = this.mAlertPersistenceConfiguration.getAlertTableName();
        }
    }

    private String updateIdentifierInformation() {
        InstanceIdentifier instnaceID = InstanceIdentifierFactory.getInstanceIdentifier(this.mPlatformContext);
        if (instnaceID == null) {
            return "";
        }
        return instnaceID.getInstanceUniquePort();
    }

    private String createTableName() {
        StringBuffer ltableName = new StringBuffer();
        String name = "EVENTMANAGEMENT" + this.getPhysicalHostName() + this.updateIdentifierInformation();
        char[] chr = name.toCharArray();
        for (int i = 0; i < chr.length; ++i) {
            if (chr[i] >= '0' && chr[i] <= '9') {
                ltableName.append(chr[i]);
                continue;
            }
            if ((chr[i] < 'A' || chr[i] > 'Z') && (chr[i] < 'a' || chr[i] > 'z')) continue;
            ltableName.append(chr[i]);
        }
        return ltableName.toString();
    }

    private String getHostAndPort() {
        InstanceIdentifier ii = InstanceIdentifierFactory.getInstanceIdentifier(this.mPlatformContext);
        StringBuffer buffer = new StringBuffer(this.getPhysicalHostName());
        buffer.append(":");
        if (this.mPlatformContext.isAdminServer()) {
            buffer.append(ii.getDomainAdminPort());
        } else {
            buffer.append(ii.getInstanceHttpPort());
        }
        this.mPhysicalHostAndPort = buffer.toString();
        return this.mPhysicalHostAndPort;
    }

    private class EventQueueHandler
    implements Runnable {
        private EventQueueHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (EventForwarderMBean.this.mEventsQueue.peek() != null) {
                Notification NotificationInstance = null;
                Object compositeData = null;
                if (EventForwarderMBean.this.mShutdownInProgress) {
                    EventForwarderMBean.this.mExecutorService.shutdown();
                    return;
                }
                try {
                    NotificationInstance = new Notification("JCAPSEvent", (Object)new ObjectName("EventManagement:name=EventForwarderMBean"), EventForwarderMBean.this.mNotificationSeqNum, System.currentTimeMillis());
                }
                catch (MalformedObjectNameException e) {
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                String notificationMsg = EventForwarderMBean.this.mPlatformContext.getInstanceName();
                NotificationInstance.setUserData(notificationMsg);
                EventForwarderMBean.this.sendNotification(NotificationInstance);
            }
            Object object = EventForwarderMBean.this.mSynchronizationObject;
            synchronized (object) {
                EventForwarderMBean.this.mExecutorActive = false;
            }
        }
    }
}

