/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.eventmanagement.impl;

import com.sun.esb.eventmanagement.api.AlertPersistenceDBType;
import com.sun.esb.eventmanagement.api.InstanceIdentifier;
import com.sun.esb.eventmanagement.impl.AlertLevelType;
import com.sun.esb.eventmanagement.impl.AlertPersistenceConfiguration;
import com.sun.esb.eventmanagement.impl.AlertRemovalPolicyType;
import com.sun.esb.eventmanagement.impl.AlertUtil;
import com.sun.esb.eventmanagement.impl.DBEventStore;
import com.sun.esb.eventmanagement.impl.EventForwardingHelper;
import com.sun.esb.eventmanagement.impl.EventManagementConstants;
import com.sun.esb.eventmanagement.impl.EventManagementTargetStateInfo;
import com.sun.esb.eventmanagement.impl.InstanceIdentifierFactory;
import com.sun.esb.eventmanagement.impl.InstanceNotificationListener;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.platform.PlatformContext;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.timer.Timer;

public final class EventManagementControllerMBean
extends NotificationBroadcasterSupport
implements DynamicMBean,
MBeanRegistration,
Serializable,
NotificationListener,
EventManagementConstants {
    private static final Logger mLogger = Logger.getLogger(EventManagementControllerMBean.class.getName());
    private static boolean isDebugEnabled = mLogger.isLoggable(Level.FINEST);
    ExecutorService mExecutorService;
    protected ArrayList<MBeanAttributeInfo> mAttributesInfo = new ArrayList();
    protected ArrayList<MBeanConstructorInfo> mConstructorsInfo = new ArrayList();
    protected ArrayList<MBeanOperationInfo> mOperationsInfo = new ArrayList();
    protected ArrayList<MBeanNotificationInfo> mNotificationsInfo = new ArrayList();
    protected MBeanInfo mMBeanInfo;
    private PlatformContext mPlatformContext;
    long mNotificationSeqNum;
    private MBeanServerConnection mMBeanServer;
    private Boolean mJournalEnabled = new Boolean(false);
    private Boolean mPersistenceEnabled = new Boolean(false);
    private List<String> mTargetInstanceList;
    private ObjectName mEventForwardObjcetName;
    private ObjectName mChannelSupportObjectName;
    private ObjectName mMBeanServerNotificationObjectName;
    private String mJBIinstanceRoot;
    private EventForwardingHelper mEventForwardingHelper;
    private AlertPersistenceConfiguration mAlertPersistenceConfiguration;
    private Properties mPersistedProps;
    private transient DBEventStore mEventStore;
    private String mHostName;
    private String mDasUniquePort;
    private Timer mTargetCheckTimer;
    private ObjectName mTargetCheckTimerObjectName;
    private Integer mTimerNotificationId;
    private Long mTargetCheckInterval = DEFAULT_TARGET_CHECK_INTERVAL;
    private NotificationFilterSupport mTargetCheckTimerFilter;
    private Map<String, EventManagementTargetStateInfo> mCurrentTargetStateMap;
    private EnvironmentContext mContext;

    public EventManagementControllerMBean(EnvironmentContext context) throws Exception {
        this.buildDynamicMBeanInfo();
        this.mContext = context;
        this.mCurrentTargetStateMap = new HashMap<String, EventManagementTargetStateInfo>();
        this.mTargetCheckTimerFilter = new NotificationFilterSupport();
        this.mJBIinstanceRoot = context.getJbiInstanceRoot() + "/config";
        this.mExecutorService = Executors.newCachedThreadPool();
        this.mPlatformContext = context.getPlatformContext();
        this.mMBeanServer = this.mPlatformContext.getMBeanServer();
        this.mTargetInstanceList = new ArrayList<String>();
        this.mTargetInstanceList.addAll(this.mPlatformContext.getStandaloneServerNames());
        this.mTargetInstanceList.addAll(this.mPlatformContext.getClusteredServerNames());
        this.mEventForwardObjcetName = new ObjectName("EventManagement:name=EventForwarderMBean");
        this.mChannelSupportObjectName = new ObjectName("EventManagement:name=EventManagementChannelSupportMBean");
        this.mMBeanServerNotificationObjectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        this.mEventForwardingHelper = new EventForwardingHelper(this.mJBIinstanceRoot);
        this.mAlertPersistenceConfiguration = AlertPersistenceConfiguration.getInstance(this.mMBeanServer);
        this.mAlertPersistenceConfiguration.setAdminServer(this.mPlatformContext.isAdminServer());
        this.mPersistedProps = this.mEventForwardingHelper.GetProperties();
        this.mHostName = this.getPhysicalHostName();
        this.initializeSetting();
        this.mEventStore = DBEventStore.getInstance(this.mAlertPersistenceConfiguration, this.mMBeanServer, this.mPlatformContext);
        this.mAlertPersistenceConfiguration.setDBEventStore(this.mEventStore);
        if (this.mAlertPersistenceConfiguration.getPersistenceEnabled().booleanValue()) {
            try {
                this.mEventStore.initializeDataSource();
            }
            catch (ManagementRemoteException e) {
                mLogger.log(Level.WARNING, AlertUtil.getPackageBundle().getMessage("caps.management.server.alert.persistence.setup.error.log.msg"), e);
            }
        }
        this.mAlertPersistenceConfiguration.setAdminServer(true);
        this.mMBeanServer.addNotificationListener(this.mMBeanServerNotificationObjectName, this, null, new Object());
        this.registerTargetCheckTimer();
    }

    protected void buildDynamicMBeanInfo() {
        this.mConstructorsInfo.add(new MBeanConstructorInfo("EventManagementControllerMBean Constructor", this.getClass().getConstructors()[0]));
        this.addOperationsInfo();
        this.addAttributesInfo();
        this.mMBeanInfo = new MBeanInfo(this.getClass().getName(), "Event Management DynamicMBean", this.mAttributesInfo.toArray(new MBeanAttributeInfo[this.mAttributesInfo.size()]), this.mConstructorsInfo.toArray(new MBeanConstructorInfo[this.mConstructorsInfo.size()]), this.mOperationsInfo.toArray(new MBeanOperationInfo[this.mOperationsInfo.size()]), this.mNotificationsInfo.toArray(new MBeanNotificationInfo[this.mNotificationsInfo.size()]));
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Object result = "OK";
        if (operationName.equalsIgnoreCase("getHttpServerInfo")) {
            result = this.getHttpServerInfo();
        } else if (operationName.equals("getDasAdminServerInfo")) {
            result = this.getDasAdminServerInfo();
        } else if (operationName.equals("updatePersistedAlertRemovalPolicy")) {
            this.updateAlertsRemovalPolicy(params);
        } else if (operationName.equals("getLastPersistedAlertRemovalPolicy")) {
            result = this.getcurrentRemovlPolicy();
        } else if (operationName.equals("enableAlertsPersistence")) {
            result = this.executePersistenceOpeartion(true, params);
        } else if (operationName.equals("disableAlertsPersistence")) {
            result = this.executePersistenceOpeartion(false, params);
        } else if (operationName.equalsIgnoreCase("acknowledgeAlertReception")) {
            String masteruuid = (String)params[0];
            String eventId = (String)params[1];
            this.AlertReceptionAcknowledged(eventId);
        }
        return result;
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() {
        this.unRegisterTimerService();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        return name;
    }

    private void addOperationsInfo() {
        this.mOperationsInfo.add(new MBeanOperationInfo("updatePersistedAlertRemovalPolicy", "update the policy used to remove persisted alerts", new MBeanParameterInfo[]{new MBeanParameterInfo("params", "[Ljava.lang.Object", "array of String representing the new Policy")}, "void", 1));
        this.mOperationsInfo.add(new MBeanOperationInfo("getLastPersistedAlertRemovalPolicy", "get the last policy setting used to remove persisted alerts", null, "[Ljava.lang.String", 1));
        this.mOperationsInfo.add(new MBeanOperationInfo("getHttpServerInfo", "get this physical host name and http port number", null, "String", 1));
        this.mOperationsInfo.add(new MBeanOperationInfo("getDasAdminServerInfo", "get this physical host name and http admin port number", null, "String", 1));
        this.mOperationsInfo.add(new MBeanOperationInfo("enableAlertsPersistence", "enable events peristence with the option not removing them", new MBeanParameterInfo[]{new MBeanParameterInfo("enableJournal", "java.lang.Boolean", "Flag to indicate alerts are journaled or not")}, "void", 1));
        this.mOperationsInfo.add(new MBeanOperationInfo("disableAlertsPersistence", "disable events peristence ", null, "void", 1));
        this.mOperationsInfo.add(new MBeanOperationInfo("acknowledgeAlertReception", "delete the alert that was acknowledge by the client", new MBeanParameterInfo[]{new MBeanParameterInfo("UUID", "java.lang.String", "Unique ID for the delivery channel provide by the connected client"), new MBeanParameterInfo("dbAlertID", "java.lang.String", "Unique ID that identify the alert to be removed from persistence")}, "void", 1));
    }

    private void addAttributesInfo() {
        this.mAttributesInfo.add(new MBeanAttributeInfo("enableTargetPersistence", "java.lang.Boolean", "flag to indicate if the db persistence should be enabled or disabled. ", true, true, false));
        this.mAttributesInfo.add(new MBeanAttributeInfo("enablePolicyExcution", "java.lang.Boolean", "flag to indicate if the persisted alert removal polciy should be enforced or not. ", true, true, false));
        this.mAttributesInfo.add(new MBeanAttributeInfo("persistedAlertsRemovalPolicyExecInterval", "java.lang.Long", "indicate the interval (in milliseconds) of alert in the db  will be be subject to removal", true, true, false));
        this.mAttributesInfo.add(new MBeanAttributeInfo("persistedAlertMaxAge", "java.lang.Long", "indicate the max age (in milliseconds) of alert in the db that will be be subject to removal", true, true, false));
        this.mAttributesInfo.add(new MBeanAttributeInfo("persistedAlertMaxCount", "java.lang.Long", "indicate the max count of alerts alllowed to persisted in the db", true, true, false));
        this.mAttributesInfo.add(new MBeanAttributeInfo("persistedAlertLevel", "com.stc.eventmanagement.imp.Alert", "indicate the max level of alerts the are subject to removel from the db", true, true, false));
        this.mAttributesInfo.add(new MBeanAttributeInfo("CurrentPersistedEventsCount", "java.lang.Integer", "The current number of persisted alert/events waiting to be forwarded to Enterprise monitor", true, false, false));
        this.mAttributesInfo.add(new MBeanAttributeInfo("DBJndiName", "java.lang.String", "The JNDI name for the data source used when alert are persisted", true, true, false));
        this.mAttributesInfo.add(new MBeanAttributeInfo("EMuniqueTableName", "java.lang.Integer", "Each domain in the enterprise has unique name from the alert it generated and persistedEnterprise monitor", true, false, false));
        this.mAttributesInfo.add(new MBeanAttributeInfo("tergetCheckInterval", "java.lang.Long", "The interval used to query the current targets list in order to register the control mbean for notification", true, true, false));
        this.mAttributesInfo.add(new MBeanAttributeInfo("isSecureAdminPort", "java.lang.Long", "return true if secure http admin port is used", true, false, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String aName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (aName.equals("enableTargetPersistence") || aName.equals("alertsPersistenceEnabled")) {
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                return this.mAlertPersistenceConfiguration.getPersistenceEnabled();
            }
        }
        if (aName.equals("alertsJournalEnabled")) {
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                return this.mAlertPersistenceConfiguration.isJournalEnabled();
            }
        }
        if (aName.equals("enablePolicyExcution")) {
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                return this.mAlertPersistenceConfiguration.getPersistedAlertRemovalPolicyExecEnabled();
            }
        }
        if (aName.equals("persistedAlertMaxAge")) {
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                return this.mAlertPersistenceConfiguration.getPersistenceAlertAgePolicyValue();
            }
        }
        if (aName.equals("persistedAlertMaxCount")) {
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                return this.mAlertPersistenceConfiguration.getPersistenceAlertCountPolicyValue();
            }
        }
        if (aName.equals("persistedAlertLevel")) {
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                return this.mAlertPersistenceConfiguration.getPersistenceAlertLevelPolicyValue().getAlertLevel();
            }
        }
        if (aName.equals("persistedAlertsRemovalPolicyExecInterval")) {
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                return this.mAlertPersistenceConfiguration.getPersistenceAlertPolicyExecInterval();
            }
        }
        if (aName.equals("CurrentPersistedEventsCount")) {
            return this.mEventStore.getPersistedEventCount();
        }
        if (aName.equals("DBJndiName")) {
            return this.mAlertPersistenceConfiguration.getDataSourceJndiName();
        }
        if (aName.equals("DBType")) {
            return this.mAlertPersistenceConfiguration.getAlertPersistenceDBType().getDatabasetype();
        }
        if (aName.equals("JBIInstallRoot")) {
            return this.mJBIinstanceRoot;
        }
        if (aName.equals("EMuniqueTableName")) {
            return this.mAlertPersistenceConfiguration.getAlertTableName();
        }
        if (aName.equals("alertTableName")) {
            return this.mAlertPersistenceConfiguration.getAlertTableName();
        }
        if (aName.equals("tergetCheckInterval")) {
            return this.mTargetCheckInterval;
        }
        if (aName.equals("isSecureAdminPort")) {
            return this.isSecureAdminPort();
        }
        throw new AttributeNotFoundException();
    }

    public AttributeList getAttributes(String[] aNames) {
        AttributeList attributes = new AttributeList(aNames.length);
        for (int i = 0; i < aNames.length; ++i) {
            try {
                attributes.add(new Attribute(aNames[i], this.getAttribute(aNames[i])));
                continue;
            }
            catch (Exception e) {
                if (!mLogger.isLoggable(Level.FINE)) continue;
                mLogger.fine(">>>>EventForwarderMBean :: Unable to add attribute " + aNames[i] + " " + e);
            }
        }
        return attributes;
    }

    public MBeanInfo getMBeanInfo() {
        return this.mMBeanInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(Attribute aAttribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (aAttribute.getName().equals("enablePolicyExcution")) {
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                this.mAlertPersistenceConfiguration.setPersistedAlertRemovalPolicyExecEnabled((Boolean)aAttribute.getValue());
            }
        }
        if (aAttribute.getName().equals("persistedAlertMaxAge")) {
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                this.mAlertPersistenceConfiguration.setPersistenceAlertAgePolicyValue((Long)aAttribute.getValue());
            }
        }
        if (aAttribute.getName().equals("persistedAlertMaxCount")) {
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                this.mAlertPersistenceConfiguration.setPersistenceAlertCountPolicyValue((Long)aAttribute.getValue());
            }
        }
        if (aAttribute.getName().equals("persistedAlertLevel")) {
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                this.mAlertPersistenceConfiguration.setPersistenceAlertLevelPolicyValue(AlertLevelType.valueOf((String)aAttribute.getValue()));
            }
        }
        if (aAttribute.getName().equals("persistedAlertsRemovalPolicyExecInterval")) {
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                this.mAlertPersistenceConfiguration.setPersistenceAlertPolicyExecInterval((Long)aAttribute.getValue());
            }
        }
        if (aAttribute.getName().equals("DBJndiName")) {
            String newJndiName = (String)aAttribute.getValue();
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                this.mAlertPersistenceConfiguration.setDataSourceJndiName(newJndiName);
            }
            this.propogateAttributeValueToAllTargets("DBJndiName", newJndiName);
            this.propogateAttributeValueToChannelSuportBean("DBJndiName", newJndiName);
        } else if (aAttribute.getName().equals("DBType")) {
            String dbType = (String)aAttribute.getValue();
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                this.mAlertPersistenceConfiguration.setAlertPersistenceDBType(AlertPersistenceDBType.valueOf(dbType));
            }
            this.propogateAttributeValueToAllTargets("DBType", dbType);
            this.propogateAttributeValueToChannelSuportBean("DBType", dbType);
        } else if (aAttribute.getName().equals("alertTableName")) {
            String tableName = (String)aAttribute.getValue();
            AlertPersistenceConfiguration alertPersistenceConfiguration = this.mAlertPersistenceConfiguration;
            synchronized (alertPersistenceConfiguration) {
                this.mAlertPersistenceConfiguration.setAlertTableName(tableName);
            }
            this.propogateAttributeValueToAllTargets("alertTableName", tableName);
            this.propogateAttributeValueToChannelSuportBean("alertTableName", tableName);
        } else if (aAttribute.getName().equals("tergetCheckInterval")) {
            this.mTargetCheckInterval = (Long)aAttribute.getValue();
            this.mTargetCheckTimer.stop();
            this.unHookFromTimerService();
            this.hookUpToTimerService(this.mTargetCheckInterval);
            this.mTargetCheckTimer.start();
        }
        this.updatePersistedProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object handback) {
        String notificationType = notification.getType();
        if (notificationType.equals("JCAPSEvent")) {
            if (this.mPersistenceEnabled.booleanValue() || this.mJournalEnabled.booleanValue()) {
                return;
            }
            String instanceName = (String)notification.getUserData();
            EventManagementControllerMBean eventManagementControllerMBean = this;
            synchronized (eventManagementControllerMBean) {
                this.forwardJMXNotificationToDeliveryChannel(instanceName);
            }
        } else if (notificationType.equals("JMX.mbean.registered")) {
            MBeanServerNotification nbsn = (MBeanServerNotification)notification;
            ObjectName regMBean = nbsn.getMBeanName();
            if (regMBean.getKeyPropertyList().contains("instance")) {
                this.updateNewInstance(regMBean.getKeyProperty("instance"));
            } else if (regMBean.equals(this.mEventForwardObjcetName)) {
                try {
                    this.mMBeanServer.addNotificationListener(this.mEventForwardObjcetName, this, null, new Object());
                }
                catch (Exception e) {}
            }
        } else if (notificationType.equals("eventManagement.instanceCheck")) {
            this.mTargetCheckTimer.stop();
            this.updateTargetsIfNeeded();
            this.mTargetCheckTimer.start();
        }
    }

    private void updateNewInstance(String newInstanceName) {
        if (this.mTargetInstanceList.contains(newInstanceName)) {
            return;
        }
        this.mTargetInstanceList.add(newInstanceName);
        try {
            MBeanServerConnection mBeanServer = this.mPlatformContext.getMBeanServerConnection(newInstanceName);
            if (mBeanServer == null) {
                return;
            }
            this.RegisterWithTarget(newInstanceName);
            Attribute dbAttribute = new Attribute("DBJndiName", this.mAlertPersistenceConfiguration.getDataSourceJndiName());
            mBeanServer.setAttribute(this.mEventForwardObjcetName, dbAttribute);
            dbAttribute = new Attribute("DBType", (Object)this.mAlertPersistenceConfiguration.getAlertPersistenceDBType());
            mBeanServer.setAttribute(this.mEventForwardObjcetName, dbAttribute);
            Attribute enableAttribute = new Attribute("enableTargetPersistence", this.mPersistenceEnabled);
            mBeanServer.setAttribute(this.mEventForwardObjcetName, enableAttribute);
        }
        catch (InstanceNotFoundException e) {
            mLogger.log(Level.FINEST, "Instance Not Found Exception ", e);
        }
        catch (AttributeNotFoundException e) {
            mLogger.log(Level.FINEST, "Attribute Not Found Exception ", e);
        }
        catch (InvalidAttributeValueException e) {
            mLogger.log(Level.FINEST, "Invalid Attribute value ", e);
        }
        catch (MBeanException e) {
            mLogger.log(Level.FINEST, "MBean Exception ", e);
        }
        catch (ReflectionException e) {
            mLogger.log(Level.FINEST, "Reflection Exception ", e);
        }
        catch (IOException e) {
            mLogger.log(Level.FINEST, "IO Exception ", e);
        }
        catch (Exception e) {
            mLogger.log(Level.FINEST, "Exception ", e);
        }
    }

    private void AlertReceptionAcknowledged(String aEventId) throws MBeanException {
        if (!this.mJournalEnabled.booleanValue()) {
            try {
                this.mEventStore.deleteEvent(aEventId);
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
        }
    }

    public void forwardJMXNotificationToDeliveryChannel(String aInstanceName) {
        try {
            Collection eventsData = null;
            MBeanServerConnection instancemBeanServer = this.mPlatformContext.getMBeanServerConnection(aInstanceName);
            eventsData = (Collection)instancemBeanServer.invoke(this.mEventForwardObjcetName, "getQueuedEvents", null, null);
            for (CompositeData data : eventsData) {
                if (!this.mMBeanServer.isRegistered(this.mChannelSupportObjectName)) continue;
                Object[] params = new Object[]{data};
                String[] signature = new String[]{"javax.management.openmbean.CompositeData"};
                this.mMBeanServer.invoke(this.mChannelSupportObjectName, "forwardEvent", params, signature);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void RegisterForNotificationFromExistingTargets() {
        Set<String> instnaceNames = this.mPlatformContext.getStandaloneServerNames();
        instnaceNames.addAll(this.mPlatformContext.getClusteredServerNames());
        for (String instanceName : instnaceNames) {
            try {
                this.RegisterWithTarget(instanceName);
            }
            catch (MBeanException e) {
                mLogger.log(Level.FINEST, "MBean Exception ", e);
            }
        }
    }

    public AttributeList setAttributes(AttributeList aAttributes) {
        for (Attribute attribute : aAttributes) {
            try {
                this.setAttribute(attribute);
            }
            catch (Exception e) {}
        }
        return aAttributes;
    }

    private Object executePersistenceOpeartion(boolean enable, Object[] params) throws MBeanException, ReflectionException {
        Object result = "OK";
        if (enable) {
            this.updateIdentifierInformation();
            this.mAlertPersistenceConfiguration.setAlertTableName(this.createTableName());
            try {
                this.mAlertPersistenceConfiguration.setPersistenceEnabled(true);
            }
            catch (ManagementRemoteException e) {
                Exception exp = AlertUtil.createManagementException("caps.management.server.alert.enable.persistence.error", null, e);
                throw new MBeanException(exp);
            }
            this.mJournalEnabled = (Boolean)params[0];
            this.mAlertPersistenceConfiguration.setJournalEnabled(this.mJournalEnabled);
            this.updatePersistedProperties();
            this.mPersistenceEnabled = new Boolean(true);
            result = this.enablePersistanceOnAllTargets();
        } else {
            this.mJournalEnabled = new Boolean(false);
            this.mPersistenceEnabled = new Boolean(false);
            try {
                this.mAlertPersistenceConfiguration.setPersistenceEnabled(false);
            }
            catch (ManagementRemoteException e) {
                throw new MBeanException(e);
            }
            this.updatePersistedProperties();
            result = this.disablePersistanceOnAllTargets();
        }
        this.propogateAttributeValueToChannelSuportBean("alertsJournalEnabled", this.mJournalEnabled);
        this.propogateAttributeValueToChannelSuportBean("enableTargetPersistence", this.mPersistenceEnabled);
        return result;
    }

    private Object enablePersistanceOnAllTargets() throws MBeanException {
        Set<String> allServers = this.mPlatformContext.getStandaloneServerNames();
        allServers.addAll(this.mPlatformContext.getClusteredServerNames());
        for (String server : allServers) {
            if (!this.mPlatformContext.isInstanceUp(server)) continue;
            this.enablePersistanceOnTarget(server);
        }
        String result = "OK";
        return result;
    }

    private void enablePersistanceOnTarget(String server) throws MBeanException {
        try {
            MBeanServerConnection mBeanServer = this.mPlatformContext.getMBeanServerConnection(server);
            if (mBeanServer == null) {
                return;
            }
            this.propogateAttributeValueToTarget(server, "DBType", this.mAlertPersistenceConfiguration.getAlertPersistenceDBType().getDatabasetype());
            this.propogateAttributeValueToTarget(server, "DBJndiName", this.mAlertPersistenceConfiguration.getDataSourceJndiName());
            this.propogateAttributeValueToTarget(server, "alertTableName", this.mAlertPersistenceConfiguration.getAlertTableName());
            Attribute lAttribute = new Attribute("enableTargetPersistence", new Boolean(true));
            mBeanServer.setAttribute(this.mEventForwardObjcetName, lAttribute);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    private Object disablePersistanceOnAllTargets() throws MBeanException {
        Set<String> allServers = this.mPlatformContext.getStandaloneServerNames();
        allServers.addAll(this.mPlatformContext.getClusteredServerNames());
        for (String server : allServers) {
            if (!this.mPlatformContext.isInstanceUp(server)) continue;
            this.disablePersistanceOnTarget(server);
        }
        String result = "OK";
        return result;
    }

    private void disablePersistanceOnTarget(String server) throws MBeanException {
        try {
            MBeanServerConnection mBeanServer = this.mPlatformContext.getMBeanServerConnection(server);
            if (mBeanServer == null) {
                return;
            }
            Attribute lAttribute = new Attribute("enableTargetPersistence", new Boolean(false));
            mBeanServer.setAttribute(this.mEventForwardObjcetName, lAttribute);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    private void propogateAttributeValueToAllTargets(String attributeName, String attributeVale) {
        Set<String> allServers = this.mPlatformContext.getStandaloneServerNames();
        allServers.addAll(this.mPlatformContext.getClusteredServerNames());
        for (String server : allServers) {
            this.propogateAttributeValueToTarget(server, attributeName, attributeVale);
        }
    }

    private void propogateAttributeValueToTarget(String server, String attributeName, String attributeVale) {
        try {
            MBeanServerConnection mBeanServer = this.mPlatformContext.getMBeanServerConnection(server);
            if (mBeanServer == null) {
                return;
            }
            Attribute lAttribute = new Attribute(attributeName, attributeVale);
            mBeanServer.setAttribute(this.mEventForwardObjcetName, lAttribute);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void propogateAttributeValueToChannelSuportBean(String attributeName, Object attributeVale) {
        try {
            if (this.mMBeanServer.isRegistered(this.mChannelSupportObjectName)) {
                Attribute lAttribute = new Attribute(attributeName, attributeVale);
                this.mMBeanServer.setAttribute(this.mChannelSupportObjectName, lAttribute);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateAlertsRemovalPolicy(Object[] params) {
        List policyElementsList = (List)params[0];
        this.mAlertPersistenceConfiguration.setAlertRemovalPolicyTypeList(policyElementsList);
    }

    private String[] getcurrentRemovlPolicy() {
        List<AlertRemovalPolicyType> list = this.mAlertPersistenceConfiguration.getAlertRemovalPolicyTypeList();
        String[] policyElementsArray = new String[list.size()];
        for (int index = 0; index < list.size(); ++index) {
            AlertRemovalPolicyType alertRemovalPolicyType = list.get(index);
            policyElementsArray[index] = alertRemovalPolicyType.getPolicyType();
        }
        return policyElementsArray;
    }

    private String getHttpServerInfo() {
        StringBuffer buffer = new StringBuffer(this.getPhysicalHostName());
        InstanceIdentifier ii = InstanceIdentifierFactory.getInstanceIdentifier(this.mPlatformContext);
        buffer.append(":");
        buffer.append(ii.getHttpPort());
        return buffer.toString();
    }

    private String getDasAdminServerInfo() {
        StringBuffer buffer = new StringBuffer(this.getPhysicalHostName());
        InstanceIdentifier ii = InstanceIdentifierFactory.getInstanceIdentifier(this.mPlatformContext);
        buffer.append(":");
        buffer.append(ii.getDomainAdminPort());
        return buffer.toString();
    }

    private Boolean isSecureAdminPort() {
        InstanceIdentifier ii = InstanceIdentifierFactory.getInstanceIdentifier(this.mPlatformContext);
        return ii.isSecureAdminPort();
    }

    private String getPhysicalHostName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        if (hostName == null) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (hostName == null) {
            hostName = "127.0.0.1";
        }
        return hostName;
    }

    private void RegisterWithTarget(String instanceName) throws MBeanException {
        Object handback = new Object();
        try {
            MBeanServerConnection instanceConnection = this.mPlatformContext.getMBeanServerConnection(instanceName);
            InstanceNotificationListener inl = new InstanceNotificationListener(this);
            instanceConnection.addNotificationListener(this.mEventForwardObjcetName, inl, null, handback);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    private void initializeSetting() {
        if (this.mPersistedProps == null || this.mPersistedProps.size() == 0) {
            try {
                this.mAlertPersistenceConfiguration.setPersistenceEnabled(new Boolean(false));
            }
            catch (ManagementRemoteException e) {
                // empty catch block
            }
            this.mAlertPersistenceConfiguration.setJournalEnabled(this.mJournalEnabled);
            this.mAlertPersistenceConfiguration.setPersistenceAlertPolicyExecInterval(DEFAULT_POLICY_EXEC_INTERVAL);
            this.mAlertPersistenceConfiguration.setPersistedAlertRemovalPolicyExecEnabled(new Boolean(false));
            this.mAlertPersistenceConfiguration.setPersistenceAlertLevelPolicyValue(AlertLevelType.NONE);
            this.mAlertPersistenceConfiguration.setPersistenceAlertAgePolicyValue(new Long(-1L));
            this.mAlertPersistenceConfiguration.setPersistenceAlertCountPolicyValue(new Long(-1L));
            this.mAlertPersistenceConfiguration.setAlertPersistenceDBType(AlertPersistenceDBType.DERBY);
            this.mAlertPersistenceConfiguration.setDataSourceJndiName("AlertPersistenceDB");
            this.mAlertPersistenceConfiguration.setAlertTableName(this.createTableName());
            Properties alertRemovalProps = this.mAlertPersistenceConfiguration.getPersistenceProperties();
            this.mPersistedProps.putAll((Map<?, ?>)alertRemovalProps);
            this.mEventForwardingHelper.saveProperties(this.mPersistedProps);
        } else {
            String propValue = this.mPersistedProps.getProperty("journalEnabled");
            this.mAlertPersistenceConfiguration.setJournalEnabled(propValue == null ? new Boolean(false) : new Boolean(propValue));
            propValue = this.mPersistedProps.getProperty("PersistencePolicyExecEnabled");
            this.mAlertPersistenceConfiguration.setPersistedAlertRemovalPolicyExecEnabled(propValue == null ? new Boolean(false) : new Boolean(propValue));
            propValue = this.mPersistedProps.getProperty("PersistencePolicyExecInterval");
            this.mAlertPersistenceConfiguration.setPersistenceAlertPolicyExecInterval(propValue == null ? DEFAULT_POLICY_EXEC_INTERVAL : new Long(propValue));
            propValue = this.mPersistedProps.getProperty("PersistenceAlertAge");
            this.mAlertPersistenceConfiguration.setPersistenceAlertAgePolicyValue(propValue == null ? new Long(-1L) : new Long(propValue));
            propValue = this.mPersistedProps.getProperty("PersistenceAlertCount");
            this.mAlertPersistenceConfiguration.setPersistenceAlertCountPolicyValue(propValue == null ? new Long(-1L) : new Long(propValue));
            propValue = this.mPersistedProps.getProperty("PersistenceAlertLevel");
            this.mAlertPersistenceConfiguration.setPersistenceAlertLevelPolicyValue(propValue == null ? AlertLevelType.NONE : AlertLevelType.valueOf(propValue));
            propValue = this.mPersistedProps.getProperty("DBJndiName");
            this.mAlertPersistenceConfiguration.setDataSourceJndiName(propValue == null ? "" : propValue);
            propValue = this.mPersistedProps.getProperty("DatabaseType");
            this.mAlertPersistenceConfiguration.setAlertPersistenceDBType(propValue == null ? AlertPersistenceDBType.DERBY : AlertPersistenceDBType.valueOf(propValue));
            propValue = this.mPersistedProps.getProperty("AlertTableName");
            this.mAlertPersistenceConfiguration.setAlertTableName(propValue == null ? this.createTableName() : propValue);
            propValue = this.mPersistedProps.getProperty("PersistenceEnabled");
            try {
                this.mAlertPersistenceConfiguration.setPersistenceEnabled(propValue == null ? new Boolean(false) : new Boolean(propValue));
            }
            catch (ManagementRemoteException managementRemoteException) {
                // empty catch block
            }
        }
    }

    private void updateIdentifierInformation() {
        InstanceIdentifier instnaceID = InstanceIdentifierFactory.getInstanceIdentifier(this.mPlatformContext);
        this.mDasUniquePort = instnaceID == null ? "" : instnaceID.getInstanceUniquePort();
    }

    private String createTableName() {
        StringBuffer ltableName = new StringBuffer();
        String name = "EVENTMANAGEMENT" + this.mHostName + this.mDasUniquePort;
        char[] chr = name.toCharArray();
        for (int i = 0; i < chr.length; ++i) {
            if (chr[i] >= '0' && chr[i] <= '9') {
                ltableName.append(chr[i]);
                continue;
            }
            if ((chr[i] < 'A' || chr[i] > 'Z') && (chr[i] < 'a' || chr[i] > 'z')) continue;
            ltableName.append(chr[i]);
        }
        return ltableName.toString();
    }

    private void updatePersistedProperties() {
        Properties alertRemovalProps = this.mAlertPersistenceConfiguration.getPersistenceProperties();
        this.mPersistedProps.putAll((Map<?, ?>)alertRemovalProps);
        this.mEventForwardingHelper.saveProperties(this.mPersistedProps);
    }

    private void registerTargetCheckTimer() {
        try {
            this.mTargetCheckTimer = new Timer();
            this.mTargetCheckTimerObjectName = new ObjectName("EventManagement:type=service,name=TargetCheckIntervalTimerService");
            ((MBeanServer)this.mMBeanServer).registerMBean(this.mTargetCheckTimer, this.mTargetCheckTimerObjectName);
            this.hookUpToTimerService(this.mTargetCheckInterval);
            this.mTargetCheckTimer.start();
        }
        catch (Exception e) {
            String bundleKey = "caps.management.server.alert.instance.check.timer.setup.error.log.msg";
            String message = AlertUtil.constructLogMessage(bundleKey);
            mLogger.log(Level.WARNING, message, e);
        }
    }

    public void unRegisterTimerService() {
        this.mTargetCheckTimer.stop();
        this.unHookFromTimerService();
        try {
            if (this.mMBeanServer.isRegistered(this.mTargetCheckTimerObjectName)) {
                this.mMBeanServer.unregisterMBean(this.mTargetCheckTimerObjectName);
            }
        }
        catch (Exception e) {
            String bundleKey = "caps.management.server.alert.instance.check.timer.shutdown.error.log.msg";
            String message = AlertUtil.constructLogMessage(bundleKey);
            mLogger.log(Level.WARNING, message, e);
        }
    }

    private void hookUpToTimerService(Long aTimeIntervalForTargetCheck) {
        try {
            this.mTargetCheckTimerFilter.enableType("eventManagement.instanceCheck");
            this.mMBeanServer.addNotificationListener(this.mTargetCheckTimerObjectName, this, (NotificationFilter)this.mTargetCheckTimerFilter, null);
            Object[] paramsArray = new Object[]{"eventManagement.instanceCheck", "instance check interval", null, new Date(), (long)aTimeIntervalForTargetCheck};
            String[] paramsSig = new String[]{"java.lang.String", "java.lang.String", "java.lang.Object", "java.util.Date", "long"};
            this.mTimerNotificationId = (Integer)this.mMBeanServer.invoke(this.mTargetCheckTimerObjectName, "addNotification", paramsArray, paramsSig);
        }
        catch (Exception ex) {
            String bundleKey = "caps.management.server.alert.instance.check.timer.hook.error.msg";
            String message = AlertUtil.constructLogMessage(bundleKey);
            mLogger.log(Level.WARNING, message, ex);
        }
    }

    private void unHookFromTimerService() {
        try {
            if (this.mMBeanServer.isRegistered(this.mTargetCheckTimerObjectName)) {
                this.mMBeanServer.removeNotificationListener(this.mTargetCheckTimerObjectName, this);
                if (this.mTimerNotificationId != null) {
                    Object[] paramsArray = new Object[]{this.mTimerNotificationId};
                    String[] paramsSig = new String[]{"java.lang.Integer"};
                    this.mMBeanServer.invoke(this.mTargetCheckTimerObjectName, "removeNotification", paramsArray, paramsSig);
                }
            }
        }
        catch (Exception e) {
            String bundleKey = "caps.management.server.alert.instance.check.timer.unhook.error.msg";
            String message = AlertUtil.constructLogMessage(bundleKey);
            mLogger.log(Level.WARNING, message, e.getMessage());
        }
    }

    private void updateTargetsIfNeeded() {
        ArrayList<String> currentRegisteredTargets = new ArrayList<String>(this.mCurrentTargetStateMap.keySet());
        ArrayList<String> removeTargetsCandidates = new ArrayList<String>();
        for (String currentTarget : currentRegisteredTargets) {
            removeTargetsCandidates.add(currentTarget);
        }
        Set<String> allTargets = this.mPlatformContext.getStandaloneServerNames();
        allTargets.addAll(this.mPlatformContext.getClusteredServerNames());
        for (String target : allTargets) {
            EventManagementTargetStateInfo tsi;
            boolean registered = false;
            boolean isUp = this.mPlatformContext.isInstanceUp(target);
            if (!this.mCurrentTargetStateMap.containsKey(target)) {
                tsi = new EventManagementTargetStateInfo(target, isUp, false);
                this.mCurrentTargetStateMap.put(target, tsi);
                if (!isUp) continue;
                registered = this.updateTarget(target);
                tsi.setHasNotificationRegisteration(registered);
                continue;
            }
            removeTargetsCandidates.remove(target);
            tsi = this.mCurrentTargetStateMap.get(target);
            tsi.setIsUp(isUp);
            if (!isUp) continue;
            if (!tsi.isLastStateUp() && tsi.isUp()) {
                registered = this.updateTarget(target);
                tsi.setHasNotificationRegisteration(registered);
                continue;
            }
            if (tsi.hasNotificationRegisteration()) continue;
            registered = this.updateTarget(target);
            tsi.setHasNotificationRegisteration(registered);
        }
        for (String target : removeTargetsCandidates) {
            this.mCurrentTargetStateMap.remove(target);
        }
    }

    private boolean updateTarget(String target) {
        boolean registered = false;
        if (this.mPersistenceEnabled.booleanValue()) {
            try {
                this.enablePersistanceOnTarget(target);
            }
            catch (MBeanException e) {
                // empty catch block
            }
        }
        try {
            this.RegisterWithTarget(target);
            registered = true;
            String bundleKey = "caps.management.server.alert.addlistener";
            String message = AlertUtil.constructMessage(bundleKey, new String[]{target});
            mLogger.log(Level.FINE, message);
        }
        catch (MBeanException e) {
            registered = false;
        }
        return registered;
    }
}

