/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.eventmanagement.impl;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.HTTPListenerConfig;
import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.esb.eventmanagement.api.InstanceIdentifier;
import com.sun.esb.eventmanagement.impl.EventManagementControllerMBean;
import com.sun.jbi.platform.PlatformContext;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class SunAppServerInstanceIdentifier
implements InstanceIdentifier {
    private static final Logger mLogger = Logger.getLogger(EventManagementControllerMBean.class.getName());
    private static boolean isDebugEnabled = mLogger.isLoggable(Level.FINEST);
    private static final String CONNECTORS_QUERY = "com.sun.appserv:type=Connector,*";
    private static final String CONNECTOR_PARTIAL_OBJECT_NAME = "com.sun.appserv:type=Connector,address=0.0.0.0,port=";
    private static final String SELECTOR_QUERY = "com.sun.appserv:type=Selector,*";
    private PlatformContext mPlatformContext;
    private MBeanServerConnection mMBeanServer;
    private static final String SERVER_HTTP_LISTENER1 = "com.sun.appserv:type=http-listener,id=http-listener-1,config=server-config,category=config";
    private static final String SERVER_ADMIN_LISTENER1 = " amx:X-ConfigConfig=server-config,j2eeType=X-HTTPListenerConfig,name=admin-listener,X-HTTPServiceConfig=na";
    HTTPListenerConfig mHTTPListenerConfig;

    public SunAppServerInstanceIdentifier(PlatformContext aPlatformContext) {
        this.mPlatformContext = aPlatformContext;
        this.mMBeanServer = this.mPlatformContext.getMBeanServer();
        this.getAdminListenerConfig();
    }

    public String getInstanceUniqueName() {
        return this.mPlatformContext.getInstanceName();
    }

    public String getInstanceUniquePort() {
        block3: {
            ObjectName on = null;
            try {
                on = new ObjectName(CONNECTORS_QUERY);
                Set<ObjectName> connectorsSet = this.mMBeanServer.queryNames(on, null);
                for (ObjectName connector : connectorsSet) {
                    String address = connector.getKeyProperty("address");
                    if (!"0.0.0.0".equals(address)) continue;
                    String portNumber = connector.getKeyProperty("port");
                    return portNumber;
                }
            }
            catch (Exception e) {
                if (!isDebugEnabled) break block3;
                mLogger.log(Level.FINEST, "Exception ", e);
            }
        }
        return "";
    }

    public String getInstanceHttpPort() {
        String httpPortNumber;
        block4: {
            httpPortNumber = "";
            try {
                ArrayList<String> httpPortList = new ArrayList<String>();
                ObjectName on = new ObjectName(SELECTOR_QUERY);
                Set<ObjectName> selectorSet = this.mMBeanServer.queryNames(on, null);
                for (ObjectName selctor : selectorSet) {
                    String name = selctor.getKeyProperty("name");
                    if (!name.startsWith("http")) continue;
                    httpPortList.add(name.substring(4));
                }
                for (String portNumber : httpPortList) {
                    ObjectName connectorObjectName = new ObjectName(CONNECTOR_PARTIAL_OBJECT_NAME + portNumber);
                    String[] signs = new String[]{"java.lang.String"};
                    Object[] params = new Object[]{"secure"};
                    String isSecure = (String)this.mMBeanServer.invoke(connectorObjectName, "getProperty", params, signs);
                    if ("true".equalsIgnoreCase(isSecure)) continue;
                    httpPortNumber = portNumber;
                    break;
                }
            }
            catch (Exception e) {
                if (!isDebugEnabled) break block4;
                e.printStackTrace();
            }
        }
        return httpPortNumber;
    }

    public String getHttpPort() {
        String httpPortNumber;
        block2: {
            httpPortNumber = "8080";
            try {
                ObjectName on = new ObjectName(SERVER_HTTP_LISTENER1);
                httpPortNumber = (String)this.mMBeanServer.getAttribute(on, "port");
            }
            catch (Exception e) {
                if (!isDebugEnabled) break block2;
                e.printStackTrace();
            }
        }
        return httpPortNumber;
    }

    public String getDomainAdminPort() {
        String httpPortNumber = null;
        boolean isDAS = this.mPlatformContext.isAdminServer();
        if (!isDAS) {
            return "";
        }
        httpPortNumber = this.mHTTPListenerConfig.getPort();
        return httpPortNumber;
    }

    public Boolean isSecureAdminPort() {
        Boolean isSecure = false;
        boolean isDAS = this.mPlatformContext.isAdminServer();
        if (!isDAS) {
            return isSecure;
        }
        isSecure = this.mHTTPListenerConfig.getSecurityEnabled();
        return isSecure;
    }

    private void getAdminListenerConfig() {
        boolean isDAS = this.mPlatformContext.isAdminServer();
        if (!isDAS) {
            return;
        }
        DomainRoot domain = ProxyFactory.getInstance((MBeanServerConnection)this.mMBeanServer).getDomainRoot();
        Map serverConfigMap = domain.getDomainConfig().getConfigConfigMap();
        ConfigConfig config = (ConfigConfig)serverConfigMap.get("server-config");
        HTTPServiceConfig httpService = config.getHTTPServiceConfig();
        Map listenerMap = httpService.getHTTPListenerConfigMap();
        this.mHTTPListenerConfig = (HTTPListenerConfig)listenerMap.get("admin-listener");
    }
}

