/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.helper.ComponentStatisticsDataCreator;
import com.sun.esb.management.common.data.helper.ComponentStatisticsDataWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentStatisticsData
implements Serializable {
    static final long serialVersionUID = -1L;
    public static final String INSTANCENAME_KEY = "InstanceName";
    public static final String COMPONENTUPTIME_KEY = "ComponentUpTime (ms)";
    public static final String NUMACTIVATEDENDPOINTS_KEY = "NumActivatedEndpoints";
    public static final String NUMRECEIVEDREQUESTS_KEY = "NumReceivedRequests";
    public static final String NUMSENTREQUESTS_KEY = "NumSentRequests";
    public static final String NUMRECEIVEDREPLIES_KEY = "NumReceivedReplies";
    public static final String NUMSENTREPLIES_KEY = "NumSentReplies";
    public static final String NUMRECEIVEDDONES_KEY = "NumReceivedDONEs";
    public static final String NUMSENTDONES_KEY = "NumSentDONEs";
    public static final String NUMRECEIVEDFAULTS_KEY = "NumReceivedFaults";
    public static final String NUMSENTFAULTS_KEY = "NumSentFaults";
    public static final String NUMRECEIVEDERRORS_KEY = "NumReceivedErrors";
    public static final String NUMSENTERRORS_KEY = "NumSentErrors";
    public static final String NUMCOMPLETEDEXCHANGES_KEY = "NumCompletedExchanges";
    public static final String NUMACTIVEEXCHANGES_KEY = "NumActiveExchanges";
    public static final String NUMERROREXCHANGES_KEY = "NumErrorExchanges";
    public static final String ME_RESPONSETIME_AVG_KEY = "MessageExchangeResponseTime Avg (ns)";
    public static final String ME_COMPONENTTIME_AVG_KEY = "MessageExchangeComponentTime Avg (ns)";
    public static final String ME_DELIVERYCHANNELTIME_AVG_KEY = "MessageExchangeDeliveryTime Avg (ns)";
    public static final String ME_MESSAGESERVICETIME_AVG_KEY = "MessageExchangeNMRTime Avg (ns)";
    public static final String COMPONENTEXTENSIONSTATS_KEY = "ComponentExtensionStats";
    protected String instanceName;
    protected long componentUpTime;
    protected long numberOfActivatedEndpoints;
    protected long numberOfReceivedRequests;
    protected long numberOfSentRequests;
    protected long numberOfReceivedReplies;
    protected long numberOfSentReplies;
    protected long numberOfReceivedDones;
    protected long numberOfSentDones;
    protected long numberOfReceivedFaults;
    protected long numberOfSentFaults;
    protected long numberOfReceivedErrors;
    protected long numberOfSentErrors;
    protected long numberOfCompletedExchanges;
    protected long numberOfActiveExchanges;
    protected long numberOfErrorExchanges;
    protected long messageExchangeResponseTimeAverage;
    protected long messageExchangeComponentTimeAverage;
    protected long messageExchangeDeliveryChannelTimeAverage;
    protected long messageExchangeMessageServiceTimeAverage;
    protected CompositeData componentExtensionStatus;
    protected String componentExtensionStatusAsString;
    protected boolean extendedTimingStatisticsFlagEnabled;

    public static TabularData generateTabularData(Map<String, ComponentStatisticsData> map) {
        TabularData tabularData = null;
        try {
            tabularData = ComponentStatisticsDataCreator.createTabularData(map);
        }
        catch (ManagementRemoteException managementRemoteException) {
            // empty catch block
        }
        return tabularData;
    }

    public static Map<String, ComponentStatisticsData> retrieveDataMap(TabularData tabularData) {
        ComponentStatisticsData data = null;
        HashMap<String, ComponentStatisticsData> dataMap = null;
        dataMap = new HashMap<String, ComponentStatisticsData>();
        for (CompositeData compositeData : tabularData.values()) {
            CompositeType compositeType = compositeData.getCompositeType();
            data = new ComponentStatisticsData();
            for (String item : compositeType.keySet()) {
                Object value;
                if (item.equals(INSTANCENAME_KEY)) {
                    value = (String)compositeData.get(item);
                    data.setInstanceName((String)value);
                }
                if (item.equals(COMPONENTUPTIME_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setComponentUpTime((Long)value);
                }
                if (item.equals(NUMACTIVATEDENDPOINTS_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setNumberOfActivatedEndpoints((Long)value);
                }
                if (item.equals(NUMRECEIVEDREQUESTS_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setNumberOfReceivedRequests((Long)value);
                }
                if (item.equals(NUMSENTREQUESTS_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setNumberOfSentRequests((Long)value);
                }
                if (item.equals(NUMRECEIVEDREPLIES_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setNumberOfReceivedReplies((Long)value);
                }
                if (item.equals(NUMSENTREPLIES_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setNumberOfSentReplies((Long)value);
                }
                if (item.equals(NUMRECEIVEDDONES_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setNumberOfReceivedDones((Long)value);
                }
                if (item.equals(NUMSENTDONES_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setNumberOfSentDones((Long)value);
                }
                if (item.equals(NUMRECEIVEDFAULTS_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setNumberOfReceivedFaults((Long)value);
                }
                if (item.equals(NUMSENTFAULTS_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setNumberOfSentFaults((Long)value);
                }
                if (item.equals(NUMRECEIVEDERRORS_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setNumberOfReceivedErrors((Long)value);
                }
                if (item.equals(NUMSENTERRORS_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setNumberOfSentErrors((Long)value);
                }
                if (item.equals(NUMCOMPLETEDEXCHANGES_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setNumberOfCompletedExchanges((Long)value);
                }
                if (item.equals(NUMACTIVEEXCHANGES_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setNumberOfActiveExchanges((Long)value);
                }
                if (item.equals(NUMERROREXCHANGES_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setNumberOfErrorExchanges((Long)value);
                }
                if (item.equals(ME_RESPONSETIME_AVG_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setMessageExchangeResponseTimeAverage((Long)value);
                    data.setExtendedTimingStatisticsFlagEnabled(true);
                }
                if (item.equals(ME_COMPONENTTIME_AVG_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setMessageExchangeComponentTimeAverage((Long)value);
                    data.setExtendedTimingStatisticsFlagEnabled(true);
                }
                if (item.equals(ME_DELIVERYCHANNELTIME_AVG_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setMessageExchangeDeliveryChannelTimeAverage((Long)value);
                    data.setExtendedTimingStatisticsFlagEnabled(true);
                }
                if (item.equals(ME_MESSAGESERVICETIME_AVG_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setMessageExchangeMessageServiceTimeAverage((Long)value);
                    data.setExtendedTimingStatisticsFlagEnabled(true);
                }
                if (!item.equals(COMPONENTEXTENSIONSTATS_KEY)) continue;
                value = (CompositeData)compositeData.get(item);
                data.setComponentExtensionStatus((CompositeData)value);
            }
            dataMap.put(data.getInstanceName(), data);
        }
        return dataMap;
    }

    public static String convertDataMapToXML(Map<String, ComponentStatisticsData> map) throws ManagementRemoteException {
        String xmlText = null;
        try {
            xmlText = ComponentStatisticsDataWriter.serialize(map);
        }
        catch (ParserConfigurationException e) {
            throw new ManagementRemoteException(e);
        }
        catch (TransformerException e) {
            throw new ManagementRemoteException(e);
        }
        return xmlText;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public long getComponentUpTime() {
        return this.componentUpTime;
    }

    public void setComponentUpTime(long componentUpTime) {
        this.componentUpTime = componentUpTime;
    }

    public boolean isExtendedTimingStatisticsFlagEnabled() {
        return this.extendedTimingStatisticsFlagEnabled;
    }

    public void setExtendedTimingStatisticsFlagEnabled(boolean extendedTimingStatisticsFlagEnabled) {
        this.extendedTimingStatisticsFlagEnabled = extendedTimingStatisticsFlagEnabled;
    }

    public long getNumberOfActivatedEndpoints() {
        return this.numberOfActivatedEndpoints;
    }

    public void setNumberOfActivatedEndpoints(long numberOfActivatedEndpoints) {
        this.numberOfActivatedEndpoints = numberOfActivatedEndpoints;
    }

    public long getNumberOfReceivedRequests() {
        return this.numberOfReceivedRequests;
    }

    public void setNumberOfReceivedRequests(long numberOfReceivedRequests) {
        this.numberOfReceivedRequests = numberOfReceivedRequests;
    }

    public long getNumberOfSentRequests() {
        return this.numberOfSentRequests;
    }

    public void setNumberOfSentRequests(long numberOfSentRequests) {
        this.numberOfSentRequests = numberOfSentRequests;
    }

    public long getNumberOfReceivedReplies() {
        return this.numberOfReceivedReplies;
    }

    public void setNumberOfReceivedReplies(long numberOfReceivedReplies) {
        this.numberOfReceivedReplies = numberOfReceivedReplies;
    }

    public long getNumberOfSentReplies() {
        return this.numberOfSentReplies;
    }

    public void setNumberOfSentReplies(long numberOfSentReplies) {
        this.numberOfSentReplies = numberOfSentReplies;
    }

    public long getNumberOfReceivedDones() {
        return this.numberOfReceivedDones;
    }

    public void setNumberOfReceivedDones(long numberOfReceivedDones) {
        this.numberOfReceivedDones = numberOfReceivedDones;
    }

    public long getNumberOfSentDones() {
        return this.numberOfSentDones;
    }

    public void setNumberOfSentDones(long numberOfSentDones) {
        this.numberOfSentDones = numberOfSentDones;
    }

    public long getNumberOfReceivedFaults() {
        return this.numberOfReceivedFaults;
    }

    public void setNumberOfReceivedFaults(long numberOfReceivedFaults) {
        this.numberOfReceivedFaults = numberOfReceivedFaults;
    }

    public long getNumberOfSentFaults() {
        return this.numberOfSentFaults;
    }

    public void setNumberOfSentFaults(long numberOfSentFaults) {
        this.numberOfSentFaults = numberOfSentFaults;
    }

    public long getNumberOfReceivedErrors() {
        return this.numberOfReceivedErrors;
    }

    public void setNumberOfReceivedErrors(long numberOfReceivedErrors) {
        this.numberOfReceivedErrors = numberOfReceivedErrors;
    }

    public long getNumberOfSentErrors() {
        return this.numberOfSentErrors;
    }

    public void setNumberOfSentErrors(long numberOfSentErrors) {
        this.numberOfSentErrors = numberOfSentErrors;
    }

    public long getNumberOfCompletedExchanges() {
        return this.numberOfCompletedExchanges;
    }

    public void setNumberOfCompletedExchanges(long numberOfCompletedExchanges) {
        this.numberOfCompletedExchanges = numberOfCompletedExchanges;
    }

    public long getNumberOfActiveExchanges() {
        return this.numberOfActiveExchanges;
    }

    public void setNumberOfActiveExchanges(long numberOfActiveExchanges) {
        this.numberOfActiveExchanges = numberOfActiveExchanges;
    }

    public long getNumberOfErrorExchanges() {
        return this.numberOfErrorExchanges;
    }

    public void setNumberOfErrorExchanges(long numberOfErrorExchanges) {
        this.numberOfErrorExchanges = numberOfErrorExchanges;
    }

    public long getMessageExchangeResponseTimeAverage() {
        return this.messageExchangeResponseTimeAverage;
    }

    public void setMessageExchangeResponseTimeAverage(long messageExchangeResponseTimeAverage) {
        this.messageExchangeResponseTimeAverage = messageExchangeResponseTimeAverage;
    }

    public long getMessageExchangeComponentTimeAverage() {
        return this.messageExchangeComponentTimeAverage;
    }

    public void setMessageExchangeComponentTimeAverage(long messageExchangeComponentTimeAverage) {
        this.messageExchangeComponentTimeAverage = messageExchangeComponentTimeAverage;
    }

    public long getMessageExchangeDeliveryChannelTimeAverage() {
        return this.messageExchangeDeliveryChannelTimeAverage;
    }

    public void setMessageExchangeDeliveryChannelTimeAverage(long messageExchangeDeliveryChannelTimeAverage) {
        this.messageExchangeDeliveryChannelTimeAverage = messageExchangeDeliveryChannelTimeAverage;
    }

    public long getMessageExchangeMessageServiceTimeAverage() {
        return this.messageExchangeMessageServiceTimeAverage;
    }

    public void setMessageExchangeMessageServiceTimeAverage(long messageExchangeMessageServiceTimeAverage) {
        this.messageExchangeMessageServiceTimeAverage = messageExchangeMessageServiceTimeAverage;
    }

    public CompositeData getComponentExtensionStatus() {
        return this.componentExtensionStatus;
    }

    public void setComponentExtensionStatus(CompositeData componentExtensionStatus) {
        this.componentExtensionStatus = componentExtensionStatus;
        if (componentExtensionStatus != null) {
            this.componentExtensionStatusAsString = ((Object)componentExtensionStatus).toString();
        }
    }

    public String getComponentExtensionStatusAsString() {
        return this.componentExtensionStatusAsString;
    }

    public void setComponentExtensionStatusAsString(String componentExtensionStatusAsString) {
        this.componentExtensionStatusAsString = componentExtensionStatusAsString;
    }

    public String getDisplayString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n    Instance Name=" + this.getInstanceName());
        buffer.append("\n    Component UpTime=" + this.getComponentUpTime());
        buffer.append("\n    Number Of Activated Endpoints=" + this.getNumberOfActivatedEndpoints());
        buffer.append("\n    Number Of Active Exchanges=" + this.getNumberOfActiveExchanges());
        buffer.append("\n    Number Of Completed Exchanges=" + this.getNumberOfCompletedExchanges());
        buffer.append("\n    Number Of Error Exchanges=" + this.getNumberOfErrorExchanges());
        buffer.append("\n    Number Of Received Dones=" + this.getNumberOfReceivedDones());
        buffer.append("\n    Number Of Received Errors=" + this.getNumberOfReceivedErrors());
        buffer.append("\n    Number Of Received Faults=" + this.getNumberOfReceivedFaults());
        buffer.append("\n    Number Of Received Replies=" + this.getNumberOfReceivedReplies());
        buffer.append("\n    Number Of Received Requests=" + this.getNumberOfReceivedRequests());
        buffer.append("\n    Number Of Sent Dones=" + this.getNumberOfSentDones());
        buffer.append("\n    Number Of Sent Errors=" + this.getNumberOfSentErrors());
        buffer.append("\n    Number Of Sent Faults=" + this.getNumberOfSentFaults());
        buffer.append("\n    Number Of Sent Replies=" + this.getNumberOfSentReplies());
        buffer.append("\n    Number Of Sent Requests=" + this.getNumberOfSentRequests());
        buffer.append("\n    Extended Timing Statistics are " + (this.isExtendedTimingStatisticsFlagEnabled() ? "" : "NOT") + " Enabled.");
        buffer.append("\n    \tMessage Exchange Component Time Average=" + this.getMessageExchangeComponentTimeAverage());
        buffer.append("\n    \tMessage Exchange Delivery Channel Time Average=" + this.getMessageExchangeDeliveryChannelTimeAverage());
        buffer.append("\n    \tMessage Exchange Message Service Time Average=" + this.getMessageExchangeMessageServiceTimeAverage());
        buffer.append("\n    \tMessage Exchange Response Time Average=" + this.getMessageExchangeResponseTimeAverage());
        buffer.append("\n    Component Extension Status=" + this.getComponentExtensionStatus());
        buffer.append("\n");
        return buffer.toString();
    }

    public static void main(String[] args) {
    }
}

