/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.impl.installation;

import com.sun.esb.management.api.installation.InstallationService;
import com.sun.esb.management.base.services.AbstractServiceMBeansImpl;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.EnvironmentContext;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallationServiceMBeanImpl
extends AbstractServiceMBeansImpl
implements InstallationService,
Serializable {
    static final long serialVersionUID = -1L;

    public InstallationServiceMBeanImpl(EnvironmentContext anEnvContext) {
        super(anEnvContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String installComponent(String zipFilePath, Properties paramProps, String targetName) throws ManagementRemoteException {
        InstallationServiceMBeanImpl.logDebug("Installing Component zip file " + zipFilePath);
        String fileURIString = null;
        File file = new File(zipFilePath);
        fileURIString = file.getAbsolutePath();
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        ObjectName installerObjectName = null;
        ObjectName lifecycleObjectName = null;
        String componentName = null;
        InstallationServiceMBeanImpl.logDebug("Install Step 1 : Calling loadNewInstaller on InstallerServiceMBean : " + installerServiceObjectName);
        installerObjectName = (ObjectName)this.invokeMBeanOperation(installerServiceObjectName, "loadNewInstaller", fileURIString);
        if (installerObjectName == null) {
            String[] args = new String[]{targetName};
            Exception exception = this.createManagementException("ui.mbean.install.comp.error.installerMBean", args, null);
            throw new ManagementRemoteException(exception);
        }
        try {
            InstallationServiceMBeanImpl.logDebug("Install Step 2 : Configuring Installer Configuration Parameters if present");
            this.configureComponentInstaller(installerObjectName, paramProps);
            InstallationServiceMBeanImpl.logDebug("Install Step 3 : Calling Install on InstallerMbean : " + installerObjectName);
            lifecycleObjectName = (ObjectName)this.invokeMBeanOperation(installerObjectName, "install");
            componentName = this.getComponentNameFromJmxObjectName(installerObjectName);
            if (!"domain".equals(targetName)) {
                if (lifecycleObjectName == null) {
                    String[] args = new String[]{installerObjectName.toString()};
                    Exception exception = this.createManagementException("ui.mbean.install.comp.error.lifecycleMBean", args, null);
                    throw new ManagementRemoteException(exception);
                }
                componentName = this.getComponentNameFromJmxObjectName(lifecycleObjectName);
                if (componentName == null) {
                    String[] args = new String[]{lifecycleObjectName.toString()};
                    Exception exception = this.createManagementException("ui.mbean.install.comp.error.compId", args, null);
                    throw new ManagementRemoteException(exception);
                }
            }
        }
        finally {
            boolean isRemoveComponent = false;
            boolean ignoreExceptions = false;
            if (componentName == null) {
                ignoreExceptions = true;
                isRemoveComponent = true;
            }
            InstallationServiceMBeanImpl.logDebug("Install Step 4 : unloading component installer " + installerObjectName);
            this.unloadComponentInstaller(installerObjectName, isRemoveComponent, ignoreExceptions, targetName);
        }
        return componentName;
    }

    @Override
    public String installComponent(String zipFilePath, String targetName) throws ManagementRemoteException {
        Properties params = new Properties();
        return this.installComponent(zipFilePath, params, targetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String installComponentFromDomain(String componentName, Properties properties, String targetName) throws ManagementRemoteException {
        if (targetName.equals("domain")) {
            return componentName;
        }
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        ObjectName installerObjectName = null;
        ObjectName lifecycleObjectName = null;
        InstallationServiceMBeanImpl.logDebug("Install Step 1 : Calling loadInstallerFromRepository which internally performs loadNewInstaller on InstallerServiceMBean : " + installerServiceObjectName);
        installerObjectName = (ObjectName)this.invokeMBeanOperation(installerServiceObjectName, "loadInstallerFromRepository", componentName);
        if (installerObjectName == null) {
            String[] args = new String[]{targetName};
            Exception exception = this.createManagementException("ui.mbean.install.comp.error.installerMBean", args, null);
            throw new ManagementRemoteException(exception);
        }
        try {
            InstallationServiceMBeanImpl.logDebug("Install Step 2 : Configuring Installer Configuration Parameters if present");
            this.configureComponentInstaller(installerObjectName, properties);
            InstallationServiceMBeanImpl.logDebug("Install Step 3 : Calling Install on InstallerMbean : " + installerObjectName);
            lifecycleObjectName = (ObjectName)this.invokeMBeanOperation(installerObjectName, "install");
            componentName = this.getComponentNameFromJmxObjectName(installerObjectName);
            if (!"domain".equals(targetName)) {
                if (lifecycleObjectName == null) {
                    String[] args = new String[]{installerObjectName.toString()};
                    Exception exception = this.createManagementException("ui.mbean.install.comp.error.lifecycleMBean", args, null);
                    throw new ManagementRemoteException(exception);
                }
                componentName = this.getComponentNameFromJmxObjectName(lifecycleObjectName);
                if (componentName == null) {
                    String[] args = new String[]{lifecycleObjectName.toString()};
                    Exception exception = this.createManagementException("ui.mbean.install.comp.error.compId", args, null);
                    throw new ManagementRemoteException(exception);
                }
            }
        }
        finally {
            boolean isRemoveComponent = false;
            boolean ignoreExceptions = false;
            if (componentName == null) {
                ignoreExceptions = true;
                isRemoveComponent = true;
            }
            InstallationServiceMBeanImpl.logDebug("Install Step 4 : unloading component installer " + installerObjectName);
            this.unloadComponentInstaller(installerObjectName, isRemoveComponent, ignoreExceptions, targetName);
        }
        return componentName;
    }

    @Override
    public String installComponentFromDomain(String componentName, String targetName) throws ManagementRemoteException {
        if (targetName.equals("domain")) {
            return componentName;
        }
        Properties params = new Properties();
        return this.installComponentFromDomain(componentName, params, targetName);
    }

    @Override
    public String installSharedLibrary(String zipFilePath, String targetName) throws ManagementRemoteException {
        InstallationServiceMBeanImpl.logDebug("Installing Shared Library " + zipFilePath);
        File file = new File(zipFilePath);
        String fileURIString = null;
        fileURIString = file.getAbsolutePath();
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        InstallationServiceMBeanImpl.logDebug("Calling installSharedLibrary on Installation Service MBean = " + installerServiceObjectName);
        Object sharedLibName = null;
        sharedLibName = this.invokeMBeanOperation(installerServiceObjectName, "installSharedLibrary", fileURIString);
        if (sharedLibName == null) {
            Exception exception = this.createManagementException("ui.mbean.install.sns.error", null, null);
            throw new ManagementRemoteException(exception);
        }
        return sharedLibName.toString();
    }

    @Override
    public String installSharedLibraryFromDomain(String libraryName, String targetName) throws ManagementRemoteException {
        if (targetName.equals("domain")) {
            return libraryName;
        }
        ObjectName installerServiceObjectName = null;
        Object sharedLibName = null;
        installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        if (installerServiceObjectName == null) {
            String[] args = new String[]{targetName};
            Exception exception = this.createManagementException("ui.mbean.install.comp.error.installerMBean", args, null);
            throw new ManagementRemoteException(exception);
        }
        this.checkForValidTarget(installerServiceObjectName, targetName);
        InstallationServiceMBeanImpl.logDebug("Invoking installSharedLibraryFromRepository which internally invokes installSharedLibrary on Installation Service MBean = " + installerServiceObjectName);
        sharedLibName = this.invokeMBeanOperation(installerServiceObjectName, "installSharedLibraryFromRepository", libraryName);
        if (sharedLibName == null) {
            Exception exception = this.createManagementException("ui.mbean.install.sns.error", null, null);
            throw new ManagementRemoteException(exception);
        }
        return sharedLibName.toString();
    }

    @Override
    public String uninstallComponent(String componentName, boolean forceDelete, boolean retainInDomain, String targetName) throws ManagementRemoteException {
        return this.uninstallComponentInternal(componentName, forceDelete, retainInDomain, targetName);
    }

    @Override
    public String uninstallComponent(String componentName, boolean forceDelete, String targetName) throws ManagementRemoteException {
        if (!forceDelete) {
            return this.uninstallComponent(componentName, targetName);
        }
        return this.uninstallComponentInternal(componentName, forceDelete, targetName);
    }

    @Override
    public String uninstallComponent(String componentName, String targetName) throws ManagementRemoteException {
        boolean force = false;
        return this.uninstallComponentInternal(componentName, force, targetName);
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, boolean retainInDomain, String targetName) throws ManagementRemoteException {
        InstallationServiceMBeanImpl.logDebug("uninstalling shared library " + sharedLibraryName);
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        InstallationServiceMBeanImpl.logDebug("Calling uninstallSharedLibrary on InstallerServiceMBean = " + installerServiceObjectName);
        Object resultObject = null;
        Object[] params = new Object[]{sharedLibraryName, retainInDomain};
        String[] signature = new String[]{"java.lang.String", "boolean"};
        resultObject = this.invokeMBeanOperation(installerServiceObjectName, "uninstallSharedLibrary", params, signature);
        if (resultObject == null || !(resultObject instanceof Boolean) || !((Boolean)resultObject).booleanValue()) {
            Exception exception = this.createManagementException("ui.mbean.uninstall.sns.error", null, null);
            throw new ManagementRemoteException(exception);
        }
        return sharedLibraryName;
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, String targetName) throws ManagementRemoteException {
        if (!forceDelete) {
            return this.uninstallSharedLibrary(sharedLibraryName, targetName);
        }
        return this.uninstallSharedLibraryInternal(sharedLibraryName, forceDelete, targetName);
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, String targetName) throws ManagementRemoteException {
        InstallationServiceMBeanImpl.logDebug("uninstalling shared library " + sharedLibraryName);
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        InstallationServiceMBeanImpl.logDebug("Calling uninstallSharedLibrary on InstallerServiceMBean = " + installerServiceObjectName);
        Object resultObject = null;
        resultObject = this.invokeMBeanOperation(installerServiceObjectName, "uninstallSharedLibrary", sharedLibraryName);
        if (resultObject == null || !(resultObject instanceof Boolean) || !((Boolean)resultObject).booleanValue()) {
            Exception exception = this.createManagementException("ui.mbean.uninstall.sns.error", null, null);
            throw new ManagementRemoteException(exception);
        }
        return sharedLibraryName;
    }

    @Override
    public String upgradeComponent(String componentName, String zipFilePath) throws ManagementRemoteException {
        InstallationServiceMBeanImpl.logDebug("Updating Component zip file " + zipFilePath);
        String fileURIString = null;
        File file = new File(zipFilePath);
        fileURIString = file.getAbsolutePath();
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName("domain");
        this.checkForValidTarget(installerServiceObjectName, "domain");
        Object[] params = new Object[]{componentName, fileURIString};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        this.invokeMBeanOperation(installerServiceObjectName, "upgradeComponent", params, signature);
        return componentName;
    }

    @Override
    public Map<String, String> installComponent(String zipFilePath, Properties paramProps, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installComponent(zipFilePath, paramProps, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> installComponent(String zipFilePath, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installComponent(zipFilePath, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> installSharedLibrary(String zipFilePath, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installSharedLibrary(zipFilePath, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallComponent(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallSharedLibrary(sharedLibraryName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> installComponentFromDomain(String componentName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installComponentFromDomain(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> installComponentFromDomain(String componentName, Properties properties, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installComponentFromDomain(componentName, properties, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, boolean forceDelete, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallComponent(componentName, forceDelete, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> installSharedLibraryFromDomain(String libraryName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.installSharedLibraryFromDomain(libraryName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallSharedLibrary(sharedLibraryName, forceDelete, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallComponent(componentName, forceDelete, retainInDomain, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.uninstallSharedLibrary(sharedLibraryName, forceDelete, retainInDomain, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    protected void configureComponentInstaller(ObjectName installerObjectName, Properties paramProps) throws ManagementRemoteException {
        if (paramProps == null || paramProps.size() == 0) {
            InstallationServiceMBeanImpl.logDebug("No Installer Params for " + installerObjectName);
            return;
        }
        ObjectName configObjectName = null;
        configObjectName = (ObjectName)this.getMBeanAttribute(installerObjectName, "InstallerConfigurationMBean");
        if (configObjectName == null) {
            Exception exception = this.createManagementException("ui.mbean.install.config.mbean.error.not.exist", null, null);
            throw new ManagementRemoteException(exception);
        }
        if (!this.isMBeanRegistered(configObjectName)) {
            InstallationServiceMBeanImpl.logDebug("Configuration MBean for " + installerObjectName);
            InstallationServiceMBeanImpl.logDebug("No ConfigurationMBean registered with name: " + configObjectName);
            return;
        }
        InstallationServiceMBeanImpl.logDebug("Setting the Installer Params on ConfigMBean " + configObjectName);
        AttributeList attrList = this.constructMBeanAttributes(configObjectName, paramProps);
        try {
            this.setMBeanAttributes(configObjectName, attrList);
        }
        catch (Exception ex) {
            Exception exception = this.createManagementException("ui.mbean.install.config.mbean.error.set.attrs.error", null, ex);
            throw new ManagementRemoteException(exception);
        }
    }

    protected String getComponentNameFromJmxObjectName(ObjectName jmxObjectName) {
        String componentName = null;
        try {
            componentName = jmxObjectName.getKeyProperty("ComponentName");
        }
        catch (NullPointerException nullEx) {
            componentName = null;
        }
        return componentName;
    }

    protected boolean unloadComponentInstaller(ObjectName installerObjectName, boolean isRemoveComponent, boolean isIgnoreExceptions, String targetName) throws ManagementRemoteException {
        String componentName = null;
        if (installerObjectName == null) {
            Exception exception = this.createManagementException("ui.mbean.install.installer.mbean.not.exist", null, null);
            throw new ManagementRemoteException(exception);
        }
        componentName = this.getComponentNameFromJmxObjectName(installerObjectName);
        if (componentName == null || componentName.trim().length() <= 0) {
            String[] args = new String[]{installerObjectName.toString()};
            Exception exception = this.createManagementException("ui.mbean.install.installer.mbean.has.no.component.name", args, null);
            throw new ManagementRemoteException(exception);
        }
        return this.unloadComponentInstaller(componentName, isRemoveComponent, isIgnoreExceptions, targetName);
    }

    protected boolean unloadComponentInstaller(String componentName, boolean isRemoveComponent, boolean isIgnoreExceptions, String targetName) throws ManagementRemoteException {
        boolean retainInDomain = false;
        if (retainInDomain) {
            isRemoveComponent = false;
            return this.unloadComponentInstallerInternal(componentName, isRemoveComponent, isIgnoreExceptions, targetName);
        }
        return this.unloadComponentInstallerInternal(componentName, isRemoveComponent, isIgnoreExceptions, targetName);
    }

    protected boolean unloadComponentInstallerInternal(String componentName, boolean isRemoveComponent, boolean isIgnoreExceptions, String targetName) throws ManagementRemoteException {
        boolean result = false;
        InstallationServiceMBeanImpl.logDebug("unloadComponentInstaller ComponentName: " + componentName + " isremoveComponent " + isRemoveComponent + " isIgnoreExceptions " + isIgnoreExceptions + " targetName " + targetName);
        try {
            ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
            Object[] params = new Object[]{componentName, isRemoveComponent};
            String[] signature = new String[]{"java.lang.String", "boolean"};
            InstallationServiceMBeanImpl.logDebug("Calling unloadInstaller with params ( " + params[0] + " , " + params[1] + " ) on InstallerServiceMBean : " + installerServiceObjectName.toString());
            Object resultObject = this.invokeMBeanOperation(installerServiceObjectName, "unloadInstaller", params, signature);
            result = (Boolean)resultObject;
        }
        catch (Exception ex) {
            if (isIgnoreExceptions) {
                InstallationServiceMBeanImpl.logError(ex);
            }
            throw ManagementRemoteException.filterJmxExceptions(ex);
        }
        return result;
    }

    protected String uninstallComponentInternal(String componentName, boolean force, String targetName) throws ManagementRemoteException {
        boolean retainInDomain = false;
        return this.uninstallComponentInternal(componentName, force, retainInDomain, targetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String uninstallComponentInternal(String componentName, boolean force, boolean retainInDomain, String targetName) throws ManagementRemoteException {
        InstallationServiceMBeanImpl.logDebug("Uninstalling Component " + componentName + " with force = " + force);
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        InstallationServiceMBeanImpl.logDebug("Uninstall Step 1 : Calling loadInstaller on InstallerServiceMBean : " + installerServiceObjectName);
        ObjectName installerObjectName = null;
        Object[] params = new Object[]{componentName, force};
        String[] signature = new String[]{"java.lang.String", "boolean"};
        installerObjectName = (ObjectName)this.invokeMBeanOperation(installerServiceObjectName, "loadInstaller", params, signature);
        if (installerObjectName == null) {
            Exception exception = this.createManagementException("ui.mbean.uninstall.comp.error.installerMBean", null, null);
            throw new ManagementRemoteException(exception);
        }
        boolean uninstalled = false;
        try {
            InstallationServiceMBeanImpl.logDebug("Uninstall Step 2 : Calling Unisntall on InstallerMbean : " + installerObjectName);
            params = new Object[]{force};
            signature = new String[]{"boolean"};
            this.invokeMBeanOperation(installerObjectName, "uninstall", params, signature);
            uninstalled = true;
        }
        finally {
            boolean isRemoveComponent = true;
            boolean ignoreExceptions = false;
            if (!uninstalled) {
                ignoreExceptions = true;
                if (!force) {
                    isRemoveComponent = false;
                }
            }
            InstallationServiceMBeanImpl.logDebug("Uninstall Step 2 : unloading component installer " + installerObjectName);
            if (retainInDomain) {
                isRemoveComponent = false;
            }
            this.unloadComponentInstaller(installerObjectName, isRemoveComponent, ignoreExceptions, targetName);
        }
        return componentName;
    }

    protected String uninstallSharedLibraryInternal(String sharedLibraryName, boolean forceDelete, String targetName) throws ManagementRemoteException {
        return this.uninstallSharedLibrary(sharedLibraryName, targetName);
    }
}

