/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.impl.runtime;

import com.sun.esb.management.api.runtime.RuntimeManagementService;
import com.sun.esb.management.base.services.AbstractListStateServiceMBeansImpl;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeManagementServiceMBeanImpl
extends AbstractListStateServiceMBeansImpl
implements RuntimeManagementService,
Serializable {
    static final long serialVersionUID = -1L;

    public RuntimeManagementServiceMBeanImpl(EnvironmentContext anEnvContext) {
        super(anEnvContext);
    }

    @Override
    public String listBindingComponents(String targetName) throws ManagementRemoteException {
        return this.listBindingComponents(null, null, null, targetName);
    }

    @Override
    public String listBindingComponents(String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws ManagementRemoteException {
        return this.listComponents(ComponentType.BINDING, state, sharedLibraryName, serviceAssemblyName, targetName);
    }

    @Override
    public String listServiceAssemblies(String targetName) throws ManagementRemoteException {
        return this.listServiceAssemblies(null, targetName);
    }

    @Override
    public String listServiceAssemblies(String componentName, String targetName) throws ManagementRemoteException {
        return this.listServiceAssemblies(null, componentName, targetName);
    }

    @Override
    public String listServiceAssemblies(String state, String componentName, String targetName) throws ManagementRemoteException {
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        this.validateUiServiceAssemblyInfoState(state);
        List saInfoList = this.getServiceAssemblyInfoList(RuntimeManagementServiceMBeanImpl.toFrameworkServiceAssemblyState(state), componentName, targetName);
        return ServiceAssemblyInfo.writeAsXmlTextWithProlog(saInfoList);
    }

    @Override
    public String listServiceEngines(String targetName) throws ManagementRemoteException {
        return this.listServiceEngines(null, null, null, targetName);
    }

    @Override
    public String listServiceEngines(String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws ManagementRemoteException {
        return this.listComponents(ComponentType.ENGINE, state, sharedLibraryName, serviceAssemblyName, targetName);
    }

    @Override
    public String listSharedLibraries(String targetName) throws ManagementRemoteException {
        return this.listSharedLibraries(null, targetName);
    }

    @Override
    public String listSharedLibraries(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        List frameworkCompInfoList = this.getFrameworkComponentInfoListForSharedLibraries(componentName, targetName);
        List uiCompInfoList = new ArrayList();
        uiCompInfoList = this.toUiComponentInfoList(frameworkCompInfoList, targetName);
        return JBIComponentInfo.writeAsXmlText(uiCompInfoList);
    }

    @Override
    public String listSharedLibraryDependents(String sharedLibraryName, String targetName) throws ManagementRemoteException {
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        Collection compNames = this.getComponentNamesDependentOnSharedLibrary(sharedLibraryName, targetName);
        return JBIComponentInfo.writeAsXmlText(this.toUiComponentInfoList(this.getFrameworkComponentInfoList(compNames, targetName), targetName));
    }

    @Override
    public String showBindingComponent(String name, String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws ManagementRemoteException {
        return this.showComponent(name, ComponentType.BINDING, state, sharedLibraryName, serviceAssemblyName, targetName);
    }

    @Override
    public String showServiceAssembly(String name, String state, String componentName, String targetName) throws ManagementRemoteException {
        RuntimeManagementServiceMBeanImpl.logDebug("show ServiceAssembly info for : " + name);
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        this.validateUiServiceAssemblyInfoState(state);
        String saName = null;
        if (null != name && name.trim().length() > 0) {
            saName = name.trim();
        }
        ArrayList<ServiceAssemblyInfo> uiInfoList = new ArrayList<ServiceAssemblyInfo>();
        if (saName == null) {
            return ServiceAssemblyInfo.writeAsXmlTextWithProlog(uiInfoList);
        }
        List saInfoList = this.getServiceAssemblyInfoList(RuntimeManagementServiceMBeanImpl.toFrameworkServiceAssemblyState(state), componentName, targetName);
        for (ServiceAssemblyInfo saInfo : saInfoList) {
            if (!saInfo.getName().equals(saName)) continue;
            uiInfoList.add(saInfo);
            break;
        }
        return ServiceAssemblyInfo.writeAsXmlTextWithProlog(uiInfoList);
    }

    @Override
    public String showServiceEngine(String name, String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws ManagementRemoteException {
        return this.showComponent(name, ComponentType.ENGINE, state, sharedLibraryName, serviceAssemblyName, targetName);
    }

    @Override
    public String showSharedLibrary(String name, String componentName, String targetName) throws ManagementRemoteException {
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        ArrayList<JBIComponentInfo> uiCompInfoList = new ArrayList<JBIComponentInfo>();
        ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
        ComponentInfo componentInformation = null;
        if (componentQuery != null && (componentInformation = componentQuery.getSharedLibraryInfo(name)) != null && ComponentType.SHARED_LIBRARY == componentInformation.getComponentType()) {
            uiCompInfoList.add(this.toUiComponentInfo(componentInformation, targetName));
        }
        return JBIComponentInfo.writeAsXmlText(uiCompInfoList);
    }

    @Override
    public String shutdownComponent(String componentName, boolean force, String targetName) throws ManagementRemoteException {
        RuntimeManagementServiceMBeanImpl.logDebug("shutting down Component " + componentName);
        ObjectName lifecycleObjectName = this.getComponentLifeCycleMBeanObjectName(componentName, targetName);
        this.checkForValidTarget(lifecycleObjectName, targetName);
        Object result = null;
        RuntimeManagementServiceMBeanImpl.logDebug("Calling shutDown on Component LifecycleMBean " + lifecycleObjectName);
        if (force) {
            Object[] params = new Object[]{force};
            String[] signature = new String[]{"boolean"};
            result = this.invokeMBeanOperation(lifecycleObjectName, "shutDown", params, signature);
        } else {
            result = this.invokeMBeanOperation(lifecycleObjectName, "shutDown");
        }
        return componentName;
    }

    @Override
    public String shutdownComponent(String componentName, String targetName) throws ManagementRemoteException {
        boolean force = false;
        return this.shutdownComponent(componentName, force, targetName);
    }

    @Override
    public String shutdownServiceAssembly(String serviceAssemblyName, boolean forceShutdown, String targetName) throws ManagementRemoteException {
        return this.shutdownServiceAssemblyInternal(serviceAssemblyName, forceShutdown, targetName);
    }

    @Override
    public String shutdownServiceAssembly(String serviceAssemblyName, String targetName) throws ManagementRemoteException {
        boolean force = false;
        return this.shutdownServiceAssemblyInternal(serviceAssemblyName, force, targetName);
    }

    @Override
    public String startComponent(String componentName, String targetName) throws ManagementRemoteException {
        RuntimeManagementServiceMBeanImpl.logDebug("starting Component " + componentName);
        ObjectName lifecycleObjectName = this.getComponentLifeCycleMBeanObjectName(componentName, targetName);
        this.checkForValidTarget(lifecycleObjectName, targetName);
        Object result = null;
        RuntimeManagementServiceMBeanImpl.logDebug("Calling start on Component LifecycleMBean " + lifecycleObjectName);
        result = this.invokeMBeanOperation(lifecycleObjectName, "start");
        return componentName;
    }

    @Override
    public String startServiceAssembly(String serviceAssemblyName, String targetName) throws ManagementRemoteException {
        RuntimeManagementServiceMBeanImpl.logDebug("Starting Service Assembly " + serviceAssemblyName);
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        this.checkForValidTarget(deploymentServiceObjectName, targetName);
        RuntimeManagementServiceMBeanImpl.logDebug("Calling start on DeploymentServiceMBean = " + deploymentServiceObjectName);
        Object resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "start", serviceAssemblyName);
        String result = null;
        if (resultObject != null) {
            result = resultObject.toString();
            result = serviceAssemblyName == null || result.contains("FAILED") || result.contains("WARNING") ? resultObject.toString() : serviceAssemblyName;
            return result;
        }
        Exception exception = this.createManagementException("ui.mbean.sasm.start.error", null, null);
        throw new ManagementRemoteException(exception);
    }

    @Override
    public String stopComponent(String componentName, String targetName) throws ManagementRemoteException {
        RuntimeManagementServiceMBeanImpl.logDebug("stopping Component " + componentName);
        ObjectName lifecycleObjectName = this.getComponentLifeCycleMBeanObjectName(componentName, targetName);
        this.checkForValidTarget(lifecycleObjectName, targetName);
        Object result = null;
        RuntimeManagementServiceMBeanImpl.logDebug("Calling stop on Component LifecycleMBean " + lifecycleObjectName);
        result = this.invokeMBeanOperation(lifecycleObjectName, "stop");
        return componentName;
    }

    @Override
    public String stopServiceAssembly(String serviceAssemblyName, String targetName) throws ManagementRemoteException {
        RuntimeManagementServiceMBeanImpl.logDebug("Stopping Service Assembly " + serviceAssemblyName);
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        this.checkForValidTarget(deploymentServiceObjectName, targetName);
        RuntimeManagementServiceMBeanImpl.logDebug("Calling stop on Deployment Service MBean = " + deploymentServiceObjectName);
        Object resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "stop", serviceAssemblyName);
        String result = null;
        if (resultObject != null) {
            result = resultObject.toString();
            result = serviceAssemblyName == null || result.contains("FAILED") || result.contains("WARNING") ? resultObject.toString() : serviceAssemblyName;
            return result;
        }
        Exception exception = this.createManagementException("ui.mbean.sasm.stop.error", null, null);
        throw new ManagementRemoteException(exception);
    }

    @Override
    public Map<String, String> listBindingComponents(String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listBindingComponents(targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listBindingComponents(String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listBindingComponents(state, sharedLibraryName, serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listServiceAssemblies(String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listServiceAssemblies(targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listServiceAssemblies(String componentName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listServiceAssemblies(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listServiceAssemblies(String state, String componentName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listServiceAssemblies(state, componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listServiceEngines(String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listServiceEngines(targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listServiceEngines(String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listServiceEngines(state, sharedLibraryName, serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listSharedLibraries(String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listSharedLibraries(targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listSharedLibraries(String componentName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listSharedLibraries(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> listSharedLibraryDependents(String sharedLibraryName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.listSharedLibraryDependents(sharedLibraryName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> showBindingComponent(String name, String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.showBindingComponent(name, state, sharedLibraryName, serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> showServiceAssembly(String name, String state, String componentName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.showServiceAssembly(name, state, componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> showServiceEngine(String name, String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.showServiceEngine(name, state, sharedLibraryName, serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> showSharedLibrary(String name, String componentName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.showSharedLibrary(name, componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> shutdownComponent(String componentName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.shutdownComponent(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> shutdownComponent(String componentName, boolean force, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.shutdownComponent(componentName, force, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> shutdownServiceAssembly(String serviceAssemblyName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.shutdownServiceAssembly(serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> shutdownServiceAssembly(String serviceAssemblyName, boolean forceShutdown, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.shutdownServiceAssembly(serviceAssemblyName, forceShutdown, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> startComponent(String componentName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.startComponent(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> startServiceAssembly(String serviceAssemblyName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.startServiceAssembly(serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> stopComponent(String componentName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.stopComponent(componentName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> stopServiceAssembly(String serviceAssemblyName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (int index = 0; index < targetNames.length; ++index) {
            try {
                xmlString = this.stopServiceAssembly(serviceAssemblyName, targetNames[index]);
                if (xmlString == null) continue;
                result.putIfAbsent(targetNames[index], xmlString);
                continue;
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace(exception);
                result.putIfAbsent(targetNames[index], xmlString);
            }
        }
        return result;
    }

    protected String showComponent(String name, ComponentType type, String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws ManagementRemoteException {
        List compInfoList;
        ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
        this.checkForValidTarget(installerServiceObjectName, targetName);
        this.validateUiJBIComponentInfoState(state);
        ArrayList<JBIComponentInfo> uiCompInfoList = new ArrayList<JBIComponentInfo>();
        if (name == null || name.trim().length() <= 0) {
            return JBIComponentInfo.writeAsXmlText(uiCompInfoList);
        }
        ComponentQuery componentQuery = this.getFrameworkComponentQuery(targetName);
        ComponentInfo componentInformation = null;
        if (componentQuery != null) {
            componentInformation = componentQuery.getComponentInfo(name);
        }
        if (componentInformation == null) {
            return JBIComponentInfo.writeAsXmlText(uiCompInfoList);
        }
        ComponentType frameworkCompType = ComponentType.BINDINGS_AND_ENGINES;
        ComponentState frameworkCompState = ComponentState.UNKNOWN;
        frameworkCompType = type != ComponentType.ENGINE && type != ComponentType.BINDING ? ComponentType.BINDINGS_AND_ENGINES : type;
        if (state != null) {
            frameworkCompState = RuntimeManagementServiceMBeanImpl.toFrameworkComponentInfoState(state);
        }
        if ((compInfoList = this.getFrameworkComponentInfoListForEnginesAndBindings(frameworkCompType, frameworkCompState, sharedLibraryName, serviceAssemblyName, targetName)) == null || compInfoList.size() <= 0) {
            return JBIComponentInfo.writeAsXmlText(uiCompInfoList);
        }
        Iterator itr = compInfoList.iterator();
        while (itr.hasNext()) {
            String compName = ((ComponentInfo)itr.next()).getName();
            if (!compName.equals(componentInformation.getName())) continue;
            uiCompInfoList.add(this.toUiComponentInfo(componentInformation, targetName));
            break;
        }
        return JBIComponentInfo.writeAsXmlText(uiCompInfoList);
    }

    protected String shutdownServiceAssemblyInternal(String serviceAssemblyName, boolean force, String targetName) throws ManagementRemoteException {
        RuntimeManagementServiceMBeanImpl.logDebug("Shutting down Service Assembly " + serviceAssemblyName);
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        this.checkForValidTarget(deploymentServiceObjectName, targetName);
        RuntimeManagementServiceMBeanImpl.logDebug("Calling shutdown on Deployment Service MBean = " + deploymentServiceObjectName.toString());
        Object resultObject = null;
        if (!force) {
            resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "shutDown", serviceAssemblyName);
        } else {
            Object[] params = new Object[]{serviceAssemblyName, force};
            String[] signature = new String[]{"java.lang.String", "boolean"};
            resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "shutDown", params, signature);
        }
        String result = null;
        if (resultObject != null) {
            result = resultObject.toString();
            result = serviceAssemblyName == null || result.contains("FAILED") || result.contains("WARNING") ? resultObject.toString() : serviceAssemblyName;
            return result;
        }
        Exception exception = this.createManagementException("ui.mbean.sasm.shutdown.error", null, null);
        throw new ManagementRemoteException(exception);
    }
}

