/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.framework.Component;
import com.sun.jbi.framework.CustomClassLoader;
import com.sun.jbi.framework.DelegatingClassLoader;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.SharedLibrary;
import com.sun.jbi.framework.StringTranslator;
import com.sun.jbi.platform.PlatformContext;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassLoaderFactory {
    private HashMap mComponentClassLoaderCache = new HashMap();
    private HashMap mSharedClassLoaderCache = new HashMap();
    private StringTranslator mTranslator;
    private Logger mLogger;
    private static ClassLoaderFactory sClassLoaderFactory;

    private ClassLoaderFactory() {
        EnvironmentContext envCtx = EnvironmentContext.getInstance();
        this.mTranslator = (StringTranslator)envCtx.getStringTranslatorFor(this);
        this.mLogger = envCtx.getLogger();
    }

    public static ClassLoaderFactory getInstance() {
        if (null == sClassLoaderFactory) {
            sClassLoaderFactory = new ClassLoaderFactory();
        }
        return sClassLoaderFactory;
    }

    public ClassLoader createBootstrapClassLoader(Component component) throws JBIException {
        if (null == component) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "component"));
        }
        List<String> bootCpElements = component.getBootstrapClassPathElements();
        if (null == bootCpElements) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "paths"));
        }
        if (bootCpElements.isEmpty()) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_LIST_ARGUMENT", "paths"));
        }
        try {
            URL[] urls = this.list2URLArray(bootCpElements);
            boolean selfFirst = component.isBootstrapClassLoaderSelfFirst();
            CustomClassLoader cl = new CustomClassLoader(urls, this.getJBISystemClassLoader(), selfFirst);
            this.mLogger.finer("Created bootstrap CustomClassLoader for " + component.getComponentTypeAsString() + " " + component.getName() + " with class path " + bootCpElements);
            return cl;
        }
        catch (Throwable e) {
            throw new JBIException(this.mTranslator.getString("CL_BOOTSTRAP_CREATE_FAILED", e.toString()), e);
        }
    }

    public ClassLoader createSharedClassLoader(SharedLibrary sharedLib) throws JBIException {
        if (null == sharedLib) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "sharedLib"));
        }
        try {
            ClassLoader cl = (ClassLoader)this.mSharedClassLoaderCache.get(sharedLib.getName());
            if (null == cl) {
                List slPaths = sharedLib.getClassPathElements();
                URL[] urls = this.list2URLArray(slPaths);
                boolean selfFirst = sharedLib.isClassLoaderSelfFirst();
                cl = new CustomClassLoader(urls, this.getJBISystemClassLoader(), selfFirst);
                this.mSharedClassLoaderCache.put(sharedLib.getName(), cl);
            }
            this.mLogger.finer("Created shared CustomClassLoader for " + sharedLib.getName() + " with class path " + sharedLib.getClassPathElements());
            return cl;
        }
        catch (Throwable e) {
            throw new JBIException(this.mTranslator.getString("CL_SHARED_CREATE_FAILED", e.toString()), e);
        }
    }

    public void removeSharedClassLoader(String sharedLibId) throws JBIException {
        if (null == sharedLibId) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "sharedLibId"));
        }
        if (sharedLibId.length() == 0) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_STRING_ARGUMENT", "sharedLibId"));
        }
        CustomClassLoader cl = (CustomClassLoader)this.mSharedClassLoaderCache.remove(sharedLibId);
        if (null == cl) {
            throw new JBIException(this.mTranslator.getString("CL_SHARED_CLASSLOADER_NOT_FOUND", sharedLibId));
        }
        cl.releaseResources();
        this.mLogger.finer("Removed shared CustomClassLoader for " + sharedLibId);
    }

    public ClassLoader getSharedClassLoader(String sharedLibId) throws JBIException {
        if (null == sharedLibId) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "sharedLibId"));
        }
        if (sharedLibId.length() == 0) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_STRING_ARGUMENT", "sharedLibId"));
        }
        ClassLoader sharedLoader = (ClassLoader)this.mSharedClassLoaderCache.get(sharedLibId);
        if (null == sharedLoader) {
            throw new JBIException(this.mTranslator.getString("CL_SHARED_CLASSLOADER_NOT_FOUND", sharedLibId));
        }
        return sharedLoader;
    }

    public ClassLoader createComponentClassLoader(Component component) throws JBIException {
        ClassLoader compClassLoader;
        if (null == component) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "component"));
        }
        try {
            compClassLoader = (ClassLoader)this.mComponentClassLoaderCache.get(component.getName());
            if (null == compClassLoader) {
                List<String> lifeCycleCpElements = this.addUserLibs(component.getName(), component.getClassPathElements());
                URL[] cpURLs = this.list2URLArray(lifeCycleCpElements);
                boolean selfFirst = component.isClassLoaderSelfFirst();
                DelegatingClassLoader dcl = this.createDelegatingClassLoader(component);
                compClassLoader = new CustomClassLoader(cpURLs, (ClassLoader)dcl, selfFirst);
                this.mComponentClassLoaderCache.put(component.getName(), compClassLoader);
                this.mLogger.finer("Created life cycle CustomClassLoader for " + component.getComponentTypeAsString() + " " + component.getName() + " with class path " + lifeCycleCpElements);
            }
        }
        catch (JBIException je) {
            throw je;
        }
        catch (Throwable e) {
            throw new JBIException(this.mTranslator.getString("CL_COMPONENT_CREATE_FAILED", e.toString()), e);
        }
        return compClassLoader;
    }

    public void removeComponentClassLoader(String componentId) throws JBIException {
        if (null == componentId) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "componentId"));
        }
        if (componentId.length() == 0) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_STRING_ARGUMENT", "componentId"));
        }
        CustomClassLoader compClassLoader = (CustomClassLoader)this.mComponentClassLoaderCache.remove(componentId);
        if (null == compClassLoader) {
            throw new JBIException(this.mTranslator.getString("CL_COMPONENT_CLASSLOADER_NOT_FOUND", componentId));
        }
        compClassLoader.releaseResources();
        this.mLogger.finer("Removed life cycle CustomClassLoader for " + componentId);
    }

    public ClassLoader getComponentClassLoader(String componentId) throws JBIException {
        if (null == componentId) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "componentId"));
        }
        if (componentId.length() == 0) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_STRING_ARGUMENT", "componentId"));
        }
        ClassLoader compLoader = (ClassLoader)this.mComponentClassLoaderCache.get(componentId);
        if (null == compLoader) {
            throw new JBIException(this.mTranslator.getString("CL_COMPONENT_CLASSLOADER_NOT_FOUND", componentId));
        }
        return compLoader;
    }

    private DelegatingClassLoader createDelegatingClassLoader(Component comp) throws Exception {
        this.mLogger.finest("Creating DelegatingClassLoader for " + comp.getComponentTypeAsString() + " " + comp.getName());
        DelegatingClassLoader dcl = new DelegatingClassLoader(this.getJBISystemClassLoader());
        List<String> sharedLibraries = comp.getSharedLibraryNames();
        if (null != sharedLibraries) {
            ListIterator<String> slItr = sharedLibraries.listIterator();
            while (slItr.hasNext()) {
                String slName = (String)slItr.next();
                ClassLoader sharedLibLoader = this.getSharedClassLoader(slName);
                dcl.addSharedClassLoader(sharedLibLoader);
                this.mLogger.finer("Added shared CustomClassLoader for " + slName + " to DelegatingClassLoader");
            }
        }
        return dcl;
    }

    private URL[] list2URLArray(List paths) throws Exception {
        URL[] urls = new URL[paths.size()];
        int i = 0;
        ListIterator itr = paths.listIterator();
        while (itr.hasNext()) {
            String nextCPElement = (String)itr.next();
            File f = new File(nextCPElement);
            urls[i++] = f.toURL();
        }
        return urls;
    }

    private List<String> addUserLibs(String compName, List<String> paths) {
        List<String> elements = paths;
        String ext = EnvironmentContext.getInstance().getJbiInstallRoot() + File.separator + "libext" + File.separator + compName;
        File extFile = new File(ext);
        if (extFile.exists()) {
            this.mLogger.finer("found class path extension directory " + ext);
            File[] extLibs = extFile.listFiles();
            if (null != extLibs) {
                this.mLogger.finer("found files in class path extension directory");
                elements = new ArrayList<String>(paths);
                for (int i = 0; i < extLibs.length; ++i) {
                    File extLib = extLibs[i];
                    try {
                        String name = extLib.getCanonicalPath();
                        this.mLogger.finest("checking file " + name);
                        if (!extLib.isFile() || !extLib.canRead() || extLib.isHidden() || !name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                        elements.add(name);
                        this.mLogger.finest(name + "added to class path");
                        continue;
                    }
                    catch (IOException ioEx) {
                        this.mLogger.log(Level.WARNING, this.mTranslator.getString("CL_COMPONENT_EXTENSION_ERROR", extLib.getName()), ioEx);
                    }
                }
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.fine("Component " + compName + " original class path:");
                    for (String entry : paths) {
                        this.mLogger.fine("     " + entry);
                    }
                    this.mLogger.fine("Component " + compName + " updated class path:");
                    for (String entry : elements) {
                        this.mLogger.info("     " + entry);
                    }
                }
            }
        }
        return elements;
    }

    private ClassLoader getJBISystemClassLoader() {
        ClassLoader systemClassLoader = null;
        PlatformContext platform = EnvironmentContext.getInstance().getPlatformContext();
        systemClassLoader = platform.getSystemClassLoader();
        if (null != System.getProperty("junit.srcroot")) {
            systemClassLoader = this.getClass().getClassLoader();
        }
        return systemClassLoader;
    }
}

