/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.framework.ClassLoaderFactory;
import com.sun.jbi.framework.ComponentContext;
import com.sun.jbi.framework.ComponentLogger;
import com.sun.jbi.framework.ComponentStatistics;
import com.sun.jbi.framework.CustomClassLoader;
import com.sun.jbi.framework.Deployer;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.ServiceUnit;
import com.sun.jbi.framework.StringTranslator;
import com.sun.jbi.management.descriptor.ComponentDescriptor;
import com.sun.jbi.management.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.management.ObjectName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component
implements ComponentInfo {
    private boolean mBootstrapClassLoaderSelfFirst;
    private String mBootstrapClassName;
    private ArrayList mBootstrapClassPathElements;
    private boolean mComponentClassLoaderSelfFirst;
    private String mComponentClassName;
    private ArrayList mComponentClassPathElements;
    private ComponentState mComponentState;
    private ComponentType mComponentType;
    private String mDescription;
    private ComponentState mDesiredState;
    private String mInstallRoot;
    private String mName;
    private Hashtable mServiceUnitList = new Hashtable();
    private ArrayList mSharedLibraryNames;
    private String mWorkspaceRoot;
    private transient ClassLoader mBootstrapClassLoader;
    private transient boolean mBootstrapCleanUpNeeded;
    private transient Bootstrap mBootstrapInstance;
    private transient boolean mBusy;
    private transient javax.jbi.component.Component mComponentInstance;
    private transient ComponentContext mContext;
    private transient Deployer mDeployerInstance;
    private transient ObjectName mDeployerMBeanName;
    private transient ObjectName mExtensionMBeanName;
    private transient ObjectName mInstallerMBeanName;
    private transient ObjectName mConfigMBeanName;
    private transient String mJbiXmlString;
    private transient ComponentDescriptor mJbiXmlModel;
    private transient ComponentLifeCycle mLifeCycleInstance;
    private transient ObjectName mLifeCycleMBeanName;
    private transient Logger mLog;
    private transient ComponentLogger mLoggerInstance;
    private transient ObjectName mLoggerMBeanName;
    private transient Boolean mObserver;
    private transient ServiceUnitManager mSUManagerInstance;
    private transient ComponentStatistics mStatisticsInstance;
    private transient ObjectName mStatisticsMBeanName;
    private transient StringTranslator mTranslator = (StringTranslator)EnvironmentContext.getInstance().getStringTranslatorFor(this);
    private transient boolean mUpdating;
    private static String OBSERVER_NS = "http://www.sun.com/jbi/observer";
    private static String OBSERVER_TAG = "Observer";

    public Component() {
        this.mLog = EnvironmentContext.getInstance().getLogger();
        this.mComponentState = ComponentState.UNKNOWN;
        this.mDesiredState = ComponentState.UNKNOWN;
        this.mObserver = null;
    }

    public Component(ComponentInfo compInfo) {
        this.mLog = EnvironmentContext.getInstance().getLogger();
        this.mComponentType = compInfo.getComponentType();
        this.mName = compInfo.getName();
        this.mDescription = compInfo.getDescription();
        this.mInstallRoot = compInfo.getInstallRoot();
        this.mWorkspaceRoot = compInfo.getWorkspaceRoot();
        this.mComponentState = ComponentState.SHUTDOWN;
        this.mDesiredState = compInfo.getStatus();
        this.mObserver = null;
        this.mBootstrapClassLoaderSelfFirst = compInfo.isBootstrapClassLoaderSelfFirst();
        this.mBootstrapClassName = compInfo.getBootstrapClassName();
        this.mBootstrapClassPathElements = new ArrayList<String>(compInfo.getBootstrapClassPathElements());
        this.mComponentClassName = compInfo.getComponentClassName();
        this.mComponentClassPathElements = new ArrayList<String>(compInfo.getClassPathElements());
        this.mComponentClassLoaderSelfFirst = compInfo.isClassLoaderSelfFirst();
        List<ServiceUnitInfo> suList = compInfo.getServiceUnitList();
        for (ServiceUnitInfo suInfo : suList) {
            ServiceUnit su = new ServiceUnit(suInfo);
            this.mServiceUnitList.put(suInfo.getName(), su);
        }
        this.mSharedLibraryNames = new ArrayList<String>(compInfo.getSharedLibraryNames());
    }

    public void addServiceUnit(ServiceUnit serviceUnit) throws JBIException {
        if (null == serviceUnit) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "serviceUnit"));
        }
        if (this.mServiceUnitList.containsKey(serviceUnit.getName())) {
            String msg = this.mTranslator.getString("SU_ALREADY_EXISTS", serviceUnit.getName(), this.getComponentTypeAsString(), this.getName());
            throw new JBIException(msg);
        }
        this.mServiceUnitList.put(serviceUnit.getName(), serviceUnit);
    }

    public void clearBootstrapInstance() {
        this.mBootstrapInstance = null;
        if (null != this.mBootstrapClassLoader) {
            ((CustomClassLoader)this.mBootstrapClassLoader).releaseResources();
            this.mBootstrapClassLoader = null;
        }
    }

    public void clearBusy() {
        this.mBusy = false;
    }

    public void clearLifeCycleInstance() {
        this.mComponentInstance = null;
        this.mLifeCycleInstance = null;
        this.mSUManagerInstance = null;
        try {
            ClassLoaderFactory.getInstance().removeComponentClassLoader(this.mName);
        }
        catch (JBIException jBIException) {
            // empty catch block
        }
    }

    public void clearStatisticsInstance() {
        this.mStatisticsInstance = null;
    }

    public void clearUpdating() {
        this.mUpdating = false;
        this.clearBusy();
    }

    @Override
    public boolean equals(Object object) {
        if (null == object || !(object instanceof Component)) {
            return false;
        }
        Component component = (Component)object;
        if (!this.mName.equals(component.getName())) {
            return false;
        }
        if (this.mComponentType != component.getComponentType()) {
            return false;
        }
        if (null == this.mDescription ? null != component.getDescription() : !this.mDescription.equals(component.getDescription())) {
            return false;
        }
        if (null == this.mBootstrapClassName ? null != component.getBootstrapClassName() : !this.mBootstrapClassName.equals(component.getBootstrapClassName())) {
            return false;
        }
        if (null == this.mBootstrapClassPathElements ? null != component.getBootstrapClassPathElements() : !this.mBootstrapClassPathElements.equals(component.getBootstrapClassPathElements())) {
            return false;
        }
        if (null == this.mComponentClassName ? null != component.getComponentClassName() : !this.mComponentClassName.equals(component.getComponentClassName())) {
            return false;
        }
        if (null == this.mComponentClassPathElements ? null != component.getComponentClassPathElements() : !this.mComponentClassPathElements.equals(component.getComponentClassPathElements())) {
            return false;
        }
        if (null == this.mInstallRoot ? null != component.getInstallRoot() : !this.mInstallRoot.equals(component.getInstallRoot())) {
            return false;
        }
        if (null == this.mWorkspaceRoot ? null != component.getWorkspaceRoot() : !this.mWorkspaceRoot.equals(component.getWorkspaceRoot())) {
            return false;
        }
        if (null == this.mSharedLibraryNames ? null != component.getSharedLibraryNames() && !component.getSharedLibraryNames().isEmpty() : !this.mSharedLibraryNames.equals(component.getSharedLibraryNames())) {
            return false;
        }
        return !(null == this.mServiceUnitList ? null != component.getServiceUnitList() && !component.getServiceUnitList().isEmpty() : !((Object)this.getServiceUnitList()).equals(component.getServiceUnitList()));
    }

    @Override
    public String getBootstrapClassName() {
        return this.mBootstrapClassName;
    }

    @Override
    public List<String> getBootstrapClassPathElements() {
        return this.mBootstrapClassPathElements;
    }

    public Bootstrap getBootstrapInstance(boolean canCreate) throws JBIException {
        if (canCreate && null == this.mBootstrapInstance) {
            try {
                ClassLoader cl;
                this.mBootstrapClassLoader = cl = ClassLoaderFactory.getInstance().createBootstrapClassLoader(this);
                Object o = cl.loadClass(this.mBootstrapClassName).newInstance();
                if (!(o instanceof Bootstrap)) {
                    String msg = this.mTranslator.getString("COMP_CLASS_NOT_VALID", this.mBootstrapClassName, "javax.jbi.component.Bootstrap");
                    throw new JBIException(msg);
                }
                this.mBootstrapInstance = (Bootstrap)o;
            }
            catch (JBIException jbiEx) {
                throw new JBIException(this.mTranslator.getString("COMP_BOOTSTRAP_LOAD_FAILED", this.mName, jbiEx.getMessage()));
            }
            catch (ClassNotFoundException cnfEx) {
                String msg = this.mTranslator.getString("COMP_CLASS_NOT_FOUND", cnfEx.getMessage());
                if (null != cnfEx.getCause()) {
                    this.mLog.log(Level.WARNING, msg, cnfEx.getCause());
                    throw new JBIException(this.mTranslator.getString("COMP_BOOTSTRAP_LOAD_FAILED", this.mName, msg), cnfEx.getCause());
                }
                throw new JBIException(this.mTranslator.getString("COMP_BOOTSTRAP_LOAD_FAILED", this.mName, msg));
            }
            catch (Throwable ex) {
                String msg = this.mTranslator.getString("COMP_EXCEPTION", ex.getClass().getName());
                this.mLog.log(Level.WARNING, msg, ex);
                throw new JBIException(this.mTranslator.getString("COMP_BOOTSTRAP_LOAD_FAILED", this.mName, msg), ex);
            }
        }
        return this.mBootstrapInstance;
    }

    @Override
    public List<String> getClassPathElements() {
        return this.mComponentClassPathElements;
    }

    @Override
    public String getComponentClassName() {
        return this.mComponentClassName;
    }

    public String getComponentClassPathAsString() {
        String sep = System.getProperty("path.separator");
        Iterator i = this.mComponentClassPathElements.iterator();
        StringBuffer sb = new StringBuffer("");
        boolean first = true;
        while (i.hasNext()) {
            if (!first) {
                sb.append(sep);
            } else {
                first = false;
            }
            sb.append((String)i.next());
        }
        return new String(sb);
    }

    public List<String> getComponentClassPathElements() {
        return this.mComponentClassPathElements;
    }

    public javax.jbi.component.Component getComponentInstance() {
        return this.mComponentInstance;
    }

    @Override
    public ComponentType getComponentType() {
        return this.mComponentType;
    }

    public String getComponentTypeAsString() {
        if (this.isBinding()) {
            return this.mTranslator.getString("BINDING");
        }
        if (this.isEngine()) {
            return this.mTranslator.getString("ENGINE");
        }
        return this.mTranslator.getString("UNKNOWN");
    }

    public ComponentContext getContext() {
        return this.mContext;
    }

    public ObjectName getConfigurationMBeanName() {
        return this.mConfigMBeanName;
    }

    public Deployer getDeployerInstance() {
        return this.mDeployerInstance;
    }

    public ObjectName getDeployerMBeanName() {
        return this.mDeployerMBeanName;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    public ComponentState getDesiredState() {
        return this.mDesiredState;
    }

    public ObjectName getExtensionMBeanName() {
        return this.mExtensionMBeanName;
    }

    public ObjectName getInstallerMBeanName() {
        return this.mInstallerMBeanName;
    }

    @Override
    public String getInstallRoot() {
        return this.mInstallRoot;
    }

    public ComponentLifeCycle getLifeCycleInstance(boolean canCreate) throws JBIException {
        if (canCreate && null == this.mComponentInstance) {
            try {
                ClassLoader cl = ClassLoaderFactory.getInstance().createComponentClassLoader(this);
                Object o = cl.loadClass(this.mComponentClassName).newInstance();
                if (!(o instanceof javax.jbi.component.Component)) {
                    String msg = this.mTranslator.getString("COMP_CLASS_NOT_VALID", this.mComponentClassName, "javax.jbi.component.Component");
                    throw new JBIException(msg);
                }
                this.mComponentInstance = (javax.jbi.component.Component)o;
                this.mLifeCycleInstance = this.mComponentInstance.getLifeCycle();
                if (null == this.mLifeCycleInstance) {
                    String msg = this.mTranslator.getString("COMP_INSTANCE_NOT_PROVIDED", "getLifeCycle()", "javax.jbi.component.ComponentLifeCycle");
                    throw new JBIException(msg);
                }
            }
            catch (JBIException jbiEx) {
                throw new JBIException(this.mTranslator.getString("COMP_LIFECYCLE_LOAD_FAILED", this.mName, jbiEx.getMessage()));
            }
            catch (ClassNotFoundException cnfEx) {
                String msg = this.mTranslator.getString("COMP_CLASS_NOT_FOUND", cnfEx.getMessage());
                if (null != cnfEx.getCause()) {
                    this.mLog.log(Level.WARNING, msg, cnfEx.getCause());
                    throw new JBIException(this.mTranslator.getString("COMP_LIFECYCLE_LOAD_FAILED", this.mName, msg), cnfEx.getCause());
                }
                throw new JBIException(this.mTranslator.getString("COMP_LIFECYCLE_LOAD_FAILED", this.mName, msg));
            }
            catch (NoClassDefFoundError ncdfEx) {
                String msg = this.mTranslator.getString("COMP_CLASS_NOT_FOUND", ncdfEx.getMessage());
                if (null != ncdfEx.getCause()) {
                    this.mLog.log(Level.WARNING, msg, ncdfEx.getCause());
                    throw new JBIException(this.mTranslator.getString("COMP_LIFECYCLE_LOAD_FAILED", this.mName, msg), ncdfEx.getCause());
                }
                throw new JBIException(this.mTranslator.getString("COMP_LIFECYCLE_LOAD_FAILED", this.mName, msg));
            }
            catch (Throwable ex) {
                String msg = this.mTranslator.getString("COMP_EXCEPTION", ex.getClass().getName());
                this.mLog.log(Level.WARNING, msg, ex);
                throw new JBIException(this.mTranslator.getString("COMP_LIFECYCLE_LOAD_FAILED", this.mName, msg), ex);
            }
        }
        if (null != this.mComponentInstance) {
            return this.mLifeCycleInstance;
        }
        return null;
    }

    public ObjectName getLifeCycleMBeanName() {
        return this.mLifeCycleMBeanName;
    }

    public ComponentLogger getLoggerInstance() {
        return this.mLoggerInstance;
    }

    public ObjectName getLoggerMBeanName() {
        return this.mLoggerMBeanName;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public List<String> getServiceAssemblyNames() {
        ArrayList<String> saNames = new ArrayList<String>();
        for (ServiceUnit su : this.mServiceUnitList.values()) {
            String saName = su.getServiceAssemblyName();
            if (saNames.contains(saName)) continue;
            saNames.add(su.getServiceAssemblyName());
        }
        return saNames;
    }

    public ServiceUnit getServiceUnit(String serviceUnitName) {
        return (ServiceUnit)this.mServiceUnitList.get(serviceUnitName);
    }

    @Override
    public List<ServiceUnitInfo> getServiceUnitList() {
        return new ArrayList<ServiceUnitInfo>(this.mServiceUnitList.values());
    }

    public ServiceUnitManager getServiceUnitManager() {
        if (null == this.mSUManagerInstance && null != this.mComponentInstance) {
            this.mSUManagerInstance = this.mComponentInstance.getServiceUnitManager();
        }
        return this.mSUManagerInstance;
    }

    @Override
    public List<String> getSharedLibraryNames() {
        return this.mSharedLibraryNames;
    }

    public ComponentStatistics getStatisticsInstance() {
        return this.mStatisticsInstance;
    }

    public ObjectName getStatisticsMBeanName() {
        return this.mStatisticsMBeanName;
    }

    @Override
    public ComponentState getStatus() {
        return this.mComponentState;
    }

    public String getStatusAsString() {
        return this.mComponentState.toString();
    }

    public String getStatusAsString(ComponentState status) {
        if (status == ComponentState.SHUTDOWN) {
            return this.mTranslator.getString("COMP_STATE_SHUTDOWN");
        }
        if (status == ComponentState.LOADED) {
            return this.mTranslator.getString("COMP_STATE_LOADED");
        }
        if (status == ComponentState.STARTED) {
            return this.mTranslator.getString("COMP_STATE_STARTED");
        }
        if (status == ComponentState.STOPPED) {
            return this.mTranslator.getString("COMP_STATE_STOPPED");
        }
        return this.mTranslator.getString("UNKNOWN");
    }

    @Override
    public String getWorkspaceRoot() {
        return this.mWorkspaceRoot;
    }

    @Override
    public String getInstallationDescriptor() {
        ComponentInfo ci;
        if (null == this.mJbiXmlString && null != (ci = EnvironmentContext.getInstance().getComponentQuery().getComponentInfo(this.mName))) {
            this.mJbiXmlString = ci.getInstallationDescriptor();
        }
        return this.mJbiXmlString;
    }

    public ComponentDescriptor getInstallationDescriptorModel() {
        return this.getInstallationDescriptorModel(false);
    }

    public ComponentDescriptor getInstallationDescriptorModel(boolean refreshFlag) {
        Registry reg;
        if (refreshFlag) {
            this.mJbiXmlModel = null;
        }
        if (null == this.mJbiXmlModel && null != (reg = (Registry)EnvironmentContext.getInstance().getRegistry())) {
            try {
                this.mJbiXmlModel = reg.getGenericQuery().getComponentDescriptor(this.mName);
            }
            catch (Throwable ex) {
                this.mLog.log(Level.FINE, "Unable to get installation descriptor for " + this.mName, ex);
            }
        }
        return this.mJbiXmlModel;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode += this.mName.hashCode();
        hashCode += this.mComponentType.hashCode();
        hashCode += this.mBootstrapClassName.hashCode();
        hashCode += this.mBootstrapClassPathElements.hashCode();
        hashCode += this.mComponentClassName.hashCode();
        hashCode += this.mComponentClassPathElements.hashCode();
        if (null != this.mSharedLibraryNames) {
            hashCode += this.mSharedLibraryNames.hashCode();
        }
        return hashCode;
    }

    public boolean isBinding() {
        return this.mComponentType == ComponentType.BINDING;
    }

    public boolean isBusy() {
        return this.mBusy;
    }

    public boolean isBootstrapCleanUpNeeded() {
        return this.mBootstrapCleanUpNeeded;
    }

    @Override
    public boolean isBootstrapClassLoaderSelfFirst() {
        return this.mBootstrapClassLoaderSelfFirst;
    }

    public boolean isComponentClassLoaderSelfFirst() {
        return this.mComponentClassLoaderSelfFirst;
    }

    public boolean isEngine() {
        return ComponentType.ENGINE == this.mComponentType;
    }

    public boolean isInitialized() {
        return ComponentState.STOPPED == this.mComponentState;
    }

    public boolean isInstalled() {
        return ComponentState.SHUTDOWN == this.mComponentState;
    }

    public boolean isLoaded() {
        return ComponentState.LOADED == this.mComponentState;
    }

    public boolean isObserver() {
        if (null == this.mObserver) {
            Element obs;
            this.setObserver(false);
            ComponentDescriptor cd = this.getInstallationDescriptorModel();
            if (null != cd && null != (obs = cd.getComponentObserverXml()) && null != obs.getElementsByTagNameNS(OBSERVER_NS, OBSERVER_TAG)) {
                this.mLog.fine(this.mName + " is an NMR Observer");
                this.setObserver(true);
            }
        }
        return this.mObserver;
    }

    public boolean isServiceUnitRegistered(String serviceUnitName) {
        return this.mServiceUnitList.containsKey(serviceUnitName);
    }

    public boolean isShutDown() {
        return ComponentState.SHUTDOWN == this.mComponentState;
    }

    public boolean isStarted() {
        return ComponentState.STARTED == this.mComponentState;
    }

    public boolean isStopped() {
        return ComponentState.STOPPED == this.mComponentState;
    }

    public boolean isUpdating() {
        return this.mUpdating;
    }

    public void removeServiceUnit(String serviceUnitName) throws JBIException {
        if (!this.mServiceUnitList.containsKey(serviceUnitName)) {
            String msg = this.mTranslator.getString("SU_NOT_FOUND", serviceUnitName, this.getComponentTypeAsString(), this.getName());
            throw new JBIException(msg);
        }
        this.mServiceUnitList.remove(serviceUnitName);
    }

    public void setBootstrapCleanUpNeeded(boolean isCleanUpNeeded) {
        this.mBootstrapCleanUpNeeded = isCleanUpNeeded;
    }

    public void setBootstrapClassLoaderSelfFirst(boolean isSelfFirst) {
        this.mBootstrapClassLoaderSelfFirst = isSelfFirst;
    }

    public void setBootstrapClassName(String className) {
        this.mBootstrapClassName = className;
    }

    public void setBootstrapClassPathElements(List classPathElements) {
        this.mBootstrapClassPathElements = new ArrayList(classPathElements);
    }

    public synchronized void setBusy() throws JBIException {
        if (this.mBusy) {
            throw new JBIException(this.mTranslator.getString("COMP_BUSY", this.mName));
        }
        this.mBusy = true;
    }

    public void setBusyForce() {
        this.mBusy = true;
    }

    public void setComponentClassLoaderSelfFirst(boolean isSelfFirst) {
        this.mComponentClassLoaderSelfFirst = isSelfFirst;
    }

    public void setInstallRoot(String installRoot) {
        this.mInstallRoot = null != installRoot ? installRoot.replace('\\', '/') : installRoot;
    }

    public void setComponentType(ComponentType type) {
        this.mComponentType = type;
    }

    public void setComponentTypeBinding() {
        this.mComponentType = ComponentType.BINDING;
    }

    public void setComponentTypeEngine() {
        this.mComponentType = ComponentType.ENGINE;
    }

    public void setDeployerInstance(Deployer deployer) {
        this.mDeployerInstance = deployer;
    }

    public void setDesiredState(ComponentState state) {
        if (ComponentState.SHUTDOWN != state && ComponentState.STOPPED != state && ComponentState.STARTED != state) {
            throw new IllegalArgumentException(this.mTranslator.getString("INVALID_ARGUMENT", "state", state.toString()));
        }
        this.mDesiredState = state;
    }

    public void setStatus(ComponentState status) {
        this.mComponentState = status;
    }

    public void setLoaded() {
        if (this.isStopped()) {
            throw new IllegalStateException(this.mTranslator.getString("COMP_INVALID_STATE_CHANGE", this.mTranslator.getString("COMP_STATE_STOPPED"), this.mTranslator.getString("COMP_STATE_LOADED")));
        }
        if (this.isStarted()) {
            throw new IllegalStateException(this.mTranslator.getString("COMP_INVALID_STATE_CHANGE", this.mTranslator.getString("COMP_STATE_STARTED"), this.mTranslator.getString("COMP_STATE_LOADED")));
        }
        this.mComponentState = ComponentState.LOADED;
    }

    public void setComponentClassName(String className) {
        if (null != className) {
            this.mComponentClassName = className;
        }
    }

    public void setComponentInstance(javax.jbi.component.Component classInstance) {
        if (null != classInstance) {
            this.mComponentInstance = classInstance;
            this.mLifeCycleInstance = classInstance.getLifeCycle();
        }
    }

    public void setComponentClassPathElements(List classPathElements) {
        if (null != classPathElements) {
            this.mComponentClassPathElements = new ArrayList(classPathElements);
        }
    }

    public void setConfigurationMBeanName(ObjectName objectName) {
        this.mConfigMBeanName = objectName;
    }

    public void setContext(ComponentContext context) {
        this.mContext = context;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public void setDeployerMBeanName(ObjectName objectName) {
        this.mDeployerMBeanName = objectName;
    }

    public void setExtensionMBeanName(ObjectName objectName) {
        this.mExtensionMBeanName = objectName;
    }

    public void setInstallerMBeanName(ObjectName objectName) {
        this.mInstallerMBeanName = objectName;
    }

    public void setLifeCycleMBeanName(ObjectName objectName) {
        this.mLifeCycleMBeanName = objectName;
    }

    public void setLoggerInstance(ComponentLogger instance) {
        this.mLoggerInstance = instance;
    }

    public void setLoggerMBeanName(ObjectName objectName) {
        this.mLoggerMBeanName = objectName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setObserver(boolean isObserver) {
        this.mObserver = isObserver;
    }

    public void setSharedLibraryNames(List<String> nameList) {
        if (null != nameList) {
            this.mSharedLibraryNames = new ArrayList<String>(nameList);
        }
    }

    public void setShutdown() {
        if (this.isLoaded()) {
            this.mBootstrapInstance = null;
        } else {
            if (this.isStarted()) {
                throw new IllegalStateException(this.mTranslator.getString("COMP_INVALID_STATE_CHANGE", this.mTranslator.getString("COMP_STATE_STARTED"), this.mTranslator.getString("COMP_STATE_SHUTDOWN")));
            }
            if (this.isStopped()) {
                this.mComponentInstance = null;
            }
        }
        this.mComponentState = ComponentState.SHUTDOWN;
    }

    public void setStarted() {
        if (this.isLoaded()) {
            throw new IllegalStateException(this.mTranslator.getString("COMP_INVALID_STATE_CHANGE", this.mTranslator.getString("COMP_STATE_LOADED"), this.mTranslator.getString("COMP_STATE_STARTED")));
        }
        if (this.isShutDown()) {
            throw new IllegalStateException(this.mTranslator.getString("COMP_INVALID_STATE_CHANGE", this.mTranslator.getString("COMP_STATE_SHUTDOWN"), this.mTranslator.getString("COMP_STATE_STARTED")));
        }
        this.mComponentState = ComponentState.STARTED;
    }

    public void setStatisticsInstance(ComponentStatistics classInstance) {
        if (null != classInstance) {
            this.mStatisticsInstance = classInstance;
        }
    }

    public void setStatisticsMBeanName(ObjectName objectName) {
        this.mStatisticsMBeanName = objectName;
    }

    public void setStopped() {
        if (this.isLoaded()) {
            throw new IllegalStateException(this.mTranslator.getString("COMP_INVALID_STATE_CHANGE", this.mTranslator.getString("COMP_STATE_LOADED"), this.mTranslator.getString("COMP_STATE_STOPPED")));
        }
        this.mComponentState = ComponentState.STOPPED;
    }

    public void setUpdating() throws JBIException {
        this.setBusy();
        this.mUpdating = true;
    }

    public void setWorkspaceRoot(String workspaceRoot) {
        this.mWorkspaceRoot = null != workspaceRoot ? workspaceRoot.replace('\\', '/') : workspaceRoot;
    }

    public void setInstallationDescriptor(String jbiXml) {
        this.mJbiXmlString = jbiXml;
    }

    public String toString() {
        String sep = ",\n";
        StringBuffer b = new StringBuffer();
        b.append("Component Name = " + this.mName);
        b.append(sep);
        b.append("ComponentType = " + this.mComponentType.toString());
        b.append(" (" + this.getComponentTypeAsString() + ")");
        b.append(sep);
        b.append("Description = " + (null != this.mDescription ? this.mDescription : ""));
        b.append(sep);
        b.append("State = " + (Object)((Object)this.mComponentState));
        b.append(" (" + this.getStatusAsString(this.mComponentState) + ")");
        b.append(sep);
        b.append("Desired State = " + this.mDesiredState.toString());
        b.append(" (" + this.mDesiredState.toString() + ")");
        b.append(sep);
        b.append("InstallRoot = " + (null != this.mInstallRoot ? this.mInstallRoot : ""));
        b.append(sep);
        b.append("WorkspaceRoot = " + (null != this.mWorkspaceRoot ? this.mWorkspaceRoot : ""));
        b.append(sep);
        b.append("BootstrapClassName = " + (null != this.mBootstrapClassName ? this.mBootstrapClassName : ""));
        b.append(sep);
        b.append("BootstrapClassPathElements = " + (null != this.mBootstrapClassPathElements ? this.mBootstrapClassPathElements : new ArrayList()));
        b.append(sep);
        b.append("BootstrapClassLoaderSelfFirst = " + this.mBootstrapClassLoaderSelfFirst);
        b.append(sep);
        b.append("ComponentClassName = " + (null != this.mComponentClassName ? this.mComponentClassName : ""));
        b.append(sep);
        b.append("ComponentClassPathElements = " + (null != this.mComponentClassPathElements ? this.mComponentClassPathElements : new ArrayList()));
        b.append(sep);
        b.append("ComponentClassLoaderSelfFirst = " + this.mComponentClassLoaderSelfFirst);
        b.append(sep);
        b.append("ServiceUnitList = " + (null != this.mServiceUnitList ? this.mServiceUnitList : new Hashtable()));
        b.append(sep);
        b.append("SharedLibraryNames = " + (null != this.mSharedLibraryNames ? this.mSharedLibraryNames : new ArrayList()));
        return b.toString();
    }

    @Override
    public boolean isClassLoaderSelfFirst() {
        return this.mComponentClassLoaderSelfFirst;
    }

    public Map getProperties() {
        return new HashMap();
    }
}

