/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.ComponentManager;
import com.sun.jbi.ComponentState;
import com.sun.jbi.EventNotifierBase;
import com.sun.jbi.ServiceLifecycle;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.component.InstallationContext;
import com.sun.jbi.framework.ClassLoaderFactory;
import com.sun.jbi.framework.Component;
import com.sun.jbi.framework.ComponentConfiguration;
import com.sun.jbi.framework.ComponentContext;
import com.sun.jbi.framework.ComponentInstaller;
import com.sun.jbi.framework.ComponentLifeCycle;
import com.sun.jbi.framework.ComponentLifeCycleMBean;
import com.sun.jbi.framework.ComponentLogger;
import com.sun.jbi.framework.ComponentLoggerMBean;
import com.sun.jbi.framework.ComponentOperation;
import com.sun.jbi.framework.ComponentRegistry;
import com.sun.jbi.framework.ComponentStartup;
import com.sun.jbi.framework.ComponentStatistics;
import com.sun.jbi.framework.Deployer;
import com.sun.jbi.framework.DeployerMBean;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.FrameworkWarningException;
import com.sun.jbi.framework.OperationCounter;
import com.sun.jbi.framework.ServiceUnit;
import com.sun.jbi.framework.ServiceUnitFramework;
import com.sun.jbi.framework.SharedLibrary;
import com.sun.jbi.framework.StringTranslator;
import com.sun.jbi.management.InstallerMBean;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.Updater;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.system.ManagementService;
import com.sun.jbi.messaging.DeliveryChannel;
import com.sun.jbi.monitoring.ComponentStatisticsMBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentFramework
implements ComponentManager,
ServiceLifecycle {
    private EnvironmentContext mContext;
    private ClassLoaderFactory mClassLoaderFactory;
    private ComponentRegistry mCompReg;
    private ServiceUnitFramework mSUFramework;
    private Logger mLog;
    private Boolean mStarted = null;
    private StringTranslator mTranslator;
    private Updater mUpdater;
    private String mBinding;
    private String mComponent;
    private String mEngine;
    private int mStartupState;
    public static final int PREPARE = 1;
    public static final int START = 2;
    private static final long TIMEOUT_DEFAULT = 240000L;

    @Override
    public void initService(com.sun.jbi.EnvironmentContext context) throws JBIException {
        if (null != this.mStarted) {
            throw new IllegalStateException(this.mTranslator.getString("SERVICE_ALREADY_INITIALIZED", this.mTranslator.getString("CF_NAME")));
        }
        this.mContext = (EnvironmentContext)context;
        this.mCompReg = this.mContext.getComponentRegistry();
        this.mClassLoaderFactory = ClassLoaderFactory.getInstance();
        this.mSUFramework = new ServiceUnitFramework(this.mContext);
        this.mLog = this.mContext.getLogger();
        this.mTranslator = (StringTranslator)this.mContext.getStringTranslatorFor(this);
        this.mBinding = this.mTranslator.getString("BINDING");
        this.mComponent = this.mTranslator.getString("COMPONENT");
        this.mEngine = this.mTranslator.getString("ENGINE");
        this.mStarted = Boolean.FALSE;
        this.mLog.fine(this.mTranslator.getString("SERVICE_INITIALIZED", this.mTranslator.getString("CF_NAME")));
    }

    @Override
    public void startService() throws JBIException {
        if (this.mStarted.booleanValue()) {
            throw new IllegalStateException(this.mTranslator.getString("SERVICE_ALREADY_STARTED", this.mTranslator.getString("CR_NAME")));
        }
        this.mStarted = Boolean.TRUE;
        this.mLog.fine(this.mTranslator.getString("SERVICE_STARTED", this.mTranslator.getString("CF_NAME")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService() throws JBIException {
        if (!this.mStarted.booleanValue()) {
            this.mLog.warning(this.mTranslator.getString("SERVICE_ALREADY_STOPPED", this.mTranslator.getString("CF_NAME")));
            return;
        }
        this.mStarted = Boolean.FALSE;
        long timeOut = this.mContext.getComponentTimeout();
        List comps = this.mCompReg.getAllComponents();
        ListIterator c = comps.listIterator();
        Component comp = null;
        this.mLog.fine(this.mTranslator.getString("CF_STOPPING_ALL"));
        ArrayList<ComponentOperation> shutdowns = new ArrayList<ComponentOperation>();
        OperationCounter oc = new OperationCounter();
        while (c.hasNext()) {
            comp = (Component)c.next();
            if (!comp.isStarted() && !comp.isStopped()) continue;
            ComponentOperation shutdown = new ComponentOperation(oc, comp, 3);
            shutdowns.add(shutdown);
            new Thread((Runnable)shutdown, comp.getName()).start();
        }
        if (0 < shutdowns.size()) {
            OperationCounter operationCounter = oc;
            synchronized (operationCounter) {
                try {
                    if (0 < oc.getValue()) {
                        oc.wait(timeOut);
                    }
                }
                catch (InterruptedException iEx) {
                    this.mLog.warning(this.mTranslator.getString("CF_SHUTDOWN_INTERRUPTED"));
                }
            }
            for (ComponentOperation shutdown : shutdowns) {
                if (shutdown.completed()) continue;
                comp = shutdown.getComponent();
                shutdown.getThread().interrupt();
                this.mLog.warning(this.mTranslator.getString("CF_COMP_SHUTDOWN_TIMEOUT", comp.getComponentTypeAsString(), comp.getName(), new Long(timeOut)));
            }
        }
        this.mLog.fine(this.mTranslator.getString("SERVICE_STOPPED", this.mTranslator.getString("CF_NAME")));
    }

    @Override
    public javax.jbi.component.Component getComponentInstance(String componentName) {
        Component comp = this.mCompReg.getComponent(componentName);
        if (null != comp) {
            return comp.getComponentInstance();
        }
        return null;
    }

    @Override
    public DeployerMBean getDeployerInstance(String componentName) {
        Deployer deployer = null;
        Component comp = this.mCompReg.getComponent(componentName);
        if (null != comp) {
            deployer = comp.getDeployerInstance();
        }
        return deployer;
    }

    @Override
    public synchronized void installSharedLibrary(String name, String description, String componentRoot, boolean isSelfFirst, List elements) throws JBIException {
        if (null == name) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "name"));
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_STRING_ARGUMENT", "name"));
        }
        if (null == componentRoot) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "componentRoot"));
        }
        if (0 == componentRoot.length()) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_STRING_ARGUMENT", "componentRoot"));
        }
        if (null == elements) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "elements"));
        }
        if (0 == elements.size()) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_LIST_ARGUMENT", "elements"));
        }
        if (this.mCompReg.isSharedLibraryRegistered(name)) {
            throw new JBIException(this.mTranslator.getString("CF_SL_ALREADY_REGISTERED", name));
        }
        SharedLibrary sl = new SharedLibrary(name, description, componentRoot, isSelfFirst, elements);
        try {
            this.mClassLoaderFactory.createSharedClassLoader(sl);
            this.mLog.fine("Created class loader for Shared Library " + name + " with class path " + sl.getClassPathAsString());
        }
        catch (JBIException jbiEx) {
            throw new JBIException(this.mTranslator.getString("CF_SL_INSTALL_FAILED", name), (Throwable)jbiEx);
        }
        this.mCompReg.registerSharedLibrary(sl);
        String installMsg = this.mTranslator.getString("CF_SL_INSTALL_SUCCESSFUL", name);
        this.mLog.info(installMsg);
        this.mContext.getNotifier().emitComponentNotification(EventNotifierBase.EventType.Installed, EventNotifierBase.SourceType.SharedLibrary, name, installMsg);
    }

    @Override
    public synchronized ObjectName loadBootstrap(InstallationContext installContext, String bootClassName, List bootClassPathElements, List sharedLibraryNames, boolean force) throws JBIException {
        if (null == installContext) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "installContext"));
        }
        if (null == bootClassName) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "bootClassName"));
        }
        if (null == bootClassPathElements) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "bootClassPathElements"));
        }
        if (0 == bootClassName.length()) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_STRING_ARGUMENT", "bootClassName"));
        }
        if (0 == bootClassPathElements.size()) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_LIST_ARGUMENT", "bootClassPathElements"));
        }
        String msg = null;
        String componentName = installContext.getComponentName();
        String componentType = installContext.isBinding() ? this.mBinding : this.mEngine;
        this.mLog.fine("Loading bootstrap for " + componentType + " " + componentName + " with force=" + force);
        Component comp = this.mCompReg.getComponent(componentName);
        boolean existed = false;
        if (installContext.isInstall()) {
            msg = this.mTranslator.getString("CF_COMP_INSTALL_FAILED", componentType, componentName) + " ";
            if (null == comp) {
                comp = new Component();
            } else {
                if (!comp.isLoaded()) {
                    throw new JBIException(msg + this.mTranslator.getString("CF_COMP_ALREADY_REGISTERED", comp.getComponentTypeAsString()));
                }
                existed = true;
                comp.clearBootstrapInstance();
                comp.clearLifeCycleInstance();
            }
            this.initComponent(comp, installContext, bootClassName, bootClassPathElements, sharedLibraryNames);
            this.checkSharedLibraries(comp);
        } else {
            msg = this.mTranslator.getString("CF_COMP_UNINSTALL_FAILED", componentType, componentName) + " ";
            if (null == comp || comp.isLoaded()) {
                throw new JBIException(msg + this.mTranslator.getString("CF_COMP_NOT_INSTALLED"));
            }
        }
        ObjectName instMBeanName = this.initBootstrap(comp, msg, installContext, force);
        if (installContext.isInstall() && !existed) {
            this.mCompReg.registerComponent(comp);
        }
        this.mLog.fine("Bootstrap for " + componentType + " " + componentName + " has been loaded");
        return instMBeanName;
    }

    @Override
    public void uninstallSharedLibrary(String sharedLibraryName) throws JBIException {
        String dependents;
        SharedLibrary sl = this.mCompReg.getSharedLibrary(sharedLibraryName);
        if (null == sl) {
            throw new JBIException(this.mTranslator.getString("CF_SL_UNINSTALL_NONEXISTENT", sharedLibraryName));
        }
        try {
            dependents = this.checkForActiveDependents(sharedLibraryName);
        }
        catch (JBIException ex) {
            throw new JBIException(this.mTranslator.getString("CF_SL_UNINSTALL_FAILED_DEPENDENTS", sharedLibraryName), (Throwable)ex);
        }
        try {
            this.mClassLoaderFactory.removeSharedClassLoader(sharedLibraryName);
        }
        catch (JBIException ex) {
            this.mLog.info(this.mTranslator.getString("CF_SL_UNINSTALL_CLASSLOADER", ex.toString()));
        }
        this.mCompReg.unregisterSharedLibrary(sharedLibraryName);
        String uninstallMsg = dependents.length() > 0 ? this.mTranslator.getString("CF_SL_UNINSTALL_OK_DEPENDENTS", sharedLibraryName, dependents) : this.mTranslator.getString("CF_SL_UNINSTALL_SUCCESSFUL", sharedLibraryName);
        this.mLog.info(uninstallMsg);
        this.mContext.getNotifier().emitComponentNotification(EventNotifierBase.EventType.Uninstalled, EventNotifierBase.SourceType.SharedLibrary, sharedLibraryName, uninstallMsg);
        if (dependents.length() > 0) {
            throw new FrameworkWarningException(uninstallMsg);
        }
    }

    @Override
    public void unloadBootstrap(String componentName) throws JBIException {
        Bootstrap bootInstance;
        if (null == componentName) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "componentName"));
        }
        if (0 == componentName.length()) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_STRING_ARGUMENT", "componentName"));
        }
        Component comp = this.mCompReg.getComponent(componentName);
        if (null == comp) {
            this.mLog.finer("Component " + componentName + " is not present in the component cache, nothing to unload");
            return;
        }
        MBeanServer mbs = this.mContext.getMBeanServer();
        ObjectName instMBeanName = comp.getInstallerMBeanName();
        if (null != mbs && null != instMBeanName) {
            try {
                if (mbs.isRegistered(instMBeanName)) {
                    this.mLog.fine("Unregistering installer MBean" + instMBeanName);
                    mbs.unregisterMBean(instMBeanName);
                    comp.setInstallerMBeanName(null);
                }
            }
            catch (InstanceNotFoundException infEx) {
                this.mLog.warning(infEx.getMessage());
            }
            catch (MBeanRegistrationException mbrEx) {
                this.mLog.warning(mbrEx.getMessage());
            }
        }
        if (null != (bootInstance = comp.getBootstrapInstance(false))) {
            try {
                if (comp.isBootstrapCleanUpNeeded()) {
                    bootInstance.cleanUp();
                }
            }
            catch (Throwable ex) {
                String msg = this.mTranslator.getString("CF_BOOTSTRAP_UNLOAD_CLEANUP_FAILED", comp.getComponentTypeAsString(), componentName, ex.getClass().getName()) + this.getExMsg(ex);
                this.mLog.warning(msg);
                this.mLog.warning(this.mTranslator.stackTraceToString(ex));
                throw new JBIException(msg, ex);
            }
            finally {
                comp.clearBootstrapInstance();
                comp.setBootstrapCleanUpNeeded(false);
            }
        }
        if (comp.isLoaded()) {
            this.mCompReg.removeComponent(componentName);
        }
    }

    @Override
    public synchronized void cancelComponentUpgrade(String componentName) throws JBIException {
        if (null == componentName) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "componentName"));
        }
        if (0 == componentName.length()) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_STRING_ARGUMENT", "componentName"));
        }
        Component comp = this.mCompReg.getComponent(componentName);
        if (null == comp) {
            throw new JBIException(this.mTranslator.getString("CF_COMP_UPGRADE_CANCEL_NOT_FOUND", componentName));
        }
        comp.clearUpdating();
    }

    @Override
    public synchronized void upgradeComponent(InstallationContext installContext, String bootClassName, List<String> bootClassPathElements, List<String> sharedLibraryNames) throws JBIException {
        Bootstrap bootInstance;
        if (null == installContext) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "installContext"));
        }
        if (null == bootClassName) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "bootClassName"));
        }
        if (null == bootClassPathElements) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "bootClassPathElements"));
        }
        if (0 == bootClassName.length()) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_STRING_ARGUMENT", "bootClassName"));
        }
        if (0 == bootClassPathElements.size()) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_LIST_ARGUMENT", "bootClassPathElements"));
        }
        String componentName = installContext.getComponentName();
        String componentType = installContext.isBinding() ? this.mBinding : this.mEngine;
        Component comp = this.mCompReg.getComponent(componentName);
        if (null == comp) {
            throw new JBIException(this.mTranslator.getString("CF_COMP_UPGRADE_NOT_FOUND", componentType, componentName));
        }
        comp.clearLifeCycleInstance();
        if (!comp.isUpdating()) {
            throw new JBIException(this.mTranslator.getString("CF_COMP_UPGRADE_NOT_VALIDATED", componentType, componentName));
        }
        Component newComp = new Component();
        this.initComponent(newComp, installContext, bootClassName, bootClassPathElements, sharedLibraryNames);
        newComp.setUpdating();
        this.checkSharedLibraries(newComp);
        try {
            bootInstance = newComp.getBootstrapInstance(true);
        }
        catch (JBIException ex) {
            comp.clearUpdating();
            String msg = this.mTranslator.getString("CF_COMP_UPGRADE_LOAD_FAILED", componentType, componentName, ex.getMessage());
            this.mLog.warning(msg);
            throw new JBIException(msg, (Throwable)ex);
        }
        String msgKey = null;
        try {
            Method upgrade = this.getUpgradeMethod(bootInstance);
            if (null != upgrade) {
                List<ServiceUnitInfo> suList = comp.getServiceUnitList();
                ArrayList<String> suRoots = new ArrayList<String>(0);
                for (ServiceUnitInfo su : suList) {
                    suRoots.add(su.getFilePath());
                }
                Object[] params = new Object[]{newComp.getWorkspaceRoot(), suRoots};
                upgrade.invoke((Object)bootInstance, params);
                msgKey = "CF_COMP_UPGRADE_COMPLETE";
            } else {
                msgKey = "CF_COMP_UPDATE_COMPLETE";
            }
        }
        catch (InvocationTargetException itEx) {
            Throwable compEx = itEx.getTargetException();
            throw new JBIException(this.mTranslator.getString("CF_COMP_UPGRADE_FAILED", componentType, componentName, compEx.getClass().getName(), compEx.getMessage()), compEx);
        }
        catch (IllegalAccessException iaEx) {
            String msg = this.mTranslator.getString("CF_COMP_UPGRADE_ILLEGAL_ACCESS", componentType, componentName);
            this.mLog.log(Level.WARNING, msg, iaEx);
            throw new JBIException(msg, (Throwable)iaEx);
        }
        finally {
            comp.clearUpdating();
            newComp.clearBootstrapInstance();
        }
        this.initComponent(comp, installContext, bootClassName, bootClassPathElements, sharedLibraryNames);
        comp.setShutdown();
        comp.clearLifeCycleInstance();
        comp.getLoggerInstance().getLoggerDefs(true);
        String installMsg = this.mTranslator.getString(msgKey, componentType, componentName);
        this.mLog.info(installMsg);
        this.mContext.getNotifier().emitComponentNotification(EventNotifierBase.EventType.Upgraded, comp.isBinding() ? EventNotifierBase.SourceType.BindingComponent : EventNotifierBase.SourceType.ServiceEngine, componentName, installMsg);
    }

    public synchronized boolean validateComponentForUpgrade(InstallationContext installContext, String bootClassName, List bootClassPathElements, List sharedLibraryNames) throws JBIException {
        if (null == installContext) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "installContext"));
        }
        if (null == bootClassName) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "bootClassName"));
        }
        if (0 == bootClassName.length()) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_STRING_ARGUMENT", "bootClassName"));
        }
        if (null == bootClassPathElements) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "bootClassPathElements"));
        }
        if (0 == bootClassPathElements.size()) {
            throw new IllegalArgumentException(this.mTranslator.getString("EMPTY_LIST_ARGUMENT", "bootClassPathElements"));
        }
        String componentName = installContext.getComponentName();
        String componentType = installContext.isBinding() ? this.mBinding : this.mEngine;
        Component comp = this.mCompReg.getComponent(componentName);
        if (null == comp) {
            throw new JBIException(this.mTranslator.getString("CF_COMP_UPGRADE_NOT_FOUND", componentType, componentName));
        }
        comp.setUpdating();
        this.mLog.fine("Validating " + componentType + " " + componentName + " for upgrade");
        if (!comp.isShutDown()) {
            comp.clearUpdating();
            throw new JBIException(this.mTranslator.getString("CF_COMP_UPGRADE_NOT_SHUT_DOWN", componentType, componentName));
        }
        Component newComp = new Component();
        this.initComponent(newComp, installContext, bootClassName, bootClassPathElements, sharedLibraryNames);
        newComp.setUpdating();
        this.checkSharedLibraries(newComp);
        boolean supportsUpgrade = false;
        try {
            Bootstrap bootInstance = newComp.getBootstrapInstance(true);
            javax.jbi.component.ComponentLifeCycle lifeInstance = newComp.getLifeCycleInstance(true);
            if (null != this.getUpgradeMethod(bootInstance)) {
                supportsUpgrade = true;
            }
        }
        catch (JBIException ex) {
            comp.clearUpdating();
            this.mLog.warning(this.mTranslator.getString("CF_COMP_UPGRADE_VALIDATE_FAILED", componentType, componentName));
            this.mLog.warning(ex.getMessage());
            throw ex;
        }
        finally {
            newComp.clearBootstrapInstance();
            newComp.clearLifeCycleInstance();
        }
        return supportsUpgrade;
    }

    ObjectName getInstallerConfigurationMBeanName(String componentName) throws JBIException {
        Component comp = this.mCompReg.getComponent(componentName);
        if (null == comp) {
            throw new JBIException(this.mTranslator.getString("CF_COMP_NOT_FOUND", componentName));
        }
        return comp.getExtensionMBeanName();
    }

    Logger getLogger() {
        return this.mLog;
    }

    void initializeComponent(Component comp) throws JBIException {
        javax.jbi.component.ComponentLifeCycle compInstance = comp.getLifeCycleInstance(true);
        this.initializeComponent(comp, compInstance, false);
    }

    void initializeComponent(Component comp, javax.jbi.component.ComponentLifeCycle compInstance, boolean fromClient) throws JBIException {
        this.mLog.fine("Initializing " + comp.getComponentTypeAsString() + " " + comp.getName());
        ComponentContext context = new ComponentContext(comp, this.mContext);
        comp.setContext(context);
        context.getDeliveryChannel(true);
        ComponentStatistics stats = comp.getStatisticsInstance();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ClassLoaderFactory.getInstance().getComponentClassLoader(comp.getName()));
        try {
            if (stats.isEnabled()) {
                stats.incrementInitRequests();
            }
            compInstance.init((javax.jbi.component.ComponentContext)context);
        }
        catch (Throwable ex) {
            if (stats.isEnabled()) {
                stats.incrementFailedRequests();
            }
            String msg = fromClient ? this.mTranslator.getString("CF_COMP_INITIALIZATION_FAILED_EXCEPTION", comp.getComponentTypeAsString(), comp.getName(), ex.getClass().getName()) : this.mTranslator.getString("CF_COMP_INITIALIZATION_EXCEPTION", comp.getComponentTypeAsString(), comp.getName(), ex.getClass().getName()) + this.getExMsg(ex);
            this.mLog.log(Level.WARNING, msg, ex);
            throw new JBIException(msg, ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        comp.setStopped();
        comp.getDeployerInstance().setServiceUnitManager(comp.getServiceUnitManager());
    }

    synchronized ObjectName installComponent(InstallationContext installContext) throws JBIException {
        if (null == installContext) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "installContext"));
        }
        String componentName = installContext.getComponentName();
        String componentType = installContext.isBinding() ? this.mBinding : this.mEngine;
        String msg = this.mTranslator.getString("CF_COMP_INSTALL_FAILED", componentType, componentName) + " ";
        this.mLog.fine("Installing " + componentType + " " + componentName);
        Component comp = this.mCompReg.getComponent(componentName);
        if (null == comp) {
            throw new JBIException(msg + this.mTranslator.getString("CF_COMP_NOT_LOADED"));
        }
        if (!comp.isLoaded()) {
            throw new JBIException(msg + this.mTranslator.getString("CF_COMP_ALREADY_INSTALLED"));
        }
        this.doInstall(comp, msg, installContext);
        try {
            javax.jbi.component.ComponentLifeCycle lifeInstance = comp.getLifeCycleInstance(true);
        }
        catch (JBIException ex) {
            comp.clearLifeCycleInstance();
            this.mCompReg.removeComponent(componentName);
            this.mLog.warning(msg + ex.getMessage());
            throw new JBIException(msg, (Throwable)ex);
        }
        ObjectName lifeMBeanName = null;
        ComponentLifeCycle lifeMBean = new ComponentLifeCycle(comp, this);
        try {
            lifeMBeanName = this.registerMBean(comp, lifeMBean, ComponentLifeCycleMBean.class, "Lifecycle");
        }
        catch (JBIException ex) {
            comp.clearLifeCycleInstance();
            this.mCompReg.removeComponent(componentName);
            throw new JBIException(msg + this.mTranslator.getString("CF_LIFECYCLE_MBEAN_REGISTRATION_FAILED"), (Throwable)ex);
        }
        comp.setLifeCycleMBeanName(lifeMBeanName);
        comp.setShutdown();
        this.mCompReg.commitComponent(componentName);
        String installMsg = this.mTranslator.getString("CF_COMP_INSTALL_SUCCESSFUL", componentType, componentName);
        this.mLog.info(installMsg);
        this.mContext.getNotifier().emitComponentNotification(EventNotifierBase.EventType.Installed, comp.isBinding() ? EventNotifierBase.SourceType.BindingComponent : EventNotifierBase.SourceType.ServiceEngine, componentName, installMsg);
        try {
            this.createStatisticsMBean(comp);
        }
        catch (JBIException ex) {
            this.mLog.warning(ex.getMessage());
        }
        try {
            this.createDeployerMBean(comp);
        }
        catch (JBIException ex) {
            this.mLog.warning(ex.getMessage());
        }
        try {
            this.createLoggerMBean(comp);
        }
        catch (JBIException ex) {
            this.mLog.warning(ex.getMessage());
        }
        try {
            this.createConfigurationMBean(comp);
        }
        catch (JBIException ex) {
            this.mLog.warning(ex.getMessage());
        }
        comp.clearLifeCycleInstance();
        return lifeMBeanName;
    }

    void prepare() {
        this.startupAll(1);
    }

    void ready(boolean wait) {
        if (wait) {
            this.startupAll(2);
        } else {
            ComponentStartup cs = new ComponentStartup(this, 2);
            Thread t = new Thread((Runnable)cs, "ComponentStartup");
            t.start();
        }
    }

    void startupAll(int command) {
        List compList = this.mCompReg.getAllComponents();
        if (command == 1 || this.mStartupState == 0 && command == 2) {
            this.mStartupState = command;
            List sLibList = this.mCompReg.getAllSharedLibraries();
            ListIterator s = sLibList.listIterator();
            SharedLibrary sl = null;
            while (s.hasNext()) {
                sl = (SharedLibrary)s.next();
                try {
                    this.mClassLoaderFactory.createSharedClassLoader(sl);
                }
                catch (JBIException jbiEx) {
                    this.mLog.severe(this.mTranslator.getString("CF_SL_CLASSLOADER_CREATION_FAILED", sl.getName(), jbiEx.getMessage()));
                }
            }
            this.createAllInstances(compList);
            this.createAllLifeCycleMBeans(compList);
            this.createAllOtherMBeans(compList);
        }
        if (command == 1) {
            this.prepareComponents(compList);
        } else {
            this.startComponents(compList);
        }
    }

    void shutdownComponent(Component comp) throws JBIException {
        this.shutdownComponent(comp, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownComponent(Component comp, boolean force, boolean fromClient) throws JBIException {
        String componentName = comp.getName();
        String componentType = comp.getComponentTypeAsString();
        javax.jbi.component.ComponentLifeCycle compInstance = comp.getLifeCycleInstance(false);
        ComponentStatistics stats = comp.getStatisticsInstance();
        if (comp.isStarted()) {
            this.mSUFramework.stopServiceUnits(comp);
            String stopMsg = this.mTranslator.getString("CF_COMP_STOP_SUCCESSFUL", componentType, componentName);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                this.mLog.fine("Stopping " + componentType + " " + componentName);
                if (stats.isEnabled()) {
                    stats.incrementStopRequests();
                }
                Thread.currentThread().setContextClassLoader(ClassLoaderFactory.getInstance().getComponentClassLoader(comp.getName()));
                compInstance.stop();
                this.mLog.info(stopMsg);
            }
            catch (Throwable ex) {
                if (stats.isEnabled()) {
                    stats.incrementFailedRequests();
                }
                String msg = fromClient ? this.mTranslator.getString("CF_LIFECYCLE_STOP_EXCEPTION", componentType, componentName, ex.getClass().getName()) : this.mTranslator.getString("CF_LIFECYCLE_STOP_FAILED", componentType, componentName, ex.getClass().getName()) + this.getExMsg(ex);
                this.mLog.log(Level.WARNING, msg, ex);
                if (!force) {
                    throw new JBIException(msg, ex);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            comp.setStopped();
            this.mContext.getNotifier().emitComponentNotification(EventNotifierBase.EventType.Stopped, comp.isBinding() ? EventNotifierBase.SourceType.BindingComponent : EventNotifierBase.SourceType.ServiceEngine, componentName, stopMsg);
        }
        if (comp.isStopped()) {
            this.mSUFramework.shutDownServiceUnits(comp);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                this.mLog.fine("Shutting down " + componentType + " " + componentName);
                if (stats.isEnabled()) {
                    stats.incrementShutDownRequests();
                }
                Thread.currentThread().setContextClassLoader(ClassLoaderFactory.getInstance().getComponentClassLoader(comp.getName()));
                compInstance.shutDown();
            }
            catch (Throwable ex) {
                if (stats.isEnabled()) {
                    stats.incrementFailedRequests();
                }
                String msg = fromClient ? this.mTranslator.getString("CF_LIFECYCLE_SHUTDOWN_EXCEPTION", componentType, componentName, ex.getClass().getName()) : this.mTranslator.getString("CF_LIFECYCLE_SHUTDOWN_FAILED", componentType, componentName, ex.getClass().getName()) + this.getExMsg(ex);
                this.mLog.log(Level.WARNING, msg, ex);
                if (!force) {
                    throw new JBIException(msg, ex);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            comp.setShutdown();
            comp.clearLifeCycleInstance();
            ComponentContext ctx = comp.getContext();
            if (null != ctx) {
                javax.jbi.messaging.DeliveryChannel dc = ctx.getDeliveryChannel(false);
                if (null != dc) {
                    dc.close();
                }
                comp.setContext(null);
            }
            String shutDownMsg = !force ? this.mTranslator.getString("CF_COMP_SHUTDOWN_SUCCESSFUL", componentType, componentName) : this.mTranslator.getString("CF_COMP_SHUTDOWN_FORCED", componentType, componentName);
            this.mLog.info(shutDownMsg);
            this.mContext.getNotifier().emitComponentNotification(EventNotifierBase.EventType.ShutDown, comp.isBinding() ? EventNotifierBase.SourceType.BindingComponent : EventNotifierBase.SourceType.ServiceEngine, componentName, shutDownMsg);
        } else {
            if (comp.isLoaded()) {
                throw new JBIException(this.mTranslator.getString("CF_COMP_CANNOT_SHUTDOWN", componentType, componentName));
            }
            this.mLog.fine("Shutdown of " + componentType + " " + componentName + " ignored, already shut down");
        }
    }

    void startComponent(Component comp) throws JBIException {
        this.startComponent(comp, false);
    }

    void startComponent(Component comp, boolean startSUs) throws JBIException {
        boolean fromClient = startSUs;
        String componentName = comp.getName();
        String componentType = comp.getComponentTypeAsString();
        if (comp.isLoaded()) {
            throw new JBIException(this.mTranslator.getString("CF_COMP_CANNOT_START", componentType, componentName));
        }
        ComponentStatistics stats = comp.getStatisticsInstance();
        if (!comp.isStarted()) {
            this.checkSharedLibraries(comp);
            javax.jbi.component.ComponentLifeCycle compInstance = comp.getLifeCycleInstance(true);
            this.mLog.fine("Starting " + componentType + " " + componentName);
            if (!comp.isInitialized()) {
                this.initializeComponent(comp, compInstance, fromClient);
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                if (stats.isEnabled()) {
                    stats.incrementStartRequests();
                }
                Thread.currentThread().setContextClassLoader(ClassLoaderFactory.getInstance().getComponentClassLoader(comp.getName()));
                compInstance.start();
            }
            catch (Throwable ex) {
                if (stats.isEnabled()) {
                    stats.incrementFailedRequests();
                }
                String msg = fromClient ? this.mTranslator.getString("CF_LIFECYCLE_START_EXCEPTION", componentType, componentName, ex.getClass().getName()) : this.mTranslator.getString("CF_LIFECYCLE_START_FAILED", componentType, componentName, ex.getClass().getName()) + this.getExMsg(ex);
                this.mLog.log(Level.WARNING, msg, ex);
                throw new JBIException(msg, ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            stats.setLastRestartTime(new Date());
            comp.setStarted();
            String startMsg = this.mTranslator.getString("CF_COMP_START_SUCCESSFUL", componentType, componentName);
            this.mLog.info(startMsg);
            this.mContext.getNotifier().emitComponentNotification(EventNotifierBase.EventType.Started, comp.isBinding() ? EventNotifierBase.SourceType.BindingComponent : EventNotifierBase.SourceType.ServiceEngine, componentName, startMsg);
            if (comp.isObserver()) {
                this.mContext.getNormalizedMessageService().addObserver((DeliveryChannel)comp.getContext().getDeliveryChannel());
            }
            if (startSUs) {
                this.mSUFramework.initializeServiceUnits(comp);
                this.mSUFramework.startServiceUnits(comp);
            }
        } else {
            this.mLog.fine("Start of " + componentType + " " + componentName + " ignored, already started");
        }
    }

    void stopComponent(Component comp) throws JBIException {
        String componentName = comp.getName();
        String componentType = comp.getComponentTypeAsString();
        javax.jbi.component.ComponentLifeCycle compInstance = comp.getLifeCycleInstance(false);
        ComponentStatistics stats = comp.getStatisticsInstance();
        if (comp.isStarted()) {
            this.mLog.fine("Stopping " + componentType + " " + componentName);
            ComponentContext ctx = comp.getContext();
            if (comp.isObserver() && null != ctx) {
                this.mContext.getNormalizedMessageService().removeObserver((DeliveryChannel)ctx.getDeliveryChannel());
            }
            this.mSUFramework.stopServiceUnits(comp);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                if (stats.isEnabled()) {
                    stats.incrementStopRequests();
                }
                Thread.currentThread().setContextClassLoader(ClassLoaderFactory.getInstance().getComponentClassLoader(comp.getName()));
                compInstance.stop();
            }
            catch (Throwable ex) {
                if (stats.isEnabled()) {
                    stats.incrementFailedRequests();
                }
                String msg = this.mTranslator.getString("CF_LIFECYCLE_STOP_EXCEPTION", componentType, componentName, ex.getClass().getName());
                throw new JBIException(msg, ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            comp.setStopped();
            String stopMsg = this.mTranslator.getString("CF_COMP_STOP_SUCCESSFUL", componentType, componentName);
            this.mLog.info(stopMsg);
            this.mContext.getNotifier().emitComponentNotification(EventNotifierBase.EventType.Stopped, comp.isBinding() ? EventNotifierBase.SourceType.BindingComponent : EventNotifierBase.SourceType.ServiceEngine, componentName, stopMsg);
        } else {
            if (comp.isLoaded()) {
                throw new JBIException(this.mTranslator.getString("CF_COMP_CANNOT_STOP", componentType, componentName));
            }
            if (comp.isStopped()) {
                this.mLog.fine("Stop of " + componentType + " " + componentName + " ignored, already stopped");
            } else {
                throw new JBIException(this.mTranslator.getString("CF_COMP_STOP_NOT_ACTIVE", componentType, componentName));
            }
        }
    }

    synchronized void uninstallComponent(InstallationContext installContext, boolean force) throws JBIException {
        FrameworkWarningException warning;
        Component comp;
        String componentType;
        String componentName;
        block12: {
            if (null == installContext) {
                throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "installContext"));
            }
            componentName = installContext.getComponentName();
            componentType = installContext.isBinding() ? this.mBinding : this.mEngine;
            String msg = this.mTranslator.getString("CF_COMP_UNINSTALL_FAILED", componentType, componentName) + " ";
            this.mLog.fine("Uninstalling " + componentType + " " + componentName);
            comp = this.mCompReg.getComponent(componentName);
            if (null == comp) {
                throw new JBIException(msg + this.mTranslator.getString("CF_COMP_NO_COMP_INSTALLED", componentType));
            }
            if (comp.isStarted()) {
                throw new JBIException(msg + this.mTranslator.getString("CF_COMP_UNINSTALL_RUNNING", componentType));
            }
            if (comp.isStopped()) {
                throw new JBIException(msg + this.mTranslator.getString("CF_COMP_UNINSTALL_STOPPED", componentType));
            }
            List<ServiceUnitInfo> suList = comp.getServiceUnitList();
            if (!suList.isEmpty()) {
                boolean i = false;
                StringBuffer suNames = new StringBuffer();
                Iterator<ServiceUnitInfo> sui = suList.iterator();
                while (sui.hasNext()) {
                    if (suNames.length() > 0) {
                        suNames.append(", ");
                    }
                    suNames.append(((ServiceUnit)sui.next()).getName());
                }
                msg = this.mTranslator.getString("CF_COMP_UNINSTALL_FAILED_HAS_SUS", componentType, componentName, suNames);
                this.mLog.warning(msg);
                throw new JBIException(msg);
            }
            warning = null;
            try {
                this.doUninstall(comp, msg);
            }
            catch (FrameworkWarningException warnEx) {
                if (!force) {
                    warning = warnEx;
                }
            }
            catch (JBIException ex) {
                if (force) break block12;
                throw ex;
            }
        }
        this.unregisterMBeans(comp);
        comp.setLoaded();
        String uninstallMsg = this.mTranslator.getString("CF_COMP_UNINSTALL_SUCCESSFUL", componentType, componentName);
        this.mLog.info(uninstallMsg);
        this.mContext.getNotifier().emitComponentNotification(EventNotifierBase.EventType.Uninstalled, comp.isBinding() ? EventNotifierBase.SourceType.BindingComponent : EventNotifierBase.SourceType.ServiceEngine, componentName, uninstallMsg);
        if (null != warning) {
            throw warning;
        }
    }

    private String checkForActiveDependents(String sharedLibraryName) throws JBIException {
        this.mLog.finer("Checking for components dependent upon Shared Library " + sharedLibraryName);
        boolean foundActiveDependents = false;
        StringBuffer actList = new StringBuffer();
        StringBuffer depList = new StringBuffer();
        List comps = this.mCompReg.getDependents(sharedLibraryName);
        ListIterator c = comps.listIterator();
        Component comp = null;
        while (c.hasNext()) {
            comp = (Component)c.next();
            if (depList.length() > 0) {
                depList.append(", ");
            }
            depList.append(comp.getComponentTypeAsString());
            depList.append(" ");
            depList.append(comp.getName());
            if (comp.isLoaded() || comp.isShutDown()) continue;
            this.mLog.warning(this.mTranslator.getString("CF_SL_REFERENCED_BY", sharedLibraryName, comp.getComponentTypeAsString(), comp.getName()));
            if (actList.length() > 0) {
                actList.append(", ");
            }
            actList.append(comp.getComponentTypeAsString());
            actList.append(" ");
            actList.append(comp.getName());
            foundActiveDependents = true;
        }
        if (foundActiveDependents) {
            throw new JBIException(this.mTranslator.getString("CF_SL_REFERENCED_BY_LIST", actList));
        }
        return depList.toString();
    }

    private void checkSharedLibraries(Component component) throws JBIException {
        boolean missingSlib = false;
        List<String> slNameList = component.getSharedLibraryNames();
        if (null != slNameList) {
            ListIterator<String> slNameIter = slNameList.listIterator();
            StringBuffer slNameMissing = new StringBuffer();
            while (slNameIter.hasNext()) {
                String slName = slNameIter.next();
                if (this.mCompReg.isSharedLibraryRegistered(slName)) continue;
                this.mLog.warning(this.mTranslator.getString("CF_COMP_MISSING_SHARED_LIBRARY", slName));
                if (slNameMissing.length() > 0) {
                    slNameMissing.append(", ");
                }
                slNameMissing.append(slName);
                missingSlib = true;
            }
            if (missingSlib) {
                if (component.isUpdating()) {
                    throw new JBIException(this.mTranslator.getString("CF_COMP_UPGRADE_MISSING_SHARED_LIBRARIES", component.getComponentTypeAsString(), component.getName(), slNameMissing));
                }
                if (component.isLoaded()) {
                    throw new JBIException(this.mTranslator.getString("CF_COMP_MISSING_SHARED_LIBRARY_LIST", component.getComponentTypeAsString(), slNameMissing));
                }
                throw new JBIException(this.mTranslator.getString("CF_COMP_MISSING_SHARED_LIBRARIES_START", component.getComponentTypeAsString(), slNameMissing));
            }
        }
    }

    private void createAllInstances(List compList) {
        ListIterator c = compList.listIterator();
        Component comp = null;
        while (c.hasNext()) {
            comp = (Component)c.next();
            if (ComponentState.SHUTDOWN == comp.getDesiredState()) continue;
            this.mLog.fine("Loading life cycle for " + comp.getComponentTypeAsString() + " " + comp.getName());
            try {
                javax.jbi.component.ComponentLifeCycle compInstance = comp.getLifeCycleInstance(true);
            }
            catch (JBIException jbiEx) {
                c.remove();
                this.mLog.warning(jbiEx.getMessage());
            }
        }
    }

    private void createAllLifeCycleMBeans(List compList) {
        ListIterator c = compList.listIterator();
        Component comp = null;
        while (c.hasNext()) {
            comp = (Component)c.next();
            this.mLog.finer("Creating LifeCycle MBean for " + comp.getComponentTypeAsString() + " " + comp.getName());
            try {
                this.createLifeCycleMBean(comp);
            }
            catch (JBIException jbiEx) {
                c.remove();
                this.mLog.warning(jbiEx.getMessage());
            }
        }
    }

    private void createAllOtherMBeans(List compList) {
        ListIterator c = compList.listIterator();
        Component comp = null;
        while (c.hasNext()) {
            comp = (Component)c.next();
            this.mLog.finer("Creating Statistics MBean for " + comp.getComponentTypeAsString() + " " + comp.getName());
            try {
                this.createStatisticsMBean(comp);
            }
            catch (JBIException jbiEx) {
                this.mLog.warning(jbiEx.getMessage());
            }
            this.mLog.finer("Creating Deployer MBean for " + comp.getComponentTypeAsString() + " " + comp.getName());
            try {
                this.createDeployerMBean(comp);
            }
            catch (JBIException jbiEx) {
                this.mLog.warning(jbiEx.getMessage());
            }
            this.mLog.finer("Creating Logger MBean for " + comp.getComponentTypeAsString() + " " + comp.getName());
            try {
                this.createLoggerMBean(comp);
            }
            catch (JBIException jbiEx) {
                this.mLog.warning(jbiEx.getMessage());
            }
            this.mLog.finer("Creating Configuration MBean for " + comp.getComponentTypeAsString() + " " + comp.getName());
            try {
                this.createConfigurationMBean(comp);
            }
            catch (JBIException jbiEx) {
                this.mLog.warning(jbiEx.getMessage());
            }
        }
    }

    private void createDeployerMBean(Component comp) throws JBIException {
        ObjectName deployerMBeanName = null;
        Deployer deployer = new Deployer(comp);
        comp.setDeployerInstance(deployer);
        try {
            deployerMBeanName = this.registerMBean(comp, deployer, DeployerMBean.class, "Deployer");
        }
        catch (JBIException ex) {
            throw new JBIException(this.mTranslator.getString("CF_DEPLOYER_MBEAN_REGISTRATION_FAILED", comp.getComponentTypeAsString(), comp.getName()), (Throwable)ex);
        }
        comp.setDeployerMBeanName(deployerMBeanName);
    }

    void createLifeCycleMBean(Component comp) throws JBIException {
        ObjectName lifeMBeanName = null;
        ComponentLifeCycle lifeMBean = new ComponentLifeCycle(comp, this);
        try {
            lifeMBeanName = this.registerMBean(comp, lifeMBean, ComponentLifeCycleMBean.class, "Lifecycle");
        }
        catch (JBIException jbiEx) {
            throw new JBIException(this.mTranslator.getString("CF_LIFECYCLE_MBEAN_NOT_REGISTERED", comp.getComponentTypeAsString(), comp.getName(), jbiEx.getMessage()));
        }
        comp.setLifeCycleMBeanName(lifeMBeanName);
    }

    private void createLoggerMBean(Component comp) throws JBIException {
        ComponentLogger loggerInst = new ComponentLogger(comp);
        comp.setLoggerInstance(loggerInst);
        ObjectName loggerMBeanName = null;
        ComponentLogger loggerMBean = loggerInst;
        try {
            loggerMBeanName = this.registerMBean(comp, loggerMBean, ComponentLoggerMBean.class, "Logger");
        }
        catch (JBIException ex) {
            throw new JBIException(this.mTranslator.getString("CF_LOGGER_MBEAN_REGISTRATION_FAILED", comp.getComponentTypeAsString(), comp.getName(), ex.getMessage()));
        }
        comp.setLoggerMBeanName(loggerMBeanName);
    }

    void createStatisticsMBean(Component comp) throws JBIException {
        ObjectName statsMBeanName = null;
        ComponentStatistics statsMBean = new ComponentStatistics(comp.getName());
        comp.setStatisticsInstance(statsMBean);
        try {
            statsMBeanName = this.registerMBean(comp, statsMBean, ComponentStatisticsMBean.class, "Statistics");
        }
        catch (JBIException ex) {
            throw new JBIException(this.mTranslator.getString("CF_STATISTICS_MBEAN_REGISTRATION_FAILED", comp.getComponentTypeAsString(), comp.getName(), ex.getMessage()));
        }
        comp.setStatisticsMBeanName(statsMBeanName);
    }

    void createConfigurationMBean(Component comp) throws JBIException {
        ObjectName cfgMBeanName = null;
        ComponentConfiguration cfgMBean = new ComponentConfiguration(this.mContext, comp.getName());
        try {
            cfgMBeanName = this.registerMBean(comp, cfgMBean, null, "Configuration");
        }
        catch (JBIException jbiEx) {
            throw new JBIException(this.mTranslator.getString("CF_CONFIGURATION_MBEAN_REGISTRATION_FAILED", comp.getComponentTypeAsString(), comp.getName(), jbiEx.getMessage()));
        }
        comp.setConfigurationMBeanName(cfgMBeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doInstall(Component comp, String msg, InstallationContext installContext) throws JBIException {
        Bootstrap bootInstance = comp.getBootstrapInstance(false);
        if (null == bootInstance) {
            this.mCompReg.removeComponent(comp.getName());
            throw new JBIException(msg + this.mTranslator.getString("CF_BOOTSTRAP_NOT_LOADED"));
        }
        boolean failure = false;
        bootInstance.onInstall();
        comp.setComponentClassPathElements(installContext.getAbsoluteClassPathElements());
        Object var9_6 = null;
        try {
            bootInstance.cleanUp();
            return;
        }
        catch (Throwable ex) {
            String error = this.mTranslator.getString("CF_BOOTSTRAP_INSTALL_CLEANUP_FAILED", comp.getComponentTypeAsString(), comp.getName(), ex.getClass().getName()) + this.getExMsg(ex);
            this.mLog.warning(error);
            this.mLog.warning(this.mTranslator.stackTraceToString(ex));
            if (failure) return;
            throw new FrameworkWarningException(error);
        }
        finally {
            comp.clearBootstrapInstance();
        }
        {
            catch (Throwable ex) {
                failure = true;
                this.mCompReg.removeComponent(comp.getName());
                String error = msg + this.mTranslator.getString("CF_BOOTSTRAP_ONINSTALL_FAILED", ex.getClass().getName()) + this.getExMsg(ex);
                this.mLog.warning(error);
                this.mLog.warning(this.mTranslator.stackTraceToString(ex));
                throw new JBIException(error, ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            try {
                bootInstance.cleanUp();
                comp.clearBootstrapInstance();
                throw throwable;
            }
            catch (Throwable ex) {
                try {}
                catch (Throwable throwable2) {
                    comp.clearBootstrapInstance();
                    throw throwable2;
                }
                String error = this.mTranslator.getString("CF_BOOTSTRAP_INSTALL_CLEANUP_FAILED", comp.getComponentTypeAsString(), comp.getName(), ex.getClass().getName()) + this.getExMsg(ex);
                this.mLog.warning(error);
                this.mLog.warning(this.mTranslator.stackTraceToString(ex));
                if (!failure) {
                    throw new FrameworkWarningException(error);
                }
                comp.clearBootstrapInstance();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doUninstall(Component comp, String msg) throws JBIException {
        Bootstrap bootInstance = comp.getBootstrapInstance(false);
        if (null == bootInstance) {
            throw new JBIException(msg + this.mTranslator.getString("CF_BOOTSTRAP_NOT_LOADED"));
        }
        boolean failure = false;
        bootInstance.onUninstall();
        Object var8_5 = null;
        try {
            bootInstance.cleanUp();
            return;
        }
        catch (Throwable ex) {
            String error = this.mTranslator.getString("CF_BOOTSTRAP_UNINSTALL_CLEANUP_FAILED", comp.getComponentTypeAsString(), comp.getName(), ex.getClass().getName()) + this.getExMsg(ex);
            this.mLog.warning(error);
            this.mLog.warning(this.mTranslator.stackTraceToString(ex));
            if (failure) return;
            throw new FrameworkWarningException(error);
        }
        finally {
            comp.clearBootstrapInstance();
        }
        {
            catch (Throwable ex) {
                failure = true;
                String error = msg + this.mTranslator.getString("CF_BOOTSTRAP_ONUNINSTALL_FAILED", ex.getClass().getName()) + this.getExMsg(ex);
                this.mLog.warning(error);
                this.mLog.warning(this.mTranslator.stackTraceToString(ex));
                throw new JBIException(error, ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            try {
                bootInstance.cleanUp();
                comp.clearBootstrapInstance();
                throw throwable;
            }
            catch (Throwable ex) {
                try {}
                catch (Throwable throwable2) {
                    comp.clearBootstrapInstance();
                    throw throwable2;
                }
                String error = this.mTranslator.getString("CF_BOOTSTRAP_UNINSTALL_CLEANUP_FAILED", comp.getComponentTypeAsString(), comp.getName(), ex.getClass().getName()) + this.getExMsg(ex);
                this.mLog.warning(error);
                this.mLog.warning(this.mTranslator.stackTraceToString(ex));
                if (!failure) {
                    throw new FrameworkWarningException(error);
                }
                comp.clearBootstrapInstance();
                throw throwable;
            }
        }
    }

    private String getExMsg(Throwable ex) {
        String msg = "";
        if (null != ex.getMessage()) {
            msg = " " + this.mTranslator.getString("EXCEPTION_MSG", ex.getMessage());
        }
        return msg;
    }

    private Method getUpgradeMethod(Bootstrap bootInstance) {
        Method upgrade;
        Class<?> bootClass = bootInstance.getClass();
        try {
            Class[] args = new Class[]{String.class, List.class};
            upgrade = bootClass.getMethod("upgrade", args);
        }
        catch (NoSuchMethodException nsmEx) {
            upgrade = null;
        }
        return upgrade;
    }

    private ObjectName initBootstrap(Component comp, String msg, InstallationContext installContext, boolean force) throws JBIException {
        ObjectName instMBeanName;
        Bootstrap bootInstance = null;
        try {
            bootInstance = comp.getBootstrapInstance(true);
        }
        catch (JBIException ex) {
            if (!force) {
                throw new JBIException(msg, (Throwable)ex);
            }
            this.mLog.fine(msg + ex.getMessage());
        }
        MBeanServer mbs = this.mContext.getMBeanServer();
        ObjectName extMBeanName = comp.getExtensionMBeanName();
        if (null != mbs && null != extMBeanName) {
            try {
                if (mbs.isRegistered(extMBeanName)) {
                    mbs.unregisterMBean(extMBeanName);
                    comp.setExtensionMBeanName(null);
                }
            }
            catch (InstanceNotFoundException infEx) {
            }
            catch (MBeanRegistrationException mbrEx) {
                // empty catch block
            }
        }
        if (null != bootInstance) {
            try {
                ComponentContext ctx = new ComponentContext(comp, this.mContext);
                installContext.setContext(ctx);
                bootInstance.init((javax.jbi.component.InstallationContext)installContext);
                comp.setBootstrapCleanUpNeeded(true);
            }
            catch (Throwable ex) {
                String error = msg + this.mTranslator.getString("CF_BOOTSTRAP_INIT_FAILED", ex.getClass().getName()) + this.getExMsg(ex);
                this.mLog.warning(error);
                this.mLog.warning(this.mTranslator.stackTraceToString(ex));
                try {
                    bootInstance.cleanUp();
                }
                catch (Throwable cex) {
                    String err = this.mTranslator.getString("CF_BOOTSTRAP_CLEANUP_FAILED", cex.getClass().getName()) + this.getExMsg(cex);
                    this.mLog.warning(msg + err);
                    this.mLog.warning(this.mTranslator.stackTraceToString(cex));
                    error = error + " " + err;
                }
                throw new JBIException(error, ex);
            }
            try {
                ObjectName embn = bootInstance.getExtensionMBeanName();
                comp.setExtensionMBeanName(embn);
            }
            catch (Throwable ex) {
                String error = msg + this.mTranslator.getString("CF_BOOTSTRAP_GET_EXTENSION_FAILED", ex.getClass().getName()) + this.getExMsg(ex);
                this.mLog.warning(error);
                this.mLog.warning(this.mTranslator.stackTraceToString(ex));
                try {
                    bootInstance.cleanUp();
                }
                catch (Throwable cex) {
                    String err = this.mTranslator.getString("CF_BOOTSTRAP_CLEANUP_FAILED", cex.getClass().getName(), cex.getMessage());
                    this.mLog.warning(msg + err);
                    this.mLog.warning(this.mTranslator.stackTraceToString(cex));
                    error = error + " " + err;
                }
                throw new JBIException(error, ex);
            }
        }
        ComponentInstaller instMBean = new ComponentInstaller(installContext, this, this.mCompReg);
        try {
            instMBeanName = this.registerMBean(comp, instMBean, InstallerMBean.class, "Installer");
            comp.setInstallerMBeanName(instMBeanName);
        }
        catch (JBIException ex) {
            String error = msg + this.mTranslator.getString("CF_COMP_INSTALLER_MBEAN_REGISTRATION_FAILED");
            this.mLog.warning(error);
            throw new JBIException(error, (Throwable)ex);
        }
        return instMBeanName;
    }

    private void initComponent(Component comp, InstallationContext installContext, String bootClassName, List<String> bootClassPathElements, List<String> sharedLibraryNames) {
        comp.setName(installContext.getComponentName());
        comp.setDescription(installContext.getDescription());
        comp.setInstallRoot(installContext.getInstallRoot());
        String wsroot = installContext.getWorkspaceRoot();
        if (null != wsroot) {
            comp.setWorkspaceRoot(wsroot);
        } else {
            comp.setWorkspaceRoot(installContext.getInstallRoot());
        }
        if (installContext.isBinding()) {
            comp.setComponentTypeBinding();
        } else {
            comp.setComponentTypeEngine();
        }
        comp.setBootstrapClassLoaderSelfFirst(installContext.isBootstrapClassLoaderSelfFirst());
        comp.setBootstrapClassName(bootClassName);
        comp.setBootstrapClassPathElements(bootClassPathElements);
        comp.setComponentClassName(installContext.getComponentClassName());
        comp.setComponentClassPathElements(installContext.getAbsoluteClassPathElements());
        comp.setComponentClassLoaderSelfFirst(installContext.isComponentClassLoaderSelfFirst());
        comp.setSharedLibraryNames(sharedLibraryNames);
        comp.setLoaded();
        comp.setDesiredState(ComponentState.SHUTDOWN);
    }

    private ObjectName registerMBean(Component component, Object instance, Class interfaceClass, String mbeanType) throws JBIException {
        if (null == this.mContext.getMBeanServer()) {
            return null;
        }
        this.mLog.finer("Registering " + mbeanType + " MBean for " + component.getComponentTypeAsString() + " " + component.getName());
        boolean isDynamicMBean = interfaceClass == null;
        StandardMBean mbean = null;
        if (!isDynamicMBean) {
            try {
                mbean = new StandardMBean(instance, interfaceClass);
            }
            catch (NotCompliantMBeanException ncEx) {
                String exName = ncEx.getClass().getName();
                throw new JBIException(this.mTranslator.getString("CF_MBEAN_CREATION_FAILED", exName), (Throwable)ncEx);
            }
        }
        ObjectName mbeanName = null;
        mbeanName = component.isBinding() ? this.mContext.getMBeanNames().getBindingMBeanName(component.getName(), mbeanType) : this.mContext.getMBeanNames().getEngineMBeanName(component.getName(), mbeanType);
        try {
            if (this.mContext.getMBeanServer().isRegistered(mbeanName)) {
                try {
                    this.mContext.getMBeanServer().unregisterMBean(mbeanName);
                }
                catch (InstanceNotFoundException infEx) {
                    // empty catch block
                }
            }
            if (isDynamicMBean) {
                this.mContext.getMBeanServer().registerMBean(instance, mbeanName);
            } else {
                this.mContext.getMBeanServer().registerMBean(mbean, mbeanName);
            }
        }
        catch (InstanceAlreadyExistsException iaeEx) {
            String exName = iaeEx.getClass().getName();
            throw new JBIException(this.mTranslator.getString("CF_MBEAN_REGISTRATION_FAILED", exName), (Throwable)iaeEx);
        }
        catch (MBeanRegistrationException mbrEx) {
            String exName = mbrEx.getClass().getName();
            throw new JBIException(this.mTranslator.getString("CF_MBEAN_REGISTRATION_FAILED", exName), (Throwable)mbrEx);
        }
        catch (NotCompliantMBeanException ncEx) {
            String exName = ncEx.getClass().getName();
            throw new JBIException(this.mTranslator.getString("CF_MBEAN_REGISTRATION_FAILED", exName), (Throwable)ncEx);
        }
        return mbeanName;
    }

    private void persistState(Component comp) {
        try {
            ((Registry)this.mContext.getRegistry()).getUpdater().setComponentState(comp.getDesiredState(), comp.getName());
        }
        catch (RegistryException rEx) {
            this.mLog.log(Level.WARNING, rEx.getMessage(), (Throwable)((Object)rEx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareComponents(List compList) {
        Object previousDesired;
        ListIterator c = compList.listIterator();
        Component comp = null;
        OperationCounter oc = new OperationCounter();
        ArrayList<ComponentOperation> opers = new ArrayList<ComponentOperation>();
        long timeOut = this.mContext.getComponentTimeout();
        while (c.hasNext()) {
            comp = (Component)c.next();
            previousDesired = comp.getDesiredState();
            if (!previousDesired.equals((Object)ComponentState.STARTED)) continue;
            ComponentOperation oper = new ComponentOperation(oc, comp, 1, true);
            opers.add(oper);
            new Thread((Runnable)oper, comp.getName()).start();
        }
        if (0 < opers.size()) {
            previousDesired = oc;
            synchronized (previousDesired) {
                try {
                    if (0 < oc.getValue()) {
                        oc.wait(this.mContext.getComponentTimeout());
                    }
                }
                catch (InterruptedException iEx) {
                    this.mLog.warning(this.mTranslator.getString("CF_STARTUP_INTERRUPTED"));
                }
            }
            for (ComponentOperation oper : opers) {
                comp = oper.getComponent();
                if (oper.completed()) continue;
                oper.getThread().interrupt();
                this.mLog.warning(this.mTranslator.getString("CF_COMP_INIT_TIMEOUT", comp.getComponentTypeAsString(), comp.getName(), new Long(timeOut)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startComponents(List compList) {
        ManagementContext mc;
        ManagementService ms;
        ComponentOperation oper2;
        this.mLog.finer("startComponents entered, startup state is " + (this.mStartupState == 1 ? "PREPARE" : "START"));
        ListIterator c = compList.listIterator();
        Component comp = null;
        OperationCounter oc = new OperationCounter();
        ArrayList<ComponentOperation> opers = new ArrayList<ComponentOperation>();
        long timeOut = this.mContext.getComponentTimeout();
        if (this.mStartupState == 1) {
            while (c.hasNext()) {
                comp = (Component)c.next();
                this.mLog.finer("processing component " + comp.getName() + " with desired state " + (Object)((Object)comp.getDesiredState()));
                if (ComponentState.STARTED == comp.getDesiredState()) {
                    oper2 = new ComponentOperation(oc, comp, 2, true);
                    opers.add(oper2);
                    new Thread((Runnable)oper2, comp.getName()).start();
                    continue;
                }
                if (ComponentState.STOPPED == comp.getDesiredState()) {
                    oper2 = new ComponentOperation(oc, comp, 1, true);
                    opers.add(oper2);
                    new Thread((Runnable)oper2, comp.getName()).start();
                    continue;
                }
                if (ComponentState.SHUTDOWN != comp.getDesiredState()) continue;
                oper2 = new ComponentOperation(oc, comp, 3, true);
                opers.add(oper2);
                new Thread((Runnable)oper2, comp.getName()).start();
            }
        } else {
            while (c.hasNext()) {
                comp = (Component)c.next();
                if (comp.getDesiredState().equals((Object)ComponentState.STOPPED)) {
                    oper2 = new ComponentOperation(oc, comp, 1, true);
                    opers.add(oper2);
                    new Thread((Runnable)oper2, comp.getName()).start();
                    continue;
                }
                if (!comp.getDesiredState().equals((Object)ComponentState.STARTED)) continue;
                oper2 = new ComponentOperation(oc, comp, 2, true);
                opers.add(oper2);
                new Thread((Runnable)oper2, comp.getName()).start();
            }
        }
        if (0 < opers.size()) {
            this.mLog.finer("waiting for " + opers.size() + " operations to complete");
            OperationCounter operationCounter = oc;
            synchronized (operationCounter) {
                try {
                    if (0 < oc.getValue()) {
                        oc.wait(timeOut);
                    }
                }
                catch (InterruptedException iEx) {
                    this.mLog.warning(this.mTranslator.getString("CF_STARTUP_INTERRUPTED"));
                }
            }
            for (ComponentOperation oper2 : opers) {
                comp = oper2.getComponent();
                if (oper2.completed()) continue;
                oper2.getThread().interrupt();
                this.mLog.warning(this.mTranslator.getString("CF_COMP_START_TIMEOUT", comp.getComponentTypeAsString(), comp.getName(), new Long(timeOut)));
            }
        }
        if (null != (ms = this.mContext.getManagementService()) && null != (mc = ms.getManagementContext())) {
            mc.getDeploymentServiceHandle().startAllServiceAssemblies();
        }
    }

    void unregisterMBeans(Component comp) throws JBIException {
        MBeanServer mbs = this.mContext.getMBeanServer();
        if (null != mbs) {
            String error;
            try {
                mbs.unregisterMBean(comp.getConfigurationMBeanName());
            }
            catch (Throwable ex) {
                error = this.mTranslator.getString("CF_CONFIGURATION_MBEAN_UNREGISTRATION_FAILED", comp.getComponentTypeAsString(), comp.getName(), ex.getClass().getName());
                this.mLog.warning(error);
                this.mLog.warning(this.mTranslator.stackTraceToString(ex));
            }
            comp.setConfigurationMBeanName(null);
            try {
                mbs.unregisterMBean(comp.getLifeCycleMBeanName());
            }
            catch (Throwable ex) {
                error = this.mTranslator.getString("CF_LIFECYCLE_MBEAN_UNREGISTRATION_FAILED", comp.getComponentTypeAsString(), comp.getName(), ex.getClass().getName());
                this.mLog.warning(error);
                this.mLog.warning(this.mTranslator.stackTraceToString(ex));
            }
            comp.setLifeCycleMBeanName(null);
            ObjectName name = comp.getDeployerMBeanName();
            if (null != name) {
                try {
                    mbs.unregisterMBean(name);
                }
                catch (Throwable ex) {
                    this.mLog.warning(this.mTranslator.getString("CF_DEPLOYER_MBEAN_UNREGISTRATION_FAILED", comp.getComponentTypeAsString(), comp.getName(), ex.getClass().getName()));
                    this.mLog.warning(this.mTranslator.stackTraceToString(ex));
                }
                comp.setDeployerInstance(null);
                comp.setDeployerMBeanName(null);
            }
            if (null != (name = comp.getLoggerMBeanName())) {
                try {
                    mbs.unregisterMBean(name);
                }
                catch (Throwable ex) {
                    this.mLog.warning(this.mTranslator.getString("CF_LOGGER_MBEAN_UNREGISTRATION_FAILED", comp.getComponentTypeAsString(), comp.getName(), name, ex.getClass().getName()));
                    this.mLog.warning(this.mTranslator.stackTraceToString(ex));
                }
                comp.setLoggerMBeanName(null);
            }
            if (null != (name = comp.getStatisticsMBeanName())) {
                try {
                    mbs.unregisterMBean(name);
                }
                catch (Throwable ex) {
                    this.mLog.warning(this.mTranslator.getString("CF_STATISTICS_MBEAN_UNREGISTRATION_FAILED", comp.getComponentTypeAsString(), comp.getName(), ex.getClass().getName()));
                    this.mLog.warning(this.mTranslator.stackTraceToString(ex));
                }
                comp.clearStatisticsInstance();
                comp.setStatisticsMBeanName(null);
            }
        }
    }
}

