/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.ComponentState;
import com.sun.jbi.framework.Component;
import com.sun.jbi.framework.ComponentFramework;
import com.sun.jbi.framework.ComponentLifeCycleMBean;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.StringTranslator;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.Updater;
import java.util.logging.Level;
import javax.jbi.JBIException;
import javax.management.ObjectName;

public class ComponentLifeCycle
implements ComponentLifeCycleMBean {
    private Component mComponent;
    private ComponentFramework mComponentFramework;
    private StringTranslator mTranslator;
    private Updater mUpdater;

    ComponentLifeCycle(Component component, ComponentFramework componentFramework) {
        this.mComponent = component;
        this.mComponentFramework = componentFramework;
        this.mTranslator = (StringTranslator)EnvironmentContext.getInstance().getStringTranslatorFor(this);
    }

    public String getCurrentState() {
        String state = this.mComponent.isStarted() ? "Started" : (this.mComponent.isStopped() ? "Stopped" : (this.mComponent.isShutDown() ? "Shutdown" : "Unknown"));
        return state;
    }

    public ObjectName getDeploymentMBeanName() throws JBIException {
        ObjectName name = null;
        name = this.mComponent.getDeployerMBeanName();
        return name;
    }

    public ObjectName getExtensionMBeanName() throws JBIException {
        ObjectName name = null;
        javax.jbi.component.ComponentLifeCycle instance = this.mComponent.getLifeCycleInstance(false);
        if (instance != null) {
            name = instance.getExtensionMBeanName();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JBIException {
        this.mComponent.setBusy();
        this.mComponent.setDesiredState(ComponentState.STARTED);
        this.persistState();
        try {
            this.mComponentFramework.startComponent(this.mComponent, true);
        }
        finally {
            this.mComponent.clearBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JBIException {
        this.mComponent.setBusy();
        this.mComponent.setDesiredState(ComponentState.STOPPED);
        this.persistState();
        try {
            this.mComponentFramework.stopComponent(this.mComponent);
        }
        finally {
            this.mComponent.clearBusy();
        }
    }

    public void shutDown() throws JBIException {
        this.shutDown(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown(boolean force) throws JBIException {
        if (force) {
            this.mComponent.setBusyForce();
        } else {
            this.mComponent.setBusy();
        }
        this.mComponent.setDesiredState(ComponentState.SHUTDOWN);
        this.persistState();
        try {
            this.mComponentFramework.shutdownComponent(this.mComponent, force, true);
        }
        finally {
            this.mComponent.clearBusy();
        }
    }

    private void persistState() {
        try {
            if (null == this.mUpdater) {
                this.mUpdater = ((Registry)EnvironmentContext.getInstance().getRegistry()).getUpdater();
            }
            this.mUpdater.setComponentState(this.mComponent.getDesiredState(), this.mComponent.getName());
        }
        catch (RegistryException rEx) {
            EnvironmentContext.getInstance().getLogger().log(Level.WARNING, rEx.getMessage(), (Throwable)((Object)rEx));
        }
    }
}

