/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.StringTranslator;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public final class DelegatingClassLoader
extends SecureClassLoader {
    private ArrayList mSharedClassLoaders;
    private StringTranslator mTranslator;
    private ClassLoader mParentLoader;
    private Logger mLogger;

    public DelegatingClassLoader(ClassLoader parent) {
        super(parent);
        ClassLoader systemCL = DelegatingClassLoader.getSystemClassLoader();
        this.mParentLoader = parent != null ? parent : systemCL;
        this.mSharedClassLoaders = new ArrayList();
        EnvironmentContext eCtx = EnvironmentContext.getInstance();
        this.mTranslator = (StringTranslator)eCtx.getStringTranslatorFor(this);
    }

    public void addSharedClassLoader(ClassLoader sharedLoader) throws IllegalArgumentException {
        if (null == sharedLoader) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "sharedLoader"));
        }
        this.mSharedClassLoaders.add(sharedLoader);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> class2Load = null;
        class2Load = this.findLoadedClass(name);
        if (class2Load != null) {
            if (resolve) {
                this.resolveClass(class2Load);
            }
            return class2Load;
        }
        try {
            class2Load = this.findClass(name);
            if (class2Load != null) {
                if (resolve) {
                    this.resolveClass(class2Load);
                }
                return class2Load;
            }
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            class2Load = this.mParentLoader.loadClass(name);
            if (resolve) {
                this.resolveClass(class2Load);
            }
            return class2Load;
        }
        catch (ClassNotFoundException cnfe) {
            throw new ClassNotFoundException(name);
        }
    }

    public Class findClass(String name) throws ClassNotFoundException {
        boolean found = false;
        Class<?> sharedClass = null;
        Iterator cItr = this.mSharedClassLoaders.iterator();
        while (cItr.hasNext()) {
            try {
                ClassLoader nextSharedCL = (ClassLoader)cItr.next();
                sharedClass = nextSharedCL.loadClass(name);
                found = true;
                break;
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        if (!found) {
            throw new ClassNotFoundException(name);
        }
        return sharedClass;
    }
}

