/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.EventNotifierBase;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.EventNotifierCommon;
import com.sun.jbi.framework.EventNotifierMBean;
import com.sun.jbi.framework.StringTranslator;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.platform.PlatformContext;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class EventNotifier
extends NotificationBroadcasterSupport
implements EventNotifierCommon,
EventNotifierMBean {
    private static AtomicLong sSeqNo = new AtomicLong();
    private boolean mNotificationsEnabled;
    private Logger mLog;
    private StringTranslator mTranslator;
    private String mInstanceName;
    private String mCombinedName;
    private ObjectName mObjName;
    private ObjectName mDASMBeanName;
    private PlatformContext mPlatformContext;
    private ExecutorService mExecSvc;
    private CompositeType mUserDataType1;
    private CompositeType mUserDataType2;
    static final String JBI_FRAMEWORK = "JBIFramework";
    static final String[] ITEM_NAMES_1 = new String[]{"EventType", "SourceType", "TargetName", "SourceName"};
    static final String[] ITEM_NAMES_2 = new String[]{"EventType", "SourceType", "TargetName", "SourceName", "ServiceAssemblyName", "ComponentName"};
    static final String[] ITEM_DESCRIPTIONS_1 = new String[]{"Type of event that occurred", "Type of entity on which the event occurred", "Name of the target where the event occurred", "Name of the entity affected by the event"};
    static final String[] ITEM_DESCRIPTIONS_2 = new String[]{"Type of event that occurred", "Type of entity on which the event occurred", "Name of the target where the event occurred", "Name of the service unit affected by the event", "Name of the service assembly to which the service unit belongs", "Name of the component to which the service unit is deployed"};
    static final OpenType[] ITEM_TYPES_1 = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
    static final OpenType[] ITEM_TYPES_2 = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};

    EventNotifier(EnvironmentContext ctx) throws JBIException {
        this.mLog = ctx.getLogger();
        this.mTranslator = (StringTranslator)ctx.getStringTranslatorFor(this);
        this.mPlatformContext = ctx.getPlatformContext();
        this.mInstanceName = this.mPlatformContext.getInstanceName();
        this.mNotificationsEnabled = true;
        this.mCombinedName = this.mPlatformContext.isInstanceClustered(this.mInstanceName) ? this.mInstanceName + "-" + this.mPlatformContext.getTargetName() : this.mInstanceName;
        this.mExecSvc = Executors.newCachedThreadPool();
        try {
            this.mUserDataType1 = new CompositeType("UserData", "notification user data", ITEM_NAMES_1, ITEM_DESCRIPTIONS_1, ITEM_TYPES_1);
            this.mUserDataType2 = new CompositeType("UserData", "notification user data", ITEM_NAMES_2, ITEM_DESCRIPTIONS_2, ITEM_TYPES_2);
        }
        catch (OpenDataException odEx) {
            String msg = this.mTranslator.getString("FN_USER_DATA_CREATE_FAILED", odEx.getClass().getName());
            this.mLog.log(Level.WARNING, msg, odEx);
            throw new JBIException(msg, (Throwable)odEx);
        }
        this.mObjName = ctx.getMBeanNames().getSystemServiceMBeanName("Framework", "Notification");
        this.mDASMBeanName = ctx.getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.Framework, MBeanNames.ServiceType.Notification, "domain");
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] notifs = new MBeanNotificationInfo[]{new MBeanNotificationInfo(NOTIFICATION_TYPES, "javax.management.Notification", "JBI runtime event")};
        return notifs;
    }

    public void disableNotifications() {
        this.mNotificationsEnabled = false;
        this.mLog.fine("Event notifications disabled for instance " + this.mCombinedName);
    }

    public void enableNotifications() {
        this.mNotificationsEnabled = true;
        this.mLog.fine("Event notifications enabled for instance " + this.mCombinedName);
    }

    public Notification emitRuntimeNotification(EventNotifierBase.EventType eventType, String msg) {
        if (this.mNotificationsEnabled) {
            String type = "com.sun.jbi." + (Object)((Object)eventType) + "." + (Object)((Object)EventNotifierBase.SourceType.JBIRuntime);
            Notification notif = new Notification(type, (Object)this.mObjName, sSeqNo.incrementAndGet(), msg);
            CompositeData userData = this.toCompositeData1(eventType.toString(), EventNotifierBase.SourceType.JBIRuntime.toString(), JBI_FRAMEWORK);
            if (null != userData) {
                this.mLog.finest("Created notification userdata: " + ((Object)userData).toString());
                notif.setUserData(userData);
            }
            this.mLog.finer("Sending notification: " + notif.toString() + " sequence number " + notif.getSequenceNumber());
            this.mExecSvc.execute(new Notify(this, notif));
            return notif;
        }
        return null;
    }

    public Notification emitComponentNotification(EventNotifierBase.EventType eventType, EventNotifierBase.SourceType sourceType, String componentName, String msg) {
        if (this.mNotificationsEnabled) {
            String type = "com.sun.jbi." + (Object)((Object)eventType) + "." + (Object)((Object)sourceType);
            Notification notif = new Notification(type, (Object)this.mObjName, sSeqNo.incrementAndGet(), msg);
            CompositeData userData = this.toCompositeData1(eventType.toString(), sourceType.toString(), componentName);
            if (null != userData) {
                this.mLog.finest("Created notification userdata: " + ((Object)userData).toString());
                notif.setUserData(userData);
            }
            this.mLog.finer("Sending notification: " + notif.toString() + " sequence number " + notif.getSequenceNumber());
            this.mExecSvc.execute(new Notify(this, notif));
            return notif;
        }
        return null;
    }

    public Notification emitSharedLibraryNotification(EventNotifierBase.EventType eventType, String sharedLibraryName, String msg) {
        if (this.mNotificationsEnabled) {
            String type = "com.sun.jbi." + (Object)((Object)eventType) + "." + (Object)((Object)EventNotifierBase.SourceType.SharedLibrary);
            Notification notif = new Notification(type, (Object)this.mObjName, sSeqNo.incrementAndGet(), msg);
            CompositeData userData = this.toCompositeData1(eventType.toString(), EventNotifierBase.SourceType.SharedLibrary.toString(), sharedLibraryName);
            if (null != userData) {
                this.mLog.finest("Created notification userdata: " + ((Object)userData).toString());
                notif.setUserData(userData);
            }
            this.mLog.finer("Sending notification: " + notif.toString() + " sequence number " + notif.getSequenceNumber());
            this.mExecSvc.execute(new Notify(this, notif));
            return notif;
        }
        return null;
    }

    public Notification emitServiceAssemblyNotification(EventNotifierBase.EventType eventType, String serviceAssemblyName, String msg) {
        if (this.mNotificationsEnabled) {
            String type = "com.sun.jbi." + (Object)((Object)eventType) + "." + (Object)((Object)EventNotifierBase.SourceType.ServiceAssembly);
            Notification notif = new Notification(type, (Object)this.mObjName, sSeqNo.incrementAndGet(), msg);
            CompositeData userData = this.toCompositeData1(eventType.toString(), EventNotifierBase.SourceType.ServiceAssembly.toString(), serviceAssemblyName);
            if (null != userData) {
                this.mLog.finest("Created notification userdata: " + ((Object)userData).toString());
                notif.setUserData(userData);
            }
            this.mLog.finer("Sending notification: " + notif.toString() + " sequence number " + notif.getSequenceNumber());
            this.mExecSvc.execute(new Notify(this, notif));
            return notif;
        }
        return null;
    }

    public Notification emitServiceUnitNotification(EventNotifierBase.EventType eventType, String serviceUnitName, String serviceAssemblyName, String componentName, String msg) {
        if (this.mNotificationsEnabled) {
            String type = "com.sun.jbi." + (Object)((Object)eventType) + "." + (Object)((Object)EventNotifierBase.SourceType.ServiceUnit);
            Notification notif = new Notification(type, (Object)this.mObjName, sSeqNo.incrementAndGet(), msg);
            CompositeData userData = this.toCompositeData2(eventType.toString(), EventNotifierBase.SourceType.ServiceUnit.toString(), serviceUnitName, serviceAssemblyName, componentName);
            if (null != userData) {
                this.mLog.finest("Created notification userdata: " + ((Object)userData).toString());
                notif.setUserData(userData);
            }
            this.mLog.finer("Sending notification: " + notif.toString() + " sequence number " + notif.getSequenceNumber());
            this.mExecSvc.execute(new Notify(this, notif));
            return notif;
        }
        return null;
    }

    void instanceStarting() {
        this.invokeDASMBean("instanceStarted");
    }

    void instanceStopping() {
        this.invokeDASMBean("instanceStopped");
        this.mExecSvc.shutdownNow();
    }

    private void invokeDASMBean(String operation) {
        MBeanServerConnection mbsConn = null;
        try {
            mbsConn = this.mPlatformContext.getMBeanServerConnection(this.mPlatformContext.getAdminServerName());
        }
        catch (Throwable ex) {
            this.mLog.log(Level.FINE, "Unable to get MBean server connection  for admin server " + this.mPlatformContext.getAdminServerName() + ". Exception follows.", ex);
        }
        if (null != mbsConn) {
            String[] signature = new String[]{"java.lang.String", "javax.management.ObjectName"};
            Object[] params = new Object[]{this.mInstanceName, this.mObjName};
            try {
                this.mLog.finest("Invoking " + operation + " on MBean " + this.mDASMBeanName);
                mbsConn.invoke(this.mDASMBeanName, operation, params, signature);
            }
            catch (InstanceNotFoundException infEx) {
                this.mLog.fine("Invoke of " + operation + " on DAS MBean " + this.mDASMBeanName + " failed, MBean is not registered");
            }
            catch (Throwable ex) {
                Throwable actualEx = this.stripJmxException(ex);
                this.mLog.log(Level.FINE, "Failure invoking MBean operation " + operation + ". Exception follows.", actualEx);
            }
        }
    }

    private Throwable stripJmxException(Throwable ex) {
        Throwable currEx = ex;
        while (null != currEx.getCause()) {
            if (!(currEx instanceof JMException) && !(currEx instanceof JMRuntimeException)) {
                return currEx;
            }
            currEx = currEx.getCause();
        }
        return currEx;
    }

    private CompositeData toCompositeData1(String eventType, String sourceType, String sourceName) {
        Object[] values = new Object[]{eventType, sourceType, this.mCombinedName, sourceName};
        CompositeDataSupport cd = null;
        try {
            cd = new CompositeDataSupport(this.mUserDataType1, ITEM_NAMES_1, values);
        }
        catch (OpenDataException odEx) {
            this.mLog.log(Level.WARNING, this.mTranslator.getString("FN_USER_DATA_CREATE_FAILED", odEx.getClass().getName()), odEx);
        }
        return cd;
    }

    private CompositeData toCompositeData2(String eventType, String sourceType, String serviceUnitName, String serviceAssemblyName, String componentName) {
        Object[] values = new Object[]{eventType, sourceType, this.mCombinedName, serviceUnitName, serviceAssemblyName, componentName};
        CompositeDataSupport cd = null;
        try {
            cd = new CompositeDataSupport(this.mUserDataType2, ITEM_NAMES_2, values);
        }
        catch (OpenDataException odEx) {
            this.mLog.log(Level.WARNING, this.mTranslator.getString("FN_USER_DATA_CREATE_FAILED", odEx.getClass().getName()), odEx);
        }
        return cd;
    }

    class Notify
    implements Runnable {
        EventNotifier mEventNotifier;
        Notification mNotification;

        Notify(EventNotifier en, Notification notif) {
            this.mEventNotifier = en;
            this.mNotification = notif;
        }

        public void run() {
            this.mEventNotifier.sendNotification(this.mNotification);
        }
    }
}

