/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.framework.ClassLoaderFactory;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.Operation;
import com.sun.jbi.framework.OperationCounter;
import com.sun.jbi.framework.StringTranslator;
import javax.jbi.component.ServiceUnitManager;

class ServiceUnitOperation
extends Operation {
    private EnvironmentContext mEnv;
    private int mOperation;
    private String mComponentName;
    private ServiceUnitManager mSuManager;
    private StringTranslator mTranslator;
    public static final int DEPLOY = 1;
    public static final int INIT = 2;
    public static final int START = 3;
    public static final int STOP = 4;
    public static final int SHUTDOWN = 5;
    public static final int UNDEPLOY = 6;

    ServiceUnitOperation(OperationCounter counter, String compName, ServiceUnitManager suManager, int operation, Object[] args) {
        super(counter, args);
        this.mComponentName = compName;
        this.mSuManager = suManager;
        this.mEnv = EnvironmentContext.getInstance();
        this.mTranslator = (StringTranslator)this.mEnv.getStringTranslatorFor(this);
        if (null == suManager) {
            throw new IllegalArgumentException(this.mTranslator.getString("NULL_ARGUMENT", "suManager"));
        }
        if (1 != operation && 2 != operation && 3 != operation && 4 != operation && 5 != operation && 6 != operation) {
            throw new IllegalArgumentException(this.mTranslator.getString("INVALID_ARGUMENT", "operation", new Integer(operation)));
        }
        this.mOperation = operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object process(Object[] argumentList) throws Throwable {
        String returnValue = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClassLoaderFactory.getInstance().getComponentClassLoader(this.mComponentName));
            switch (this.mOperation) {
                case 1: {
                    returnValue = this.mSuManager.deploy((String)argumentList[0], (String)argumentList[1]);
                    return returnValue;
                }
                case 2: {
                    this.mSuManager.init((String)argumentList[0], (String)argumentList[1]);
                    return returnValue;
                }
                case 3: {
                    this.mSuManager.start((String)argumentList[0]);
                    return returnValue;
                }
                case 4: {
                    this.mSuManager.stop((String)argumentList[0]);
                    return returnValue;
                }
                case 5: {
                    this.mSuManager.shutDown((String)argumentList[0]);
                    return returnValue;
                }
                case 6: {
                    returnValue = this.mSuManager.undeploy((String)argumentList[0], (String)argumentList[1]);
                    return returnValue;
                }
            }
            return returnValue;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    void resetOperation(int operation) {
        if (1 != operation && 2 != operation && 3 != operation && 4 != operation && 5 != operation && 6 != operation) {
            throw new IllegalArgumentException(this.mTranslator.getString("INVALID_ARGUMENT", "operation", new Integer(operation)));
        }
        this.mOperation = operation;
        super.reset();
    }
}

