/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework.sun;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ServiceAssemblyInfo;
import com.sun.jbi.ServiceAssemblyState;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.sun.AppVarInfo;
import com.sun.jbi.framework.sun.EntityInfo;
import com.sun.jbi.framework.sun.SyncException;
import com.sun.jbi.management.ComponentInfo;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.registry.GenericQuery;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryBuilder;
import com.sun.jbi.management.registry.RegistryDiff;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.RegistrySpecImpl;
import com.sun.jbi.management.registry.RegistryType;
import com.sun.jbi.platform.PlatformContext;
import com.sun.jbi.util.EnvironmentAccess;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryHelper {
    private static final String DOMAIN = "domain";
    private static final String DAS_RELATIVE_PATH = "config";
    private static final String STRING_TRANSLATOR_NAME = "com.sun.jbi.framework.sun";
    private static final String SL_KEY = "sl";
    private static final String COMP_KEY = "comp";
    private static final String SA_KEY = "sa";
    private static final String DOMAIN_KEY = "domain";
    private static final String INSTANCE_KEY = "instance";
    private static final String STATIC_CONF_KEY = "static";
    private static final String APPVAR_CONF_KEY = "appvar";
    private static final String APPCON_CONF_KEY = "appcon";
    private static final String JBI_SCHEMA_CONFIGS = "configs";
    private static final String JBI_SCHEMA_CONFIG = "config";
    private static final String JBI_SCHEMA_CONFIG_TYPE = "config-type";
    private static final String JBI_SCHEMA_CATEGORY = "category";
    private static final String JBI_SCHEMA_PROPERTY = "property";
    private static final String JBI_SCHEMA_VALUE = "value";
    private static final String JBI_SCHEMA_TYPE = "type";
    private static final String JBI_SCHEMA_APPLICATION_VARIABLE = "application-variable";
    private static final String JBI_SCHEMA_APPLICATION_CONFIGURATION = "application-configuration";
    private static final String JBI_SCHEMA_COMPONENT = "component";
    private static final String JBI_SCHEMA_COMPONENT_REF = "component-ref";
    private static final String JBI_SCHEMA_COMPONENT_CONFIG = "component-config";
    private static final String JBI_SCHEMA_SHARED_LIBRARY = "shared-library";
    private static final String JBI_SCHEMA_SHARED_LIBRARY_REF = "shared-library-ref";
    private static final String JBI_SCHEMA_SERVICE_ASSEMBLY = "service-assembly";
    private static final String JBI_SCHEMA_SERVICE_ASSEMBLY_REF = "service-assembly-ref";
    private static final String JBI_SCHEMA_SERVICE_UNIT = "service-unit";
    private static final String JBI_SCHEMA_NAME = "name";
    private static final String JBI_SCHEMA_NAME_REF = "name-ref";
    private static final String JBI_SCHEMA_TIMESTAMP = "timestamp";
    private static final String JBI_SCHEMA_STATE = "state";
    private static final String JBI_SCHEMA_UPDATENUMBER = "upgrade-number";
    static final int INITIALIZED = 1;
    static final int SYNC_REQUIRED = 2;
    static final int ALL_NOT_SHUTDOWN = 4;
    private Registry mRegistry;
    private Registry mMasterRegistry;
    private String mDASRegistryFileName;
    private String mSyncRegistryFileName;
    private String mSyncFolder;
    private RegistryDiff mDiff;
    private Logger mLogger;
    private String mTarget;
    private PlatformContext mPlatform;
    private StringTranslator mTranslator;
    private ObjectName mDASDownloadMBeanName;
    private MBeanServerConnection mMBeanServer;
    private String mInstanceRootPath;
    private HashMap mLocalReg;
    private int mSyncState;

    public RegistryHelper(EnvironmentContext envCtx) {
        this.mPlatform = envCtx.getPlatformContext();
        this.mTranslator = envCtx.getStringTranslator(STRING_TRANSLATOR_NAME);
        this.mLogger = Logger.getLogger(STRING_TRANSLATOR_NAME);
        this.mDASDownloadMBeanName = envCtx.getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.FileTransferService, MBeanNames.ServiceType.Download, "domain");
        this.mInstanceRootPath = envCtx.getJbiInstanceRoot();
    }

    public boolean isActiveStartup() {
        boolean isActive = true;
        if (this.mPlatform.isAdminServer()) {
            if (this.allShutdown(this.getLocalRegInfo())) {
                isActive = false;
            }
        } else {
            if ((this.mSyncState & 1) == 0) {
                this.computeXAActiveOrSyncRequired();
            }
            isActive = (this.mSyncState & 0xFFFFFFFE) != 0;
        }
        return isActive;
    }

    private void computeXAActiveOrSyncRequired() {
        Exception e = null;
        int result = 0;
        try {
            this.getDASDownloadMBeanServer();
            this.mTarget = this.mPlatform.getTargetName();
            ByteArrayInputStream bais = this.downloadRegistry();
            HashMap<String, HashMap> syncReg = this.scanRegistry(bais);
            HashMap localReg = this.getLocalRegInfo();
            result = this.regMapsDiff(syncReg, localReg) | (this.allShutdown(localReg) ? 0 : 4) | 1;
            if ((result & 2) != 0) {
                int count;
                byte[] buffer = new byte[8192];
                bais.reset();
                FileOutputStream fos = new FileOutputStream(EnvironmentAccess.getContext().getJbiInstanceRoot() + "/tmp/jbi-registry-sync.xml");
                while ((count = bais.read(buffer)) > 0) {
                    fos.write(buffer, 0, count);
                }
                fos.flush();
                fos.close();
            }
        }
        catch (SyncException sEx) {
            e = sEx;
        }
        catch (Exception ex) {
            e = ex;
        }
        if (e != null) {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(b);
            e.printStackTrace(ps);
            ps.flush();
            this.mLogger.info(this.mTranslator.getString("JBI_SYNC_DAS_NOT_AVAILABLE"));
            this.mLogger.fine(this.mTranslator.getString("JBI_SYNC_CHECK_FAILED", b.toString()));
        }
        this.mLogger.fine("JBI-Synchronization required state is: " + result);
        this.mSyncState = result;
    }

    public boolean isSyncRequired() {
        return (this.mSyncState & 2) != 0;
    }

    void getDASDownloadMBeanServer() {
        try {
            this.mMBeanServer = this.mPlatform.getMBeanServerConnection(this.mPlatform.getAdminServerName());
        }
        catch (Exception e) {
            this.mLogger.info(this.mTranslator.getString("JBI_SYNC_DAS_NOT_AVAILABLE"));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            e.printStackTrace(ps);
            ps.flush();
            this.mLogger.fine(this.mTranslator.getString("JBI_SYNC_DAS_FAILURE", baos.toString()));
        }
    }

    public void cleanup() {
        if (this.mMasterRegistry != null) {
            this.mMasterRegistry.destroy();
            this.mMasterRegistry = null;
        }
    }

    synchronized HashMap getLocalRegInfo() {
        if (this.mLocalReg == null) {
            try {
                Document regDoc = EnvironmentAccess.getContext().getReadOnlyRegistry();
                if (regDoc != null) {
                    this.mLocalReg = this.scanRegistry(regDoc);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.mLocalReg;
    }

    public boolean diffRegistry() throws SyncException {
        Properties props = new Properties();
        RegistrySpecImpl rs = null;
        try {
            this.mRegistry = (Registry)EnvironmentAccess.getContext().getRegistry();
            this.mDASRegistryFileName = "config" + File.separator + this.mRegistry.getProperty("com.sun.jbi.registry.file");
            this.mSyncRegistryFileName = this.mRegistry.getProperty("com.sun.jbi.registry.syncfile");
            this.mSyncFolder = EnvironmentAccess.getContext().getJbiInstanceRoot() + "/tmp";
            props.put("com.sun.jbi.registry.file", this.mSyncRegistryFileName);
            props.put("com.sun.jbi.registry.folder", this.mSyncFolder);
            props.put("com.sun.jbi.registry.readonly", "true");
            rs = new RegistrySpecImpl(RegistryType.XML, props, this.mRegistry.getRegistrySpec().getManagementContext());
            this.mMasterRegistry = RegistryBuilder.buildRegistry(rs);
            this.mDiff = new RegistryDiff(this.mMasterRegistry, this.mRegistry, this.mTarget);
            return this.mDiff.computeDiff();
        }
        catch (RegistryException rEx) {
            throw new SyncException(this.mTranslator.getString("JBI_SYNC_CONFIG_DIFF", (Object)rEx));
        }
    }

    public List<String> getNewSharedLibraries() {
        return this.mDiff.getNewSharedLibraries();
    }

    public ComponentInfo getNewSharedLibraryInfo(String slName) {
        return this.mDiff.getNewSharedLibraryInfo(slName);
    }

    public List<String> getOldSharedLibraries() {
        return this.mDiff.getOldSharedLibraries();
    }

    public List<String> getReplacedSharedLibraries() {
        return this.mDiff.getReplacedSharedLibraries();
    }

    public List<String> getReplacedServiceAssemblies() {
        return this.mDiff.getReplacedServiceAssemblies();
    }

    public List<String> getNewComponents() {
        return this.mDiff.getNewComponents();
    }

    public List<String> getUpdatedComponents() {
        return this.mDiff.getUpdatedComponents();
    }

    public List<String> getReplacedComponents() {
        return this.mDiff.getReplacedComponents();
    }

    public ComponentInfo getNewComponentInfo(String compName) {
        return this.mDiff.getNewComponentInfo(compName);
    }

    public List<String> getOldComponents() {
        return this.mDiff.getOldComponents();
    }

    public List<String> getChangedLifeCycleComponents() {
        return this.mDiff.getChangedLifeCycleComponents();
    }

    public List<String> getAffectedComponents() {
        return this.mDiff.getAffectedComponents();
    }

    public List<String> getNewServiceAssemblies() {
        return this.mDiff.getNewServiceAssemblies();
    }

    public List<String> getOldServiceAssemblies() {
        return this.mDiff.getOldServiceAssemblies();
    }

    public ServiceAssemblyState getNewServiceAssemblyState(String saName) {
        return this.mDiff.getNewServiceAssemblyState(saName);
    }

    public List<String> getAffectedServiceAssemblies() {
        return this.mDiff.getAffectedServiceAssemblies();
    }

    public List<String> getChangedLifeCycleServiceAssemblies() {
        return this.mDiff.getChangedLifeCycleServiceAssemblies();
    }

    public List<String> componentsToStartForDeploy() {
        return this.mDiff.componentsToStartForDeploy();
    }

    public List<String> componentsToStartForUndeploy() {
        return this.mDiff.componentsToStartForUndeploy();
    }

    public List<String> getChangedConfigComponents() {
        return this.mDiff.getChangedConfigComponents();
    }

    public Map<String, String> getGlobalConfigChanges(String category) {
        return this.mDiff.getGlobalConfigChanges(category);
    }

    public Map<String, String> getConfigChanges(String category) {
        return this.mDiff.getConfigChanges(category);
    }

    public Map<String, Properties> getComponentPropertyUpdates() {
        return this.mDiff.getComponentPropertyUpdates();
    }

    public Map<String, ComponentInfo.Variable[]> getAddComponentAppVars() {
        return this.mDiff.getAddComponentAppVars();
    }

    public Map<String, String[]> getRemoveComponentAppVars() {
        return this.mDiff.getRemoveComponentAppVars();
    }

    public Map<String, Map<String, Properties>> getAddComponentConfigs() {
        return this.mDiff.getAddComponentConfigs();
    }

    public Map<String, String> getRemoveComponentConfigs() {
        return this.mDiff.getRemoveComponentConfigs();
    }

    public String downloadSharedLibraryArchive(String slName) throws SyncException {
        Object e = null;
        try {
            Object slId = this.getSharedLibraryArchiveId(slName);
            ComponentInfo ci = this.mDiff.getNewSharedLibraryInfo(slName);
            GenericQuery mQuery = this.mMasterRegistry.getGenericQuery();
            String reposFilename = mQuery.getSharedLibraryFileName(ci.getName());
            long timestamp = mQuery.getSharedLibraryTimestamp(ci.getName());
            return this.downloadFile(slId, reposFilename, timestamp);
        }
        catch (Exception ex) {
            throw new SyncException(this.mTranslator.getString("JBI_SYNC_ARCHIVE", ex));
        }
    }

    public String downloadComponentArchive(String compName) throws SyncException {
        try {
            Object cId = this.getComponentArchiveId(compName);
            ComponentInfo ci = this.mDiff.getNewComponentInfo(compName);
            GenericQuery mQuery = this.mMasterRegistry.getGenericQuery();
            String reposFilename = mQuery.getComponentFileName(ci.getName());
            long timestamp = mQuery.getComponentTimestamp(ci.getName());
            return this.downloadFile(cId, reposFilename, timestamp);
        }
        catch (Exception ex) {
            throw new SyncException(this.mTranslator.getString("JBI_SYNC_ARCHIVE", ex));
        }
    }

    public String downloadServiceAssemblyArchive(String saName) throws SyncException {
        try {
            Object saaId = this.getServiceAssemblyArchiveId(saName);
            ServiceAssemblyInfo sai = this.mDiff.getNewServiceAssemblyInfo(saName);
            GenericQuery mQuery = this.mMasterRegistry.getGenericQuery();
            String reposFilename = mQuery.getServiceAssemblyFileName(sai.getName());
            long timestamp = mQuery.getServiceAssemblyTimestamp(sai.getName());
            return this.downloadFile(saaId, reposFilename, timestamp);
        }
        catch (Exception ex) {
            throw new SyncException(this.mTranslator.getString("JBI_SYNC_ARCHIVE", ex));
        }
    }

    private String downloadFile(Object fileId, String fileName, long timestamp) throws SyncException {
        File outFile = new File(this.mInstanceRootPath + "/tmp/" + fileName);
        try {
            byte[] buffer;
            Object downId = this.initiateDownload(fileId);
            FileOutputStream fis = new FileOutputStream(outFile);
            while ((buffer = this.downloadBytes(downId, 8192)).length > 0) {
                fis.write(buffer, 0, buffer.length);
            }
            this.terminateDownload(downId);
            fis.flush();
            fis.close();
            if (timestamp != 0L) {
                outFile.setLastModified(timestamp);
            }
            return outFile.getPath();
        }
        catch (Exception ex) {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(b);
            ex.printStackTrace(ps);
            ps.flush();
            throw new SyncException(this.mTranslator.getString("JBI_SYNC_FILE_COPY_FAILED", "jbi-registry.xml", outFile.getName(), b.toString()));
        }
    }

    private ByteArrayInputStream downloadRegistry() throws SyncException {
        try {
            byte[] buffer;
            Object downId = this.initiateRegistryDownload();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((buffer = this.downloadBytes(downId, 8192)).length > 0) {
                baos.write(buffer, 0, buffer.length);
            }
            this.terminateDownload(downId);
            baos.flush();
            baos.close();
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (Exception ex) {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(b);
            if (ex.getCause() != null) {
                ex.getCause().printStackTrace(ps);
            }
            ex.printStackTrace(ps);
            ps.flush();
            throw new SyncException(this.mTranslator.getString("JBI_SYNC_FILE_COPY_FAILED", "jbi-registry.xml", "<Memory>", b.toString()));
        }
    }

    private Object getServiceAssemblyArchiveId(String saName) throws Exception {
        Object[] params = new Object[]{saName};
        String[] sign = new String[]{"java.lang.String"};
        return this.mMBeanServer.invoke(this.mDASDownloadMBeanName, "getServiceAssemblyArchiveId", params, sign);
    }

    private Object getComponentArchiveId(String componentName) throws Exception {
        Object[] params = new Object[]{componentName};
        String[] sign = new String[]{"java.lang.String"};
        return this.mMBeanServer.invoke(this.mDASDownloadMBeanName, "getComponentArchiveId", params, sign);
    }

    private Object getSharedLibraryArchiveId(String sharedLibraryName) throws Exception {
        Object[] params = new Object[]{sharedLibraryName};
        String[] sign = new String[]{"java.lang.String"};
        return this.mMBeanServer.invoke(this.mDASDownloadMBeanName, "getSharedLibraryArchiveId", params, sign);
    }

    private Object initiateDownload(Object archiveId) throws Exception {
        Object[] params = new Object[]{archiveId};
        String[] sign = new String[]{"java.lang.Object"};
        return this.mMBeanServer.invoke(this.mDASDownloadMBeanName, "initiateDownload", params, sign);
    }

    private Object initiateRegistryDownload() throws Exception {
        return this.mMBeanServer.invoke(this.mDASDownloadMBeanName, "initiateRegistryDownload", new Object[0], new String[0]);
    }

    private byte[] downloadBytes(Object downId, int count) throws Exception {
        Object[] params = new Object[]{downId, count};
        String[] sign = new String[]{"java.lang.Object", "int"};
        return (byte[])this.mMBeanServer.invoke(this.mDASDownloadMBeanName, "downloadBytes", params, sign);
    }

    private void terminateDownload(Object downId) throws Exception {
        Object[] params = new Object[]{downId};
        String[] sign = new String[]{"java.lang.Object"};
        this.mMBeanServer.invoke(this.mDASDownloadMBeanName, "terminateDownload", params, sign);
    }

    private HashMap<String, HashMap> scanRegistry(InputStream is) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(is);
        return this.scanRegistry(doc);
    }

    private HashMap<String, HashMap> scanRegistry(Document doc) throws Exception {
        String targetName = this.mPlatform.getTargetName();
        HashMap<String, HashMap> result = new HashMap<String, HashMap>();
        Element target = null;
        NodeList instances = this.mPlatform.isStandaloneServer(targetName) ? doc.getDocumentElement().getElementsByTagName("server") : doc.getDocumentElement().getElementsByTagName("cluster");
        if (instances != null) {
            for (int i = 0; i < instances.getLength(); ++i) {
                Element instance = (Element)instances.item(i);
                if (!instance.getAttribute(JBI_SCHEMA_NAME_REF).equalsIgnoreCase(targetName)) continue;
                target = instance;
                break;
            }
            if (target != null) {
                result.put(COMP_KEY, RegistryHelper.makeRefMap(RegistryHelper.makeElementMap(doc.getDocumentElement(), JBI_SCHEMA_COMPONENT), target, JBI_SCHEMA_COMPONENT_REF, JBI_SCHEMA_NAME_REF));
                result.put(SL_KEY, RegistryHelper.makeRefMap(RegistryHelper.makeElementMap(doc.getDocumentElement(), JBI_SCHEMA_SHARED_LIBRARY), target, JBI_SCHEMA_SHARED_LIBRARY_REF, JBI_SCHEMA_NAME_REF));
                result.put(SA_KEY, RegistryHelper.makeSURefMap(RegistryHelper.makeElementMap(doc.getDocumentElement(), JBI_SCHEMA_SERVICE_ASSEMBLY), target));
                result.put("domain", RegistryHelper.makeConfigMap(doc.getDocumentElement(), "domain-config"));
                result.put(INSTANCE_KEY, RegistryHelper.makeConfigMap(doc.getDocumentElement(), targetName + "-config"));
                RegistryHelper.makeConfigurationMap(result, target);
            }
        }
        return result;
    }

    private static HashMap<String, HashMap> makeConfigMap(Element e, String targetName) {
        Element instance;
        int i;
        Element target = null;
        HashMap<String, HashMap> configMap = new HashMap<String, HashMap>();
        NodeList instances = e.getElementsByTagName("config");
        if (instances != null) {
            for (i = 0; i < instances.getLength(); ++i) {
                instance = (Element)instances.item(i);
                if (!instance.getAttribute(JBI_SCHEMA_NAME).equalsIgnoreCase(targetName)) continue;
                target = instance;
                break;
            }
        }
        if (target != null && (instances = target.getElementsByTagName(JBI_SCHEMA_CONFIG_TYPE)) != null) {
            for (i = 0; i < instances.getLength(); ++i) {
                instance = (Element)instances.item(i);
                String category = instance.getAttribute(JBI_SCHEMA_CATEGORY);
                if (category.equals("Logger")) continue;
                NodeList properties = instance.getElementsByTagName(JBI_SCHEMA_PROPERTY);
                HashMap<String, String> map = null;
                if (properties == null) continue;
                map = new HashMap<String, String>();
                for (int j = 0; j < properties.getLength(); ++j) {
                    String value;
                    String name;
                    Element property = (Element)properties.item(j);
                    Text prop1 = (Text)property.getFirstChild();
                    Text prop2 = (Text)property.getLastChild();
                    if (prop1.getWholeText().equals(JBI_SCHEMA_NAME)) {
                        name = prop1.getWholeText();
                        value = prop2.getWholeText();
                    } else {
                        name = prop2.getWholeText();
                        value = prop1.getWholeText();
                    }
                    map.put(name, value);
                }
                configMap.put(category, map);
            }
        }
        return configMap;
    }

    private static HashMap<String, EntityInfo> makeElementMap(Element e, String tag) {
        HashMap<String, EntityInfo> map = new HashMap<String, EntityInfo>();
        NodeList tags = e.getElementsByTagName(tag);
        for (int i = 0; i < tags.getLength(); ++i) {
            Element instance = (Element)tags.item(i);
            EntityInfo ei = new EntityInfo();
            ei.mName = instance.getAttribute(JBI_SCHEMA_NAME);
            ei.mTimestamp = instance.getAttribute(JBI_SCHEMA_TIMESTAMP);
            ei.mUpdateNumber = instance.getAttribute(JBI_SCHEMA_UPDATENUMBER);
            if (ei.mUpdateNumber == null) {
                ei.mUpdateNumber = "";
            }
            map.put(ei.mName, ei);
        }
        return map;
    }

    private static HashMap<String, EntityInfo> makeRefMap(HashMap<String, EntityInfo> emap, Element e, String tag, String nametag) {
        HashMap<String, EntityInfo> map = new HashMap<String, EntityInfo>();
        NodeList tags = e.getElementsByTagName(tag);
        for (int i = 0; i < tags.getLength(); ++i) {
            Element instance = (Element)tags.item(i);
            String nameref = instance.getAttribute(nametag);
            EntityInfo ei = emap.get(nameref);
            if (nameref == null) continue;
            ei.mState = instance.getAttribute(JBI_SCHEMA_STATE);
            ei.mUpdateNumber = instance.getAttribute(JBI_SCHEMA_UPDATENUMBER);
            if (ei.mUpdateNumber == null) {
                ei.mUpdateNumber = "";
            }
            map.put(nameref, ei);
        }
        return map;
    }

    private static HashMap<String, EntityInfo> makeSURefMap(HashMap<String, EntityInfo> emap, Element e) {
        HashMap<String, EntityInfo> map = new HashMap<String, EntityInfo>();
        NodeList tags = e.getElementsByTagName(JBI_SCHEMA_SERVICE_UNIT);
        for (int i = 0; i < tags.getLength(); ++i) {
            Element instance = (Element)tags.item(i);
            String sanameref = instance.getAttribute(JBI_SCHEMA_SERVICE_ASSEMBLY_REF);
            if (sanameref == null) continue;
            EntityInfo ei = emap.get(sanameref);
            EntityInfo nei = new EntityInfo();
            nei.mName = instance.getAttribute(JBI_SCHEMA_NAME);
            nei.mState = instance.getAttribute(JBI_SCHEMA_STATE);
            nei.mUpdateNumber = instance.getAttribute(JBI_SCHEMA_UPDATENUMBER);
            if (nei.mUpdateNumber == null) {
                nei.mUpdateNumber = "";
            }
            nei.mTimestamp = ei.mTimestamp;
            map.put(nei.mName, nei);
        }
        return map;
    }

    private static void makeConfigurationMap(HashMap<String, HashMap> result, Element e) {
        NodeList components = e.getElementsByTagName(JBI_SCHEMA_COMPONENT_REF);
        if (components != null) {
            for (int i = 0; i < components.getLength(); ++i) {
                Element config;
                Element ref = (Element)components.item(i);
                String nameRef = ref.getAttribute(JBI_SCHEMA_NAME_REF);
                NodeList configs = ref.getElementsByTagName(JBI_SCHEMA_COMPONENT_CONFIG);
                if (configs == null || (config = (Element)configs.item(0)) == null) continue;
                result.put(STATIC_CONF_KEY, RegistryHelper.getProperties(config));
                result.put(APPVAR_CONF_KEY, RegistryHelper.getApplicationVariables(config));
                result.put(APPCON_CONF_KEY, RegistryHelper.getApplicationConfiguration(config));
            }
        }
    }

    private static HashMap<String, AppVarInfo> getApplicationVariables(Element e) {
        NodeList apps = e.getElementsByTagName(JBI_SCHEMA_APPLICATION_VARIABLE);
        HashMap<String, AppVarInfo> appCon = new HashMap<String, AppVarInfo>();
        if (apps != null) {
            for (int i = 0; i < apps.getLength(); ++i) {
                Element prop = (Element)apps.item(i);
                NodeList names = prop.getElementsByTagName(JBI_SCHEMA_NAME);
                NodeList values = prop.getElementsByTagName(JBI_SCHEMA_VALUE);
                NodeList types = prop.getElementsByTagName(JBI_SCHEMA_TYPE);
                Node nameNode = names.item(0);
                Node valueNode = values.item(0);
                Node typeNode = types.item(0);
                AppVarInfo avi = new AppVarInfo();
                avi.mType = typeNode.getTextContent();
                avi.mValue = valueNode.getTextContent();
                appCon.put(nameNode.getTextContent(), avi);
            }
        }
        return appCon;
    }

    private static HashMap<String, HashMap> getApplicationConfiguration(Element e) {
        NodeList apps = e.getElementsByTagName(JBI_SCHEMA_APPLICATION_CONFIGURATION);
        HashMap<String, HashMap> appCon = new HashMap<String, HashMap>();
        if (apps != null) {
            for (int i = 0; i < apps.getLength(); ++i) {
                Element app = (Element)apps.item(i);
                String appconName = app.getAttribute(JBI_SCHEMA_NAME);
                appCon.put(appconName, RegistryHelper.getProperties(app));
            }
        }
        return appCon;
    }

    private static HashMap<String, String> getProperties(Element e) {
        NodeList props = e.getElementsByTagName(JBI_SCHEMA_PROPERTY);
        HashMap<String, String> result = new HashMap<String, String>();
        if (props != null) {
            for (int i = 0; i < props.getLength(); ++i) {
                Element prop = (Element)props.item(i);
                NodeList names = prop.getElementsByTagName(JBI_SCHEMA_NAME);
                NodeList values = prop.getElementsByTagName(JBI_SCHEMA_VALUE);
                Node nameNode = names.item(0);
                Node valueNode = values.item(0);
                result.put(nameNode.getTextContent(), valueNode.getTextContent());
            }
        }
        return result;
    }

    private boolean allShutdown(HashMap map) {
        HashMap local;
        boolean result = true;
        if (map != null && (local = (HashMap)map.get(COMP_KEY)) != null) {
            for (Map.Entry e : local.entrySet()) {
                EntityInfo ie = (EntityInfo)e.getValue();
                if (ie.mState.equals(ComponentState.getLifeCycleState(ComponentState.SHUTDOWN))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private int regMapsDiff(HashMap syncMap, HashMap localMap) {
        int result;
        int n = result = localMap == null ? 2 : 0;
        if (result != 2) {
            result = this.diff(syncMap, localMap, COMP_KEY);
        }
        if (result != 2) {
            result = this.diff(syncMap, localMap, SL_KEY);
        }
        if (result != 2) {
            result = this.diff(syncMap, localMap, SA_KEY);
        }
        if (result != 2) {
            result = this.diffConfig(syncMap, localMap, "domain");
        }
        if (result != 2) {
            result = this.diffConfig(syncMap, localMap, INSTANCE_KEY);
        }
        if (result != 2) {
            result = this.diffStaticProps(syncMap, localMap, STATIC_CONF_KEY);
        }
        if (result != 2) {
            result = this.diffAppVars(syncMap, localMap, APPVAR_CONF_KEY);
        }
        if (result != 2) {
            result = this.diffAppConf(syncMap, localMap, APPCON_CONF_KEY);
        }
        return result;
    }

    private int diff(HashMap<String, HashMap> syncMap, HashMap<String, HashMap> localMap, String key) {
        HashMap sync = syncMap.get(key);
        HashMap local = localMap.get(key);
        int result = 2;
        if (sync != null && local != null && sync.size() == local.size()) {
            result = 0;
            for (Map.Entry e : sync.entrySet()) {
                EntityInfo sie = (EntityInfo)e.getValue();
                EntityInfo lie = (EntityInfo)local.get(sie.mName);
                if (lie != null && sie.mTimestamp.equals(lie.mTimestamp) && sie.mState.equals(lie.mState) && sie.mUpdateNumber.equals(lie.mUpdateNumber)) continue;
                result = 2;
                break;
            }
        }
        return result;
    }

    private int diffConfig(HashMap<String, HashMap> syncMap, HashMap<String, HashMap> localMap, String key) {
        HashMap sync = syncMap.get(key);
        HashMap local = localMap.get(key);
        int result = 2;
        if (sync != null && local != null && sync.size() == local.size()) {
            result = 0;
            for (Map.Entry e : sync.entrySet()) {
                String category = (String)e.getKey();
                HashMap cats = (HashMap)e.getValue();
                HashMap locals = (HashMap)local.get(category);
                if (locals != null && cats.size() == locals.size()) {
                    for (String name : cats.keySet()) {
                        String value = (String)locals.get(name);
                        if (value != null && ((String)cats.get(name)).equals(value)) continue;
                        result = 2;
                        break;
                    }
                    if (result == 0) continue;
                }
                result = 2;
                break;
            }
        }
        return result;
    }

    private int diffStaticProps(HashMap<String, HashMap> syncMap, HashMap<String, HashMap> localMap, String key) {
        HashMap sync = syncMap.get(key);
        HashMap local = localMap.get(key);
        int result = 2;
        return this.diffProps(sync, local);
    }

    private int diffAppVars(HashMap<String, HashMap> syncMap, HashMap<String, HashMap> localMap, String key) {
        HashMap sync = syncMap.get(key);
        HashMap local = localMap.get(key);
        int result = 0;
        if (sync != null || local != null) {
            result = 2;
            if (sync != null && local != null && sync.size() == local.size()) {
                result = 0;
                for (Map.Entry e : sync.entrySet()) {
                    String confKey = (String)e.getKey();
                    AppVarInfo value = (AppVarInfo)e.getValue();
                    AppVarInfo localValue = (AppVarInfo)local.get(confKey);
                    if (localValue != null && value.mType.equals(localValue.mType) && value.mValue.equals(localValue.mValue)) continue;
                    result = 2;
                    break;
                }
            }
        }
        return result;
    }

    private int diffAppConf(HashMap<String, HashMap> syncMap, HashMap<String, HashMap> localMap, String key) {
        HashMap sync = syncMap.get(key);
        HashMap local = localMap.get(key);
        int result = 0;
        if (sync != null || local != null) {
            result = 2;
            if (sync != null && local != null && sync.size() == local.size()) {
                result = 0;
                for (Map.Entry e : sync.entrySet()) {
                    HashMap localValue;
                    String config = (String)e.getKey();
                    HashMap value = (HashMap)e.getValue();
                    if (this.diffProps(value, localValue = (HashMap)local.get(config)) == 0) continue;
                    result = 2;
                    break;
                }
            }
        }
        return result;
    }

    private int diffProps(HashMap<String, String> sync, HashMap<String, String> local) {
        int result = 0;
        if (sync != null || local != null) {
            result = 2;
            if (sync != null && local != null && sync.size() == local.size()) {
                result = 0;
                for (Map.Entry<String, String> e : sync.entrySet()) {
                    String confKey = e.getKey();
                    String value = e.getValue();
                    String localValue = local.get(confKey);
                    if (localValue != null && value.equals(localValue)) continue;
                    result = 2;
                    break;
                }
            }
        }
        return result;
    }

    public void displayActions() {
        this.mLogger.info(this.mDiff.toString());
    }
}

