/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework.sun;

import com.sun.appserv.server.LifecycleEvent;
import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.ServerLifecycleException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;

public class SunASJBIBootstrap
implements LifecycleListener {
    private LifecycleListener mFramework;
    private URLClassLoader mJbiClassLoader;
    private URLClassLoader mRuntimeClassLoader;
    private static final String JBI_HOME_PROPERTY = "com.sun.jbi.home";
    private static final String JBI_LIB = "lib";
    private static final String JBI_JAR_NAME = "jbi.jar";
    private static final String JBI_EXT_JAR_NAME = "jbi-ext.jar";
    private static final String JBI_FRAMEWORK_JAR_NAME = "jbi_framework.jar";
    private static final String JBI_FRAMEWORK_CLASS_NAME = "com.sun.jbi.framework.sun.SunASJBIFramework";

    public void handleEvent(LifecycleEvent anEvent) throws ServerLifecycleException {
        try {
            if (0 == anEvent.getEventType()) {
                this.setUpClassLoaders((Properties)anEvent.getData());
                this.mFramework = this.getJBIFramework();
            }
            this.mFramework.handleEvent(anEvent);
        }
        catch (ServerLifecycleException slEx) {
            throw slEx;
        }
        catch (Throwable ex) {
            throw new ServerLifecycleException(ex);
        }
    }

    private void setUpClassLoaders(Properties ctxProperties) throws Exception, MalformedURLException {
        String jbiRoot = ctxProperties.getProperty(JBI_HOME_PROPERTY);
        String jarRoot = jbiRoot + File.separator + JBI_LIB;
        ArrayList<String> jarFiles = new ArrayList<String>();
        jarFiles.add(jarRoot + File.separator + JBI_JAR_NAME);
        jarFiles.add(jarRoot + File.separator + JBI_EXT_JAR_NAME);
        URL[] jarURLs = this.list2URLArray(jarFiles);
        this.mJbiClassLoader = new URLClassLoader(jarURLs, this.getClass().getClassLoader().getParent().getParent());
        jarFiles = new ArrayList();
        jarFiles.add(jarRoot + File.separator + JBI_FRAMEWORK_JAR_NAME);
        jarURLs = this.list2URLArray(jarFiles);
        this.mRuntimeClassLoader = new URLClassLoader(jarURLs, (ClassLoader)this.mJbiClassLoader);
    }

    private URL[] list2URLArray(List paths) throws MalformedURLException {
        URL[] urls = new URL[paths.size()];
        int i = 0;
        ListIterator itr = paths.listIterator();
        while (itr.hasNext()) {
            String nextCPElement = (String)itr.next();
            File f = new File(nextCPElement);
            urls[i++] = f.toURL();
        }
        return urls;
    }

    private LifecycleListener getJBIFramework() throws ServerLifecycleException {
        Object o;
        try {
            o = this.mRuntimeClassLoader.loadClass(JBI_FRAMEWORK_CLASS_NAME).newInstance();
        }
        catch (ClassNotFoundException cnfEx) {
            throw new ServerLifecycleException((Throwable)cnfEx);
        }
        catch (IllegalAccessException iaEx) {
            throw new ServerLifecycleException((Throwable)iaEx);
        }
        catch (InstantiationException inEx) {
            throw new ServerLifecycleException((Throwable)inEx);
        }
        return (LifecycleListener)o;
    }
}

